/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.server;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.queue.clustered.server.LoadBalanceAuthorizer;
import org.apache.nifi.controller.queue.clustered.server.NotAuthorizedException;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.security.cert.PeerIdentityProvider;
import org.apache.nifi.security.cert.StandardPeerIdentityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterLoadBalanceAuthorizer
implements LoadBalanceAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(ClusterLoadBalanceAuthorizer.class);
    private final PeerIdentityProvider peerIdentityProvider = new StandardPeerIdentityProvider();
    private final ClusterCoordinator clusterCoordinator;
    private final EventReporter eventReporter;
    private final HostnameVerifier hostnameVerifier;

    public ClusterLoadBalanceAuthorizer(ClusterCoordinator clusterCoordinator, EventReporter eventReporter) {
        this.clusterCoordinator = clusterCoordinator;
        this.eventReporter = eventReporter;
        this.hostnameVerifier = new DefaultHostnameVerifier();
    }

    @Override
    public String authorize(SSLSocket sslSocket) throws IOException {
        SSLSession sslSession = sslSocket.getSession();
        Certificate[] peerCertificates = sslSession.getPeerCertificates();
        Set clientIdentities = this.peerIdentityProvider.getIdentities(peerCertificates);
        logger.debug("Will perform authorization against Client Identities '{}'", (Object)clientIdentities);
        Set nodeIds = this.clusterCoordinator.getNodeIdentifiers(new NodeConnectionState[0]).stream().map(NodeIdentifier::getApiAddress).collect(Collectors.toSet());
        for (String clientId : clientIdentities) {
            if (!nodeIds.contains(clientId)) continue;
            logger.debug("Client ID '{}' is in the list of Nodes in the Cluster. Authorizing Client to Load Balance data", (Object)clientId);
            return clientId;
        }
        for (String nodeId : nodeIds) {
            if (!this.hostnameVerifier.verify(nodeId, sslSession)) continue;
            String clientId = sslSocket.getInetAddress().getHostName();
            logger.debug("The request was verified with node '{}'. The hostname derived from the socket is '{}'. Authorizing Client to Load Balance data", (Object)nodeId, (Object)clientId);
            return clientId;
        }
        String message = "Authorization failed for Client ID's to Load Balance data because none of the ID's are known Cluster Node Identifiers";
        logger.warn("Authorization failed for Client ID's to Load Balance data because none of the ID's are known Cluster Node Identifiers");
        this.eventReporter.reportEvent(Severity.WARNING, "Load Balanced Connections", "Authorization failed for Client ID's to Load Balance data because none of the ID's are known Cluster Node Identifiers");
        throw new NotAuthorizedException("Client ID's " + String.valueOf(clientIdentities) + " are not authorized to Load Balance data");
    }
}

