/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history.questdb;

import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.SqlExecutionContext;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QuestDbWritingTemplate<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuestDbWritingTemplate.class);
    private final String tableName;

    protected QuestDbWritingTemplate(String tableName) {
        this.tableName = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(CairoEngine engine, SqlExecutionContext context, Collection<T> entries) {
        if (entries.isEmpty()) {
            return;
        }
        TableToken tableToken = engine.getTableTokenIfExists((CharSequence)this.tableName);
        if (tableToken == null) {
            LOGGER.error("Table Token for table [{}] not found", (Object)this.tableName);
        } else {
            try (TableWriter tableWriter = engine.getWriter(tableToken, "adding rows");){
                this.addRows(tableWriter, entries);
                tableWriter.commit();
            }
            catch (Exception e) {
                LOGGER.error("Add rows [{}] to table [{}] failed", new Object[]{entries.size(), this.tableName, e});
            }
            finally {
                engine.releaseInactive();
            }
        }
    }

    protected abstract void addRows(TableWriter var1, Collection<T> var2);
}

