/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.swap;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.IncompleteSwapFileException;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.SwapContents;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.controller.swap.StandardSwapContents;
import org.apache.nifi.controller.swap.StandardSwapSummary;
import org.apache.nifi.controller.swap.SwapDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSwapDeserializer
implements SwapDeserializer {
    public static final int SWAP_ENCODING_VERSION = 10;
    private static final Logger logger = LoggerFactory.getLogger(SimpleSwapDeserializer.class);

    @Override
    public SwapSummary getSwapSummary(DataInputStream in, String swapLocation, ResourceClaimManager claimManager) throws IOException {
        long contentSize;
        int numRecords;
        int swapEncodingVersion = in.readInt();
        if (swapEncodingVersion > 10) {
            String errMsg = "Cannot swap FlowFiles in from " + swapLocation + " because the encoding version is " + swapEncodingVersion + ", which is too new (expecting 10 or less)";
            throw new IOException(errMsg);
        }
        Long maxRecordId = null;
        try {
            in.readUTF();
            numRecords = in.readInt();
            contentSize = in.readLong();
            if (numRecords == 0) {
                return StandardSwapSummary.EMPTY_SUMMARY;
            }
            if (swapEncodingVersion > 7) {
                maxRecordId = in.readLong();
            }
        }
        catch (EOFException eof) {
            logger.warn("Found premature End-of-File when reading Swap File {}. EOF occurred before any FlowFiles were encountered", (Object)swapLocation);
            return StandardSwapSummary.EMPTY_SUMMARY;
        }
        QueueSize queueSize = new QueueSize(numRecords, contentSize);
        SwapContents swapContents = SimpleSwapDeserializer.deserializeFlowFiles(in, queueSize, maxRecordId, swapEncodingVersion, claimManager, swapLocation);
        return swapContents.getSummary();
    }

    @Override
    public SwapContents deserializeFlowFiles(DataInputStream in, String swapLocation, FlowFileQueue queue, ResourceClaimManager claimManager) throws IOException {
        int swapEncodingVersion = in.readInt();
        if (swapEncodingVersion > 10) {
            throw new IOException("Cannot swap FlowFiles in from SwapFile because the encoding version is " + swapEncodingVersion + ", which is too new (expecting 10 or less)");
        }
        String connectionId = in.readUTF();
        if (!connectionId.equals(queue.getIdentifier())) {
            throw new IllegalArgumentException("Cannot deserialize FlowFiles from Swap File at location " + swapLocation + " because those FlowFiles belong to Connection with ID " + connectionId + " and an attempt was made to swap them into a Connection with ID " + queue.getIdentifier());
        }
        int numRecords = 0;
        long contentSize = 0L;
        Long maxRecordId = null;
        try {
            numRecords = in.readInt();
            contentSize = in.readLong();
            if (swapEncodingVersion > 7) {
                maxRecordId = in.readLong();
            }
        }
        catch (EOFException eof) {
            QueueSize queueSize = new QueueSize(numRecords, contentSize);
            StandardSwapSummary summary = new StandardSwapSummary(queueSize, maxRecordId, Collections.emptyList(), 0L, 0L);
            StandardSwapContents partialContents = new StandardSwapContents(summary, Collections.emptyList());
            throw new IncompleteSwapFileException(swapLocation, (SwapContents)partialContents);
        }
        QueueSize queueSize = new QueueSize(numRecords, contentSize);
        return SimpleSwapDeserializer.deserializeFlowFiles(in, queueSize, maxRecordId, swapEncodingVersion, claimManager, swapLocation);
    }

    private static SwapContents deserializeFlowFiles(DataInputStream in, QueueSize queueSize, Long maxRecordId, int serializationVersion, ResourceClaimManager claimManager, String location) throws IOException {
        ArrayList<FlowFileRecord> flowFiles = new ArrayList<FlowFileRecord>(queueSize.getObjectCount());
        ArrayList<ResourceClaim> resourceClaims = new ArrayList<ResourceClaim>(queueSize.getObjectCount());
        Long maxId = maxRecordId;
        for (int i = 0; i < queueSize.getObjectCount(); ++i) {
            try {
                int action;
                if (serializationVersion < 3 && (action = in.read()) != 1) {
                    throw new IOException("Swap File is version " + serializationVersion + " but did not contain a 'UPDATE' record type");
                }
                StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder();
                long recordId = in.readLong();
                if (maxId == null || recordId > maxId) {
                    maxId = recordId;
                }
                ffBuilder.id(recordId);
                ffBuilder.entryDate(in.readLong());
                if (serializationVersion > 1) {
                    if (serializationVersion < 10) {
                        int numLineageIdentifiers = in.readInt();
                        for (int lineageIdIdx = 0; lineageIdIdx < numLineageIdentifiers; ++lineageIdIdx) {
                            in.readUTF();
                        }
                    }
                    long lineageStartDate = in.readLong();
                    long lineageStartIndex = serializationVersion > 8 ? in.readLong() : 0L;
                    ffBuilder.lineageStart(lineageStartDate, lineageStartIndex);
                    if (serializationVersion > 5) {
                        long lastQueueDate = in.readLong();
                        long queueDateIndex = serializationVersion > 8 ? in.readLong() : 0L;
                        ffBuilder.lastQueued(lastQueueDate, queueDateIndex);
                    }
                }
                ffBuilder.size(in.readLong());
                if (serializationVersion < 3) {
                    SimpleSwapDeserializer.readString(in);
                }
                boolean hasClaim = in.readBoolean();
                ResourceClaim resourceClaim = null;
                if (hasClaim) {
                    long resourceLength;
                    long resourceOffset;
                    String claimId = serializationVersion < 5 ? String.valueOf(in.readLong()) : in.readUTF();
                    String container = in.readUTF();
                    String section = in.readUTF();
                    if (serializationVersion < 6) {
                        resourceOffset = 0L;
                        resourceLength = -1L;
                    } else {
                        resourceOffset = in.readLong();
                        resourceLength = in.readLong();
                    }
                    long claimOffset = in.readLong();
                    boolean lossTolerant = serializationVersion >= 4 ? in.readBoolean() : false;
                    resourceClaim = claimManager.getResourceClaim(container, section, claimId);
                    if (resourceClaim == null) {
                        logger.error("Swap file indicates that FlowFile was referencing Resource Claim at container={}, section={}, claimId={}, but this Resource Claim cannot be found! Will create a temporary Resource Claim, but this may affect the framework's ability to properly clean up this resource", new Object[]{container, section, claimId});
                        resourceClaim = claimManager.newResourceClaim(container, section, claimId, lossTolerant, true);
                    }
                    StandardContentClaim claim = new StandardContentClaim(resourceClaim, resourceOffset);
                    claim.setLength(resourceLength);
                    ffBuilder.contentClaim((ContentClaim)claim);
                    ffBuilder.contentClaimOffset(claimOffset);
                }
                boolean attributesChanged = true;
                if (serializationVersion < 3) {
                    attributesChanged = in.readBoolean();
                }
                if (attributesChanged) {
                    int numAttributes = in.readInt();
                    for (int j = 0; j < numAttributes; ++j) {
                        String key = SimpleSwapDeserializer.readString(in);
                        String value = SimpleSwapDeserializer.readString(in);
                        ffBuilder.addAttribute(key, value);
                    }
                }
                FlowFileRecord record = ffBuilder.build();
                if (resourceClaim != null) {
                    resourceClaims.add(resourceClaim);
                }
                flowFiles.add(record);
                continue;
            }
            catch (EOFException eof) {
                StandardSwapSummary swapSummary = new StandardSwapSummary(queueSize, maxId, resourceClaims, 0L, 0L);
                StandardSwapContents partialContents = new StandardSwapContents(swapSummary, flowFiles);
                throw new IncompleteSwapFileException(location, (SwapContents)partialContents);
            }
        }
        StandardSwapSummary swapSummary = new StandardSwapSummary(queueSize, maxId, resourceClaims, 0L, 0L);
        return new StandardSwapContents(swapSummary, flowFiles);
    }

    private static String readString(InputStream in) throws IOException {
        Integer numBytes = SimpleSwapDeserializer.readFieldLength(in);
        if (numBytes == null) {
            throw new EOFException();
        }
        byte[] bytes = new byte[numBytes.intValue()];
        SimpleSwapDeserializer.fillBuffer(in, bytes, numBytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static Integer readFieldLength(InputStream in) throws IOException {
        int firstValue = in.read();
        int secondValue = in.read();
        if (firstValue < 0) {
            return null;
        }
        if (secondValue < 0) {
            throw new EOFException();
        }
        if (firstValue == 255 && secondValue == 255) {
            int ch4;
            int ch3;
            int ch2;
            int ch1 = in.read();
            if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
                throw new EOFException();
            }
            return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
        }
        return (firstValue << 8) + secondValue;
    }

    private static void fillBuffer(InputStream in, byte[] buffer, int length) throws IOException {
        int bytesRead;
        int totalBytesRead = 0;
        while ((bytesRead = in.read(buffer, totalBytesRead, length - totalBytesRead)) > 0) {
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead != length) {
            throw new EOFException();
        }
    }
}

