/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.tasks;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.lifecycle.TaskTerminationAwareStateManager;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.RepositoryContext;
import org.apache.nifi.controller.repository.StandardProcessSession;
import org.apache.nifi.controller.repository.metrics.PerformanceTracker;
import org.apache.nifi.controller.repository.metrics.StandardFlowFileEvent;
import org.apache.nifi.controller.repository.scheduling.ConnectableProcessContext;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.RepositoryContextFactory;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.tasks.InvocationResult;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.util.Connectables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectableTask {
    private static final Logger logger = LoggerFactory.getLogger(ConnectableTask.class);
    private final SchedulingAgent schedulingAgent;
    private final Connectable connectable;
    private final RepositoryContext repositoryContext;
    private final LifecycleState lifecycleState;
    private final ProcessContext processContext;
    private final FlowController flowController;
    private final int numRelationships;
    private final ThreadMXBean threadMXBean;
    private final AtomicLong invocations = new AtomicLong(0L);
    private volatile SampledMetrics sampledMetrics = new SampledMetrics();
    private final int perfTrackingNthIteration;

    public ConnectableTask(SchedulingAgent schedulingAgent, Connectable connectable, FlowController flowController, RepositoryContextFactory contextFactory, LifecycleState lifecycleState) {
        this.schedulingAgent = schedulingAgent;
        this.connectable = connectable;
        this.lifecycleState = lifecycleState;
        this.numRelationships = connectable.getRelationships().size();
        this.flowController = flowController;
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        TaskTerminationAwareStateManager stateManager = new TaskTerminationAwareStateManager(flowController.getStateManagerProvider().getStateManager(connectable.getIdentifier()), () -> ((LifecycleState)lifecycleState).isTerminated());
        this.processContext = connectable instanceof ProcessorNode ? new StandardProcessContext((ProcessorNode)connectable, flowController.getControllerServiceProvider(), (StateManager)stateManager, () -> ((LifecycleState)lifecycleState).isTerminated(), (NodeTypeProvider)flowController) : new ConnectableProcessContext(connectable, (StateManager)stateManager);
        this.repositoryContext = contextFactory.newProcessContext(connectable, new AtomicLong(0L));
        int perfTrackingPercentage = flowController.getPerformanceTrackingPercentage();
        this.perfTrackingNthIteration = perfTrackingPercentage == 0 ? 0 : 100 / perfTrackingPercentage;
    }

    public Connectable getConnectable() {
        return this.connectable;
    }

    private boolean isRunOnCluster(FlowController flowController) {
        return !this.connectable.isIsolated() || !flowController.isConfiguredForClustering() || flowController.isPrimary();
    }

    private boolean isYielded() {
        return this.connectable.getYieldExpiration() > System.currentTimeMillis();
    }

    private boolean isWorkToDo() {
        boolean hasNonLoopConnection = Connectables.hasNonLoopConnection((Connectable)this.connectable);
        if (this.connectable.getConnectableType() == ConnectableType.FUNNEL) {
            return this.connectable.hasIncomingConnection() && hasNonLoopConnection && !this.connectable.getConnections().isEmpty() && Connectables.flowFilesQueued((Connectable)this.connectable);
        }
        boolean isSourceComponent = this.connectable.isTriggerWhenEmpty() || !this.connectable.hasIncomingConnection() || !hasNonLoopConnection;
        return isSourceComponent || Connectables.flowFilesQueued((Connectable)this.connectable);
    }

    private boolean isBackPressureEngaged() {
        return this.connectable.getIncomingConnections().stream().filter(con -> con.getSource() == this.connectable).map(Connection::getFlowFileQueue).anyMatch(FlowFileQueue::isFull);
    }

    /*
     * Exception decompiling
     */
    public InvocationResult invoke() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 51[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateEventRepo(long startNanoTime, long startCpuTime, long startGcMillis, int invocationCount, boolean measureCpuTime, PerformanceTracker performanceTracker) throws IOException {
        long processingNanos = System.nanoTime() - startNanoTime;
        StandardFlowFileEvent flowFileEvent = new StandardFlowFileEvent();
        flowFileEvent.setProcessingNanos(processingNanos);
        flowFileEvent.setInvocations(invocationCount);
        if (measureCpuTime) {
            this.updatePerformanceTrackingMetrics(flowFileEvent, performanceTracker, startCpuTime, startGcMillis, processingNanos);
        } else {
            this.estimatePerformanceTrackingMetrics(flowFileEvent, processingNanos);
        }
        this.repositoryContext.getFlowFileEventRepository().updateRepository((FlowFileEvent)flowFileEvent, this.connectable.getIdentifier());
    }

    private void estimatePerformanceTrackingMetrics(StandardFlowFileEvent flowFileEvent, long processingNanos) {
        SampledMetrics currentMetrics = this.sampledMetrics;
        double processingRatio = (double)processingNanos / (double)Math.max(1L, currentMetrics.getProcessingNanosSampled());
        flowFileEvent.setCpuNanoseconds((long)(processingRatio * (double)currentMetrics.getTotalCpuNanos()));
        flowFileEvent.setContentReadNanoseconds((long)(processingRatio * (double)currentMetrics.getReadNanos()));
        flowFileEvent.setContentWriteNanoseconds((long)(processingRatio * (double)currentMetrics.getWriteNanos()));
        flowFileEvent.setSessionCommitNanos((long)(processingRatio * (double)currentMetrics.getSessionCommitNanos()));
        flowFileEvent.setGarbageCollectionMillis((long)(processingRatio * (double)currentMetrics.getGcMillis()));
    }

    private void updatePerformanceTrackingMetrics(StandardFlowFileEvent flowFileEvent, PerformanceTracker performanceTracker, long startCpuTime, long startGcMillis, long processingNanos) {
        long cpuTime = this.threadMXBean.getCurrentThreadCpuTime();
        long cpuNanos = cpuTime - startCpuTime;
        long endGcMillis = this.flowController.getGarbageCollectionLog().getTotalGarbageCollectionMillis();
        long gcMillis = endGcMillis - startGcMillis;
        flowFileEvent.setCpuNanoseconds(cpuNanos);
        flowFileEvent.setContentWriteNanoseconds(performanceTracker.getContentWriteNanos());
        flowFileEvent.setContentReadNanoseconds(performanceTracker.getContentReadNanos());
        flowFileEvent.setSessionCommitNanos(performanceTracker.getSessionCommitNanos());
        flowFileEvent.setGarbageCollectionMillis(gcMillis);
        SampledMetrics previousMetrics = this.sampledMetrics;
        SampledMetrics updatedMetrics = new SampledMetrics();
        updatedMetrics.setProcessingNanosSampled(previousMetrics.getProcessingNanosSampled() + processingNanos);
        updatedMetrics.setTotalCpuNanos(previousMetrics.getTotalCpuNanos() + cpuNanos);
        updatedMetrics.setReadNanos(previousMetrics.getReadNanos() + performanceTracker.getContentReadNanos());
        updatedMetrics.setWriteNanos(previousMetrics.getWriteNanos() + performanceTracker.getContentWriteNanos());
        updatedMetrics.setSessionCommitNanos(previousMetrics.getSessionCommitNanos() + performanceTracker.getSessionCommitNanos());
        updatedMetrics.setGcMillis(gcMillis);
        this.sampledMetrics = updatedMetrics;
    }

    private boolean isMeasureExpensiveMetrics(long invocationCount) {
        if (this.perfTrackingNthIteration == 0) {
            return false;
        }
        return invocationCount % (long)this.perfTrackingNthIteration == 0L;
    }

    private ComponentLog getComponentLog() {
        return new SimpleProcessLogger(this.connectable.getIdentifier(), this.connectable.getRunnableComponent(), (LoggingContext)new StandardLoggingContext((GroupedComponent)this.connectable));
    }

    private static /* synthetic */ void lambda$invoke$1(ComponentLog procLog, StandardProcessSession rawSession, Throwable t) {
        procLog.error("Failed to commit session {} due to {}; rolling back", new Object[]{rawSession, t.toString(), t});
    }

    private static class SampledMetrics {
        private long processingNanosSampled = 0L;
        private long totalCpuNanos = 0L;
        private long readNanos = 0L;
        private long writeNanos = 0L;
        private long sessionCommitNanos = 0L;
        private long gcMillis = 0L;

        private SampledMetrics() {
        }

        public long getProcessingNanosSampled() {
            return this.processingNanosSampled;
        }

        public void setProcessingNanosSampled(long processingNanosSampled) {
            this.processingNanosSampled = processingNanosSampled;
        }

        public long getTotalCpuNanos() {
            return this.totalCpuNanos;
        }

        public void setTotalCpuNanos(long totalCpuNanos) {
            this.totalCpuNanos = totalCpuNanos;
        }

        public long getReadNanos() {
            return this.readNanos;
        }

        public void setReadNanos(long readNanos) {
            this.readNanos = readNanos;
        }

        public long getWriteNanos() {
            return this.writeNanos;
        }

        public void setWriteNanos(long writeNanos) {
            this.writeNanos = writeNanos;
        }

        public long getSessionCommitNanos() {
            return this.sessionCommitNanos;
        }

        public void setSessionCommitNanos(long sessionCommitNanos) {
            this.sessionCommitNanos = sessionCommitNanos;
        }

        public long getGcMillis() {
            return this.gcMillis;
        }

        public void setGcMillis(long gcMillis) {
            this.gcMillis = gcMillis;
        }
    }
}

