/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.util.FormatUtils;

public class JVMDiagnosticTask
implements DiagnosticTask {
    public DiagnosticsDumpElement captureDump(boolean verbose) {
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        ClassLoadingMXBean classLoading = ManagementFactory.getClassLoadingMXBean();
        MemoryUsage heap = memory.getHeapMemoryUsage();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        ArrayList<CallSite> details = new ArrayList<CallSite>();
        NumberFormat numberFormat = NumberFormat.getInstance();
        details.add((CallSite)((Object)("Total Thread Count: " + numberFormat.format(threads.getThreadCount()))));
        details.add((CallSite)((Object)("Daemon Thread Count: " + numberFormat.format(threads.getDaemonThreadCount()))));
        details.add((CallSite)((Object)("Max Heap: " + FormatUtils.formatDataSize((double)heap.getMax()))));
        details.add((CallSite)((Object)("Heap Used: " + FormatUtils.formatDataSize((double)heap.getUsed()))));
        details.add((CallSite)((Object)("Heap Committed: " + FormatUtils.formatDataSize((double)heap.getCommitted()))));
        details.add((CallSite)((Object)("JVM Uptime: " + FormatUtils.formatHoursMinutesSeconds((long)runtime.getUptime(), (TimeUnit)TimeUnit.MILLISECONDS))));
        details.add((CallSite)((Object)("JVM Spec Name: " + runtime.getSpecName())));
        details.add((CallSite)((Object)("JVM Spec Vendor: " + runtime.getSpecVendor())));
        details.add((CallSite)((Object)("JVM Spec Version: " + runtime.getSpecVersion())));
        details.add((CallSite)((Object)("JVM Vendor: " + runtime.getVmVendor())));
        details.add((CallSite)((Object)("JVM Version: " + runtime.getVmVersion())));
        details.add((CallSite)((Object)("Classes Loaded: " + numberFormat.format(classLoading.getLoadedClassCount()))));
        details.add((CallSite)((Object)("Classes Loaded Since Start: " + numberFormat.format(classLoading.getTotalLoadedClassCount()))));
        details.add((CallSite)((Object)("Working Directory: " + new File(".").getAbsolutePath())));
        return new StandardDiagnosticsDumpElement("Java Virtual Machine", details);
    }
}

