/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleProvider;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisUtil;
import org.apache.nifi.controller.flowanalysis.FlowAnalyzer;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.mapping.NiFiRegistryFlowMapper;
import org.apache.nifi.validation.RuleViolation;
import org.apache.nifi.validation.RuleViolationsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFlowAnalyzer
implements FlowAnalyzer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final RuleViolationsManager ruleViolationsManager;
    private final FlowAnalysisRuleProvider flowAnalysisRuleProvider;
    private final ExtensionManager extensionManager;
    private ControllerServiceProvider controllerServiceProvider;

    public StandardFlowAnalyzer(RuleViolationsManager ruleViolationsManager, FlowAnalysisRuleProvider flowAnalysisRuleProvider, ExtensionManager extensionManager) {
        this.ruleViolationsManager = ruleViolationsManager;
        this.flowAnalysisRuleProvider = flowAnalysisRuleProvider;
        this.extensionManager = extensionManager;
    }

    public void initialize(ControllerServiceProvider controllerServiceProvider) {
        this.controllerServiceProvider = controllerServiceProvider;
    }

    public void analyzeProcessor(ProcessorNode processorNode) {
        this.logger.debug("Running analysis on {}", (Object)processorNode);
        NiFiRegistryFlowMapper mapper = this.createMapper();
        VersionedProcessor versionedProcessor = mapper.mapProcessor(processorNode, this.controllerServiceProvider, Collections.emptySet(), new HashMap());
        this.analyzeComponent((VersionedComponent)versionedProcessor);
    }

    public void analyzeControllerService(ControllerServiceNode controllerServiceNode) {
        this.logger.debug("Running analysis on {}", (Object)controllerServiceNode);
        NiFiRegistryFlowMapper mapper = this.createMapper();
        VersionedControllerService versionedControllerService = mapper.mapControllerService(controllerServiceNode, this.controllerServiceProvider, Collections.emptySet(), new HashMap());
        this.analyzeComponent((VersionedComponent)versionedControllerService);
    }

    private void analyzeComponent(VersionedComponent component) {
        long start = System.currentTimeMillis();
        String componentId = component.getIdentifier();
        Set flowAnalysisRules = this.flowAnalysisRuleProvider.getAllFlowAnalysisRules();
        Set violations = flowAnalysisRules.stream().filter(FlowAnalysisRuleNode::isEnabled).flatMap(flowAnalysisRuleNode -> {
            String ruleId = flowAnalysisRuleNode.getIdentifier();
            try {
                Collection analysisResults = flowAnalysisRuleNode.getFlowAnalysisRule().analyzeComponent(component, flowAnalysisRuleNode.getFlowAnalysisRuleContext());
                return analysisResults.stream().map(analysisResult -> new RuleViolation(flowAnalysisRuleNode.getEnforcementPolicy(), componentId, componentId, this.getDisplayName(component), component.getGroupIdentifier(), ruleId, analysisResult.getIssueId(), analysisResult.getMessage(), analysisResult.getExplanation()));
            }
            catch (Exception e) {
                this.logger.error("FlowAnalysis error while running '{}' against '{}'", new Object[]{flowAnalysisRuleNode.getName(), component, e});
                return Stream.empty();
            }
        }).collect(Collectors.toSet());
        this.ruleViolationsManager.upsertComponentViolations(componentId, violations);
        long end = System.currentTimeMillis();
        long durationMs = end - start;
        this.logger.trace("Flow Analysis of component '{}' took {} ms", (Object)componentId, (Object)durationMs);
    }

    public void analyzeProcessGroup(VersionedProcessGroup processGroup) {
        this.logger.debug("Running analysis on process group {}.", (Object)processGroup.getIdentifier());
        long start = System.currentTimeMillis();
        Set flowAnalysisRules = this.flowAnalysisRuleProvider.getAllFlowAnalysisRules();
        HashSet<RuleViolation> groupViolations = new HashSet<RuleViolation>();
        HashMap<VersionedComponent, Collection<RuleViolation>> componentToRuleViolations = new HashMap<VersionedComponent, Collection<RuleViolation>>();
        this.analyzeProcessGroup(processGroup, flowAnalysisRules, groupViolations, componentToRuleViolations);
        this.ruleViolationsManager.upsertGroupViolations(processGroup, groupViolations, componentToRuleViolations);
        long end = System.currentTimeMillis();
        long durationMs = end - start;
        this.logger.debug("Flow Analysis of process group '{}' took {} ms", (Object)processGroup.getIdentifier(), (Object)durationMs);
    }

    private void analyzeProcessGroup(VersionedProcessGroup processGroup, Set<FlowAnalysisRuleNode> flowAnalysisRules, Collection<RuleViolation> groupViolations, Map<VersionedComponent, Collection<RuleViolation>> componentToRuleViolations) {
        String groupId = processGroup.getIdentifier();
        flowAnalysisRules.stream().filter(FlowAnalysisRuleNode::isEnabled).forEach(flowAnalysisRuleNode -> {
            String ruleId = flowAnalysisRuleNode.getIdentifier();
            try {
                Collection analysisResults = flowAnalysisRuleNode.getFlowAnalysisRule().analyzeProcessGroup(processGroup, flowAnalysisRuleNode.getFlowAnalysisRuleContext());
                analysisResults.forEach(analysisResult -> {
                    Optional componentOptional = analysisResult.getComponent();
                    if (componentOptional.isPresent()) {
                        VersionedComponent component = (VersionedComponent)componentOptional.get();
                        componentToRuleViolations.computeIfAbsent(component, __ -> new HashSet()).add(new RuleViolation(flowAnalysisRuleNode.getEnforcementPolicy(), component.getGroupIdentifier(), component.getIdentifier(), this.getDisplayName(component), component.getGroupIdentifier(), ruleId, analysisResult.getIssueId(), analysisResult.getMessage(), analysisResult.getExplanation()));
                    } else {
                        groupViolations.add(new RuleViolation(flowAnalysisRuleNode.getEnforcementPolicy(), groupId, groupId, this.getDisplayName((VersionedComponent)processGroup), groupId, ruleId, analysisResult.getIssueId(), analysisResult.getMessage(), analysisResult.getExplanation()));
                    }
                });
            }
            catch (Exception e) {
                this.logger.error("FlowAnalysis error while running '{}' against group '{}'", new Object[]{flowAnalysisRuleNode.getName(), groupId, e});
            }
        });
        processGroup.getProcessors().forEach(processor -> this.analyzeComponent((VersionedComponent)processor));
        processGroup.getControllerServices().forEach(controllerService -> this.analyzeComponent((VersionedComponent)controllerService));
        processGroup.getProcessGroups().forEach(childProcessGroup -> this.analyzeProcessGroup((VersionedProcessGroup)childProcessGroup, flowAnalysisRules, groupViolations, componentToRuleViolations));
    }

    private String getDisplayName(VersionedComponent component) {
        Object displayName;
        if (component instanceof VersionedConnection) {
            VersionedConnection connection = (VersionedConnection)component;
            displayName = connection.getSource().getName() + " > " + connection.getSelectedRelationships().stream().collect(Collectors.joining(","));
        } else {
            displayName = component.getName();
        }
        return displayName;
    }

    private NiFiRegistryFlowMapper createMapper() {
        NiFiRegistryFlowMapper mapper = FlowAnalysisUtil.createMapper(this.extensionManager);
        return mapper;
    }
}

