/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.inheritance;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.FlowInheritabilityCheck;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedProcessGroup;

public class MissingComponentsCheck
implements FlowInheritabilityCheck {
    @Override
    public FlowInheritability checkInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController flowController) {
        if (existingFlow == null) {
            return FlowInheritability.inheritable();
        }
        HashSet existingMissingComponents = new HashSet(existingFlow.getMissingComponents());
        existingMissingComponents.removeAll(proposedFlow.getMissingComponents());
        if (!existingMissingComponents.isEmpty()) {
            Set<String> versionedComponentIds = this.getAllComponentIds(proposedFlow.getVersionedDataflow());
            existingMissingComponents.retainAll(versionedComponentIds);
        }
        if (!existingMissingComponents.isEmpty()) {
            String missingIds = StringUtils.join(existingMissingComponents, (String)",");
            return FlowInheritability.notInheritable("Current flow has missing components that are not considered missing in the proposed flow (" + missingIds + ")");
        }
        HashSet proposedMissingComponents = new HashSet(proposedFlow.getMissingComponents());
        proposedMissingComponents.removeAll(existingFlow.getMissingComponents());
        if (!proposedMissingComponents.isEmpty()) {
            Set<String> versionedComponentIds = this.getAllComponentIds(existingFlow.getVersionedDataflow());
            proposedMissingComponents.retainAll(versionedComponentIds);
        }
        if (!proposedMissingComponents.isEmpty()) {
            String missingIds = StringUtils.join(proposedMissingComponents, (String)",");
            return FlowInheritability.notInheritable("Proposed flow has missing components that are not considered missing in the current flow (" + missingIds + ")");
        }
        return FlowInheritability.inheritable();
    }

    private Set<String> getAllComponentIds(VersionedDataflow dataflow) {
        if (dataflow == null) {
            return Collections.emptySet();
        }
        HashSet<String> ids = new HashSet<String>();
        this.findAllComponentIds(dataflow, ids);
        return ids;
    }

    private void findAllComponentIds(VersionedDataflow dataflow, Set<String> ids) {
        this.addAllIds(dataflow.getControllerServices(), ids);
        this.addAllIds(dataflow.getRegistries(), ids);
        this.addAllIds(dataflow.getFlowAnalysisRules(), ids);
        this.addAllIds(dataflow.getParameterContexts(), ids);
        this.addAllIds(dataflow.getParameterProviders(), ids);
        this.addAllIds(dataflow.getReportingTasks(), ids);
        this.findAllComponentIds(dataflow.getRootGroup(), ids);
    }

    private void findAllComponentIds(VersionedProcessGroup group, Set<String> ids) {
        if (group == null) {
            return;
        }
        this.addAllIds(group.getControllerServices(), ids);
        this.addAllIds(group.getProcessors(), ids);
        group.getProcessGroups().forEach(child -> this.findAllComponentIds((VersionedProcessGroup)child, ids));
    }

    private void addAllIds(Collection<? extends VersionedComponent> components, Set<String> ids) {
        if (components != null) {
            components.forEach(component -> ids.add(component.getInstanceIdentifier()));
        }
    }
}

