/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.SerializedRepositoryRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.flowfile.attributes.CoreAttributes;

public class LiveSerializedRepositoryRecord
implements SerializedRepositoryRecord {
    private final RepositoryRecord record;

    public LiveSerializedRepositoryRecord(RepositoryRecord repositoryRecord) {
        this.record = repositoryRecord;
    }

    public String getQueueIdentifier() {
        FlowFileQueue destination = this.record.getDestination();
        FlowFileQueue queue = destination == null ? this.record.getOriginalQueue() : destination;
        return queue == null ? null : queue.getIdentifier();
    }

    public RepositoryRecordType getType() {
        return this.record.getType();
    }

    public ContentClaim getContentClaim() {
        return this.record.getCurrentClaim();
    }

    public long getClaimOffset() {
        return this.record.getCurrentClaimOffset();
    }

    public String getSwapLocation() {
        return this.record.getSwapLocation();
    }

    public FlowFileRecord getFlowFileRecord() {
        return this.record.getCurrent();
    }

    public boolean isMarkedForAbort() {
        return this.record.isMarkedForAbort();
    }

    public boolean isAttributesChanged() {
        return this.record.isAttributesChanged();
    }

    public String toString() {
        return "LiveSerializedRepositoryRecord[recordType=" + String.valueOf(this.record.getType()) + ", queueId=" + (this.record.getDestination() == null ? null : this.record.getDestination().getIdentifier()) + ", flowFileUuid=" + this.record.getCurrent().getAttribute(CoreAttributes.UUID.key()) + ", attributesChanged=" + this.isAttributesChanged() + "]";
    }
}

