/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.engine.FlowEngine;

abstract class AbstractSchedulingAgent
implements SchedulingAgent {
    protected final FlowEngine flowEngine;

    protected AbstractSchedulingAgent(FlowEngine flowEngine) {
        this.flowEngine = flowEngine;
    }

    public void schedule(Connectable connectable, LifecycleState scheduleState) {
        scheduleState.setScheduled(true);
        this.doSchedule(connectable, scheduleState);
    }

    public void scheduleOnce(Connectable connectable, LifecycleState scheduleState, Callable<Future<Void>> stopCallback) {
        scheduleState.setScheduled(true);
        this.doScheduleOnce(connectable, scheduleState, stopCallback);
    }

    public void unschedule(Connectable connectable, LifecycleState lifeycleState) {
        lifeycleState.setScheduled(false);
        this.doUnschedule(connectable, lifeycleState);
    }

    public void schedule(ReportingTaskNode taskNode, LifecycleState lifecycleState) {
        lifecycleState.setScheduled(true);
        this.doSchedule(taskNode, lifecycleState);
    }

    public void unschedule(ReportingTaskNode taskNode, LifecycleState lifecycleState) {
        lifecycleState.setScheduled(false);
        this.doUnschedule(taskNode, lifecycleState);
    }

    protected abstract void doSchedule(Connectable var1, LifecycleState var2);

    protected abstract void doScheduleOnce(Connectable var1, LifecycleState var2, Callable<Future<Void>> var3);

    protected abstract void doUnschedule(Connectable var1, LifecycleState var2);

    protected abstract void doSchedule(ReportingTaskNode var1, LifecycleState var2);

    protected abstract void doUnschedule(ReportingTaskNode var1, LifecycleState var2);
}

