/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.MissingBundleException;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SnippetManager;
import org.apache.nifi.controller.StandardSnippet;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.flow.VersionedDataflow;
import org.apache.nifi.controller.flow.VersionedFlowEncodingVersion;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleInstantiationException;
import org.apache.nifi.controller.inheritance.AuthorizerCheck;
import org.apache.nifi.controller.inheritance.BundleCompatibilityCheck;
import org.apache.nifi.controller.inheritance.ConnectionMissingCheck;
import org.apache.nifi.controller.inheritance.FlowInheritability;
import org.apache.nifi.controller.inheritance.MissingComponentsCheck;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.serialization.AffectedComponentSet;
import org.apache.nifi.controller.serialization.ComponentSetFilter;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.FlowSynchronizationUtils;
import org.apache.nifi.controller.serialization.FlowSynchronizer;
import org.apache.nifi.controller.serialization.RunningComponentSetFilter;
import org.apache.nifi.controller.serialization.VersionedFlowSerializer;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.Bundle;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.flow.VersionedFlowAnalysisRule;
import org.apache.nifi.flow.VersionedFlowRegistryClient;
import org.apache.nifi.flow.VersionedParameter;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedParameterProvider;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.groups.AbstractComponentScheduler;
import org.apache.nifi.groups.BundleUpdateStrategy;
import org.apache.nifi.groups.ComponentIdGenerator;
import org.apache.nifi.groups.ComponentScheduler;
import org.apache.nifi.groups.FlowSynchronizationOptions;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.migration.ControllerServiceFactory;
import org.apache.nifi.migration.StandardControllerServiceFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterContextManager;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterProviderConfiguration;
import org.apache.nifi.parameter.StandardParameterProviderConfiguration;
import org.apache.nifi.persistence.FlowConfigurationArchiveManager;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.diff.ComparableDataFlow;
import org.apache.nifi.registry.flow.diff.DifferenceDescriptor;
import org.apache.nifi.registry.flow.diff.FlowComparatorVersionedStrategy;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.diff.StandardComparableDataFlow;
import org.apache.nifi.registry.flow.diff.StandardFlowComparator;
import org.apache.nifi.registry.flow.diff.StaticDifferenceDescriptor;
import org.apache.nifi.registry.flow.mapping.ComponentIdLookup;
import org.apache.nifi.registry.flow.mapping.FlowMappingOptions;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.FlowDifferenceFilters;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedFlowSynchronizer
implements FlowSynchronizer {
    private static final Logger logger = LoggerFactory.getLogger(VersionedFlowSynchronizer.class);
    private final ExtensionManager extensionManager;
    private final File flowStorageFile;
    private final FlowConfigurationArchiveManager archiveManager;

    public VersionedFlowSynchronizer(ExtensionManager extensionManager, File flowStorageFile, FlowConfigurationArchiveManager archiveManager) {
        this.extensionManager = extensionManager;
        this.flowStorageFile = flowStorageFile;
        this.archiveManager = archiveManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void sync(FlowController controller, DataFlow proposedFlow, FlowService flowService, BundleUpdateStrategy bundleUpdateStrategy) throws FlowSerializationException, UninheritableFlowException, FlowSynchronizationException, MissingBundleException {
        long start = System.currentTimeMillis();
        FlowManager flowManager = controller.getFlowManager();
        ProcessGroup root = flowManager.getRootGroup();
        if (proposedFlow == null) {
            if (root.isEmpty()) {
                return;
            }
            throw new UninheritableFlowException("Proposed configuration is empty, but the controller contains a data flow.");
        }
        boolean flowAlreadySynchronized = controller.isFlowSynchronized();
        logger.info("Synchronizing FlowController with proposed flow: Controller Already Synchronized = {}", (Object)flowAlreadySynchronized);
        DataFlow existingDataFlow = this.getExistingDataFlow(controller);
        boolean existingFlowEmpty = VersionedFlowSynchronizer.isFlowEmpty(existingDataFlow);
        if (!existingFlowEmpty && bundleUpdateStrategy == BundleUpdateStrategy.USE_SPECIFIED_OR_COMPATIBLE_OR_GHOST) {
            this.mapCompatibleBundles(proposedFlow, controller.getExtensionManager());
        }
        this.checkFlowInheritability(existingDataFlow, proposedFlow, controller, bundleUpdateStrategy);
        logger.debug("Checking missing component inheritability");
        MissingComponentsCheck missingComponentsCheck = new MissingComponentsCheck();
        FlowInheritability componentInheritability = missingComponentsCheck.checkInheritability(existingDataFlow, proposedFlow, controller);
        if (!componentInheritability.isInheritable()) {
            throw new UninheritableFlowException("Proposed Flow is not inheritable by the flow controller because of differences in missing components: " + componentInheritability.getExplanation());
        }
        FlowComparison flowComparison = null;
        AffectedComponentSet affectedComponents = null;
        AffectedComponentSet activeSet = null;
        if (!existingFlowEmpty) {
            flowComparison = this.compareFlows(existingDataFlow, proposedFlow, controller.getEncryptor());
            Set flowDifferences = flowComparison.getDifferences();
            if (flowDifferences.isEmpty()) {
                logger.debug("No differences between current flow and proposed flow. Will not create backup of existing flow.");
            } else if (this.isExistingFlowEmpty(controller)) {
                logger.debug("Currently loaded dataflow is empty. Will not create backup of existing flow.");
            } else {
                this.backupExistingFlow();
            }
            affectedComponents = this.determineAffectedComponents(flowComparison, controller);
            activeSet = affectedComponents.toActiveSet();
            logger.info("In order to inherit proposed dataflow, will stop any components that will be affected by the update");
            if (logger.isDebugEnabled()) {
                logger.debug("Will stop the following components:");
                logger.debug(activeSet.toString());
                String differencesToString = flowDifferences.stream().map(FlowDifference::toString).collect(Collectors.joining("\n"));
                logger.debug("This Active Set was determined from the following Flow Differences:\n{}", (Object)differencesToString);
            }
            activeSet.stop();
        }
        try {
            if (!existingFlowEmpty) {
                this.verifyNoConnectionsWithDataRemoved(existingDataFlow, proposedFlow, controller, flowComparison);
            }
            this.synchronizeFlow(controller, existingDataFlow, proposedFlow, affectedComponents);
        }
        finally {
            if (!existingFlowEmpty) {
                AffectedComponentSet startable = activeSet.toExistingSet().toStartableSet();
                RunningComponentSetFilter runningComponentFilter = new RunningComponentSetFilter(proposedFlow.getVersionedDataflow());
                ComponentSetFilter stoppedComponentFilter = runningComponentFilter.reverse();
                startable.removeComponents(stoppedComponentFilter);
                startable.start();
            }
        }
        long millis = System.currentTimeMillis() - start;
        logger.info("Successfully synchronized dataflow with the proposed flow in {} millis", (Object)millis);
    }

    private void verifyNoConnectionsWithDataRemoved(DataFlow existingFlow, DataFlow proposedFlow, FlowController controller, FlowComparison flowComparison) {
        logger.debug("Checking that no connections were removed that have data");
        ConnectionMissingCheck processGroupInheritableCheck = new ConnectionMissingCheck(flowComparison);
        FlowInheritability inheritability = processGroupInheritableCheck.checkInheritability(existingFlow, proposedFlow, controller);
        if (!inheritability.isInheritable()) {
            throw new UninheritableFlowException("Proposed flow is not inheritable by the flow controller and cannot completely replace the current flow due to: " + inheritability.getExplanation());
        }
        logger.debug("Proposed flow contains all connections that currently have data queued. Will backup existing flow and replace, provided all other checks pass");
    }

    private void mapCompatibleBundles(DataFlow proposedFlow, ExtensionManager extensionManager) {
        Bundle compatibleBundle;
        Set missingComponentIds = proposedFlow.getMissingComponents();
        VersionedDataflow dataflow = proposedFlow.getVersionedDataflow();
        if (dataflow.getReportingTasks() == null) {
            dataflow.setReportingTasks(new ArrayList());
        }
        for (VersionedReportingTask reportingTask : dataflow.getReportingTasks()) {
            if (missingComponentIds.contains(reportingTask.getInstanceIdentifier()) || (compatibleBundle = this.getCompatibleBundle(reportingTask.getBundle(), extensionManager, reportingTask.getType())) == null) continue;
            reportingTask.setBundle(compatibleBundle);
        }
        if (dataflow.getFlowAnalysisRules() == null) {
            dataflow.setFlowAnalysisRules(new ArrayList());
        }
        for (VersionedFlowAnalysisRule flowAnalysisRule : dataflow.getFlowAnalysisRules()) {
            if (missingComponentIds.contains(flowAnalysisRule.getInstanceIdentifier()) || (compatibleBundle = this.getCompatibleBundle(flowAnalysisRule.getBundle(), extensionManager, flowAnalysisRule.getType())) == null) continue;
            flowAnalysisRule.setBundle(compatibleBundle);
        }
        if (dataflow.getRegistries() == null) {
            dataflow.setRegistries(new ArrayList());
        }
        for (VersionedFlowRegistryClient registry : dataflow.getRegistries()) {
            if (missingComponentIds.contains(registry.getInstanceIdentifier()) || (compatibleBundle = this.getCompatibleBundle(registry.getBundle(), extensionManager, registry.getType())) == null) continue;
            registry.setBundle(compatibleBundle);
        }
        if (dataflow.getParameterProviders() == null) {
            dataflow.setParameterProviders(new ArrayList());
        }
        for (VersionedParameterProvider parameterProvider : dataflow.getParameterProviders()) {
            if (missingComponentIds.contains(parameterProvider.getInstanceIdentifier()) || (compatibleBundle = this.getCompatibleBundle(parameterProvider.getBundle(), extensionManager, parameterProvider.getType())) == null) continue;
            parameterProvider.setBundle(compatibleBundle);
        }
        if (dataflow.getControllerServices() == null) {
            dataflow.setControllerServices(new ArrayList());
        }
        for (VersionedControllerService service : dataflow.getControllerServices()) {
            if (missingComponentIds.contains(service.getInstanceIdentifier()) || (compatibleBundle = this.getCompatibleBundle(service.getBundle(), extensionManager, service.getType())) == null) continue;
            service.setBundle(compatibleBundle);
        }
        this.mapCompatibleBundles(dataflow.getRootGroup(), extensionManager, missingComponentIds);
    }

    private void mapCompatibleBundles(VersionedProcessGroup group, ExtensionManager extensionManager, Set<String> missingComponentIds) {
        Bundle compatibleBundle;
        for (VersionedControllerService service : group.getControllerServices()) {
            if (missingComponentIds.contains(service.getInstanceIdentifier()) || (compatibleBundle = this.getCompatibleBundle(service.getBundle(), extensionManager, service.getType())) == null) continue;
            service.setBundle(compatibleBundle);
        }
        for (VersionedProcessor processor : group.getProcessors()) {
            if (missingComponentIds.contains(processor.getInstanceIdentifier()) || (compatibleBundle = this.getCompatibleBundle(processor.getBundle(), extensionManager, processor.getType())) == null) continue;
            processor.setBundle(compatibleBundle);
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.mapCompatibleBundles(childGroup, extensionManager, missingComponentIds);
        }
    }

    private Bundle getCompatibleBundle(Bundle bundle, ExtensionManager extensionManager, String type) {
        org.apache.nifi.bundle.Bundle exactBundle = extensionManager.getBundle(new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion()));
        if (exactBundle != null) {
            return bundle;
        }
        BundleDTO bundleDto = new BundleDTO(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
        Optional optionalCoordinate = BundleUtils.getOptionalCompatibleBundle((ExtensionManager)extensionManager, (String)type, (BundleDTO)bundleDto);
        if (optionalCoordinate.isPresent()) {
            BundleCoordinate coordinate = (BundleCoordinate)optionalCoordinate.get();
            logger.debug("Found compatible bundle {} for {}:{}:{} and type {}", new Object[]{coordinate.getCoordinate(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion(), type});
            return new Bundle(coordinate.getGroup(), coordinate.getId(), coordinate.getVersion());
        }
        logger.debug("Could not find a compatible bundle for {}:{}:{} type {}", new Object[]{bundle.getGroup(), bundle.getArtifact(), bundle.getVersion(), type});
        return null;
    }

    private BundleCoordinate getCompatibleBundle(BundleCoordinate coordinate, ExtensionManager extensionManager, String type) {
        org.apache.nifi.bundle.Bundle exactBundle = extensionManager.getBundle(coordinate);
        if (exactBundle != null) {
            return coordinate;
        }
        BundleDTO bundleDto = new BundleDTO(coordinate.getGroup(), coordinate.getId(), coordinate.getVersion());
        Optional optionalCoordinate = BundleUtils.getOptionalCompatibleBundle((ExtensionManager)extensionManager, (String)type, (BundleDTO)bundleDto);
        if (optionalCoordinate.isPresent()) {
            BundleCoordinate selectedCoordinate = (BundleCoordinate)optionalCoordinate.get();
            logger.debug("Found compatible bundle {} for {} and type {}", new Object[]{selectedCoordinate.getCoordinate(), coordinate, type});
            return selectedCoordinate;
        }
        logger.debug("Could not find a compatible bundle for {} and type {}", (Object)coordinate, (Object)type);
        return null;
    }

    private void synchronizeFlow(FlowController controller, DataFlow existingFlow, DataFlow proposedFlow, AffectedComponentSet affectedComponentSet) {
        try {
            VersionedDataflow versionedFlow = proposedFlow.getVersionedDataflow();
            PropertyEncryptor encryptor = controller.getEncryptor();
            if (versionedFlow != null) {
                controller.setMaxTimerDrivenThreadCount(versionedFlow.getMaxTimerDrivenThreadCount());
                ProcessGroup rootGroup = controller.getFlowManager().getRootGroup();
                HashMap versionedParameterContextMap = new HashMap();
                versionedFlow.getParameterContexts().forEach(context -> versionedParameterContextMap.put(context.getName(), context));
                VersionedExternalFlow versionedExternalFlow = new VersionedExternalFlow();
                versionedExternalFlow.setParameterContexts(versionedParameterContextMap);
                versionedExternalFlow.setFlowContents(versionedFlow.getRootGroup());
                this.inheritControllerServices(controller, versionedFlow, affectedComponentSet);
                this.inheritParameterProviders(controller, versionedFlow, affectedComponentSet);
                this.inheritParameterContexts(controller, versionedFlow);
                this.inheritReportingTasks(controller, versionedFlow, affectedComponentSet);
                this.inheritFlowAnalysisRules(controller, versionedFlow, affectedComponentSet);
                this.inheritRegistryClients(controller, versionedFlow, affectedComponentSet);
                ComponentIdGenerator componentIdGenerator = (proposedId, instanceId, destinationGroupId) -> instanceId;
                VersionedComponentStateLookup stateLookup = controller.createVersionedComponentStateLookup(VersionedComponentStateLookup.IDENTITY_LOOKUP);
                FlowControllerComponentScheduler componentScheduler = new FlowControllerComponentScheduler(controller, stateLookup);
                if (rootGroup.isEmpty()) {
                    VersionedProcessGroup versionedRoot = versionedExternalFlow.getFlowContents();
                    rootGroup = controller.getFlowManager().createProcessGroup(versionedRoot.getInstanceIdentifier());
                    rootGroup.setComments(versionedRoot.getComments());
                    rootGroup.setPosition(new Position(versionedRoot.getPosition().getX(), versionedRoot.getPosition().getY()));
                    rootGroup.setName(versionedRoot.getName());
                    controller.setRootGroup(rootGroup);
                }
                FlowSynchronizationOptions syncOptions = new FlowSynchronizationOptions.Builder().componentIdGenerator(componentIdGenerator).componentComparisonIdLookup(VersionedComponent::getInstanceIdentifier).componentScheduler((ComponentScheduler)componentScheduler).ignoreLocalModifications(true).updateGroupSettings(true).updateDescendantVersionedFlows(true).updateGroupVersionControlSnapshot(false).updateRpgUrls(true).propertyDecryptor(arg_0 -> ((PropertyEncryptor)encryptor).decrypt(arg_0)).build();
                FlowMappingOptions flowMappingOptions = new FlowMappingOptions.Builder().mapSensitiveConfiguration(true).mapPropertyDescriptors(false).stateLookup(stateLookup).sensitiveValueEncryptor(arg_0 -> ((PropertyEncryptor)encryptor).encrypt(arg_0)).componentIdLookup(ComponentIdLookup.VERSIONED_OR_GENERATE).mapInstanceIdentifiers(true).mapControllerServiceReferencesToVersionedId(false).mapFlowRegistryClientId(true).build();
                rootGroup.synchronizeFlow(versionedExternalFlow, syncOptions, flowMappingOptions);
            }
            this.inheritSnippets(controller, proposedFlow);
            this.inheritAuthorizations(existingFlow, proposedFlow, controller);
            this.removeMissingParameterContexts(controller, versionedFlow);
        }
        catch (Exception ex) {
            throw new FlowSynchronizationException(ex);
        }
    }

    private FlowComparison compareFlows(DataFlow existingFlow, DataFlow proposedFlow, PropertyEncryptor encryptor) {
        StaticDifferenceDescriptor differenceDescriptor = new StaticDifferenceDescriptor();
        VersionedDataflow clusterVersionedFlow = proposedFlow.getVersionedDataflow();
        StandardComparableDataFlow clusterDataFlow = new StandardComparableDataFlow("Cluster Flow", clusterVersionedFlow.getRootGroup(), this.toSet(clusterVersionedFlow.getControllerServices()), this.toSet(clusterVersionedFlow.getReportingTasks()), this.toSet(clusterVersionedFlow.getFlowAnalysisRules()), this.toSet(clusterVersionedFlow.getParameterContexts()), this.toSet(clusterVersionedFlow.getParameterProviders()), this.toSet(clusterVersionedFlow.getRegistries()));
        VersionedProcessGroup proposedRootGroup = clusterVersionedFlow.getRootGroup();
        String proposedRootGroupId = proposedRootGroup == null ? null : proposedRootGroup.getInstanceIdentifier();
        VersionedDataflow existingVersionedFlow = existingFlow.getVersionedDataflow() == null ? this.createEmptyVersionedDataflow(proposedRootGroupId) : existingFlow.getVersionedDataflow();
        StandardComparableDataFlow localDataFlow = new StandardComparableDataFlow("Local Flow", existingVersionedFlow.getRootGroup(), this.toSet(existingVersionedFlow.getControllerServices()), this.toSet(existingVersionedFlow.getReportingTasks()), this.toSet(existingVersionedFlow.getFlowAnalysisRules()), this.toSet(existingVersionedFlow.getParameterContexts()), this.toSet(existingVersionedFlow.getParameterProviders()), this.toSet(existingVersionedFlow.getRegistries()));
        StandardFlowComparator flowComparator = new StandardFlowComparator((ComparableDataFlow)localDataFlow, (ComparableDataFlow)clusterDataFlow, Collections.emptySet(), (DifferenceDescriptor)differenceDescriptor, arg_0 -> ((PropertyEncryptor)encryptor).decrypt(arg_0), VersionedComponent::getInstanceIdentifier, FlowComparatorVersionedStrategy.DEEP);
        return flowComparator.compare();
    }

    private <T> Set<T> toSet(List<T> values) {
        if (values == null || values.isEmpty()) {
            return new HashSet();
        }
        return new HashSet<T>(values);
    }

    private VersionedDataflow createEmptyVersionedDataflow(String rootGroupId) {
        VersionedDataflow dataflow = new VersionedDataflow();
        dataflow.setControllerServices(Collections.emptyList());
        dataflow.setEncodingVersion(new VersionedFlowEncodingVersion(2, 0));
        dataflow.setParameterContexts(Collections.emptyList());
        dataflow.setParameterProviders(Collections.emptyList());
        dataflow.setRegistries(Collections.emptyList());
        dataflow.setReportingTasks(Collections.emptyList());
        dataflow.setFlowAnalysisRules(Collections.emptyList());
        VersionedProcessGroup rootGroup = new VersionedProcessGroup();
        rootGroup.setInstanceIdentifier(rootGroupId);
        dataflow.setRootGroup(rootGroup);
        return dataflow;
    }

    private AffectedComponentSet determineAffectedComponents(FlowComparison flowComparison, FlowController controller) {
        List relevantDifferences = flowComparison.getDifferences().stream().filter(FlowDifferenceFilters.FILTER_ADDED_REMOVED_REMOTE_PORTS).collect(Collectors.toList());
        logger.debug("The differences between Local Flow and Cluster Flow that are relevant for finding affected components are: {}", relevantDifferences);
        AffectedComponentSet affectedComponentSet = new AffectedComponentSet(controller);
        for (FlowDifference difference : relevantDifferences) {
            affectedComponentSet.addAffectedComponents(difference);
        }
        logger.debug("Components affected by inheriting the flow are: {}", (Object)affectedComponentSet);
        return affectedComponentSet;
    }

    private void inheritRegistryClients(FlowController controller, VersionedDataflow dataflow, AffectedComponentSet affectedComponentSet) {
        FlowManager flowManager = controller.getFlowManager();
        HashSet<String> versionedClientIds = new HashSet<String>();
        for (VersionedFlowRegistryClient versionedFlowRegistryClient : dataflow.getRegistries()) {
            versionedClientIds.add(versionedFlowRegistryClient.getInstanceIdentifier());
            FlowRegistryClientNode existing = flowManager.getFlowRegistryClient(versionedFlowRegistryClient.getIdentifier());
            if (existing == null) {
                this.addFlowRegistryClient(controller, versionedFlowRegistryClient);
                continue;
            }
            if (!affectedComponentSet.isFlowRegistryClientAffected(existing.getIdentifier())) continue;
            this.updateRegistry(existing, versionedFlowRegistryClient, controller);
        }
        for (FlowRegistryClientNode clientNode : flowManager.getAllFlowRegistryClients()) {
            if (versionedClientIds.contains(clientNode.getIdentifier())) continue;
            flowManager.removeFlowRegistryClient(clientNode);
        }
    }

    private void addFlowRegistryClient(FlowController flowController, VersionedFlowRegistryClient versionedFlowRegistryClient) {
        BundleCoordinate coordinate = FlowSynchronizationUtils.createBundleCoordinate(this.extensionManager, versionedFlowRegistryClient.getBundle(), versionedFlowRegistryClient.getType());
        FlowRegistryClientNode flowRegistryClient = flowController.getFlowManager().createFlowRegistryClient(versionedFlowRegistryClient.getType(), versionedFlowRegistryClient.getIdentifier(), coordinate, Collections.emptySet(), false, true, null);
        this.updateRegistry(flowRegistryClient, versionedFlowRegistryClient, flowController);
    }

    private void updateRegistry(FlowRegistryClientNode flowRegistryClient, VersionedFlowRegistryClient versionedFlowRegistryClient, FlowController flowController) {
        flowRegistryClient.setName(versionedFlowRegistryClient.getName());
        flowRegistryClient.setDescription(versionedFlowRegistryClient.getDescription());
        flowRegistryClient.setAnnotationData(versionedFlowRegistryClient.getAnnotationData());
        Set<String> sensitiveDynamicPropertyNames = FlowSynchronizationUtils.getSensitiveDynamicPropertyNames((ComponentNode)flowRegistryClient, (VersionedConfigurableExtension)versionedFlowRegistryClient);
        Map<String, String> decryptedProperties = FlowSynchronizationUtils.decryptProperties(versionedFlowRegistryClient.getProperties(), flowController.getEncryptor());
        flowRegistryClient.setProperties(decryptedProperties, false, sensitiveDynamicPropertyNames);
    }

    private void inheritReportingTasks(FlowController controller, VersionedDataflow dataflow, AffectedComponentSet affectedComponentSet) throws ReportingTaskInstantiationException {
        HashSet<String> versionedTaskIds = new HashSet<String>();
        for (VersionedReportingTask versionedReportingTask : dataflow.getReportingTasks()) {
            versionedTaskIds.add(versionedReportingTask.getInstanceIdentifier());
            ReportingTaskNode existing = controller.getReportingTaskNode(versionedReportingTask.getInstanceIdentifier());
            if (existing == null) {
                this.addReportingTask(controller, versionedReportingTask);
                continue;
            }
            if (!affectedComponentSet.isReportingTaskAffected(existing.getIdentifier())) continue;
            this.updateReportingTask(existing, versionedReportingTask, controller);
        }
        for (ReportingTaskNode reportingTask : controller.getAllReportingTasks()) {
            if (versionedTaskIds.contains(reportingTask.getIdentifier())) continue;
            controller.removeReportingTask(reportingTask);
        }
    }

    private void addReportingTask(FlowController controller, VersionedReportingTask reportingTask) throws ReportingTaskInstantiationException {
        BundleCoordinate coordinate = FlowSynchronizationUtils.createBundleCoordinate(this.extensionManager, reportingTask.getBundle(), reportingTask.getType());
        ReportingTaskNode taskNode = controller.createReportingTask(reportingTask.getType(), reportingTask.getInstanceIdentifier(), coordinate, false);
        this.updateReportingTask(taskNode, reportingTask, controller);
        StandardControllerServiceFactory serviceFactory = new StandardControllerServiceFactory(controller.getExtensionManager(), controller.getFlowManager(), controller.getControllerServiceProvider(), (ComponentNode)taskNode);
        taskNode.migrateConfiguration(reportingTask.getProperties(), (ControllerServiceFactory)serviceFactory);
    }

    private void updateReportingTask(ReportingTaskNode taskNode, VersionedReportingTask reportingTask, FlowController controller) {
        taskNode.setName(reportingTask.getName());
        taskNode.setComments(reportingTask.getComments());
        taskNode.setSchedulingPeriod(reportingTask.getSchedulingPeriod());
        taskNode.setSchedulingStrategy(SchedulingStrategy.valueOf((String)reportingTask.getSchedulingStrategy()));
        taskNode.setAnnotationData(reportingTask.getAnnotationData());
        Set<String> sensitiveDynamicPropertyNames = FlowSynchronizationUtils.getSensitiveDynamicPropertyNames((ComponentNode)taskNode, (VersionedConfigurableExtension)reportingTask);
        Map<String, String> decryptedProperties = FlowSynchronizationUtils.decryptProperties(reportingTask.getProperties(), controller.getEncryptor());
        taskNode.setProperties(decryptedProperties, false, sensitiveDynamicPropertyNames);
        switch (reportingTask.getScheduledState()) {
            case DISABLED: {
                if (taskNode.isRunning()) {
                    controller.stopReportingTask(taskNode);
                }
                controller.disableReportingTask(taskNode);
                break;
            }
            case ENABLED: {
                if (taskNode.getScheduledState() == ScheduledState.DISABLED) {
                    controller.enableReportingTask(taskNode);
                    break;
                }
                if (!taskNode.isRunning()) break;
                controller.stopReportingTask(taskNode);
                break;
            }
            case RUNNING: {
                if (taskNode.getScheduledState() == ScheduledState.DISABLED) {
                    controller.enableReportingTask(taskNode);
                }
                if (taskNode.isRunning()) break;
                controller.startReportingTask(taskNode);
            }
        }
    }

    private void inheritFlowAnalysisRules(FlowController controller, VersionedDataflow dataflow, AffectedComponentSet affectedComponentSet) throws FlowAnalysisRuleInstantiationException {
        if (dataflow.getFlowAnalysisRules() == null) {
            return;
        }
        HashSet<String> versionedAnalysisRuleIds = new HashSet<String>();
        for (VersionedFlowAnalysisRule versionedFlowAnalysisRule : dataflow.getFlowAnalysisRules()) {
            versionedAnalysisRuleIds.add(versionedFlowAnalysisRule.getInstanceIdentifier());
            FlowAnalysisRuleNode existing = controller.getFlowAnalysisRuleNode(versionedFlowAnalysisRule.getInstanceIdentifier());
            if (existing == null) {
                this.addFlowAnalysisRule(controller, versionedFlowAnalysisRule);
                continue;
            }
            if (!affectedComponentSet.isFlowAnalysisRuleAffected(existing.getIdentifier())) continue;
            this.updateFlowAnalysisRule(existing, versionedFlowAnalysisRule, controller);
        }
        for (FlowAnalysisRuleNode ruleNode : controller.getAllFlowAnalysisRules()) {
            if (versionedAnalysisRuleIds.contains(ruleNode.getIdentifier())) continue;
            controller.removeFlowAnalysisRule(ruleNode);
        }
    }

    private void addFlowAnalysisRule(FlowController controller, VersionedFlowAnalysisRule flowAnalysisRule) throws FlowAnalysisRuleInstantiationException {
        BundleCoordinate coordinate = FlowSynchronizationUtils.createBundleCoordinate(this.extensionManager, flowAnalysisRule.getBundle(), flowAnalysisRule.getType());
        FlowAnalysisRuleNode ruleNode = controller.createFlowAnalysisRule(flowAnalysisRule.getType(), flowAnalysisRule.getInstanceIdentifier(), coordinate, false);
        this.updateFlowAnalysisRule(ruleNode, flowAnalysisRule, controller);
    }

    private void updateFlowAnalysisRule(FlowAnalysisRuleNode ruleNode, VersionedFlowAnalysisRule flowAnalysisRule, FlowController controller) {
        ruleNode.setName(flowAnalysisRule.getName());
        ruleNode.setComments(flowAnalysisRule.getComments());
        ruleNode.setEnforcementPolicy(flowAnalysisRule.getEnforcementPolicy());
        Set<String> sensitiveDynamicPropertyNames = FlowSynchronizationUtils.getSensitiveDynamicPropertyNames((ComponentNode)ruleNode, (VersionedConfigurableExtension)flowAnalysisRule);
        Map<String, String> decryptedProperties = FlowSynchronizationUtils.decryptProperties(flowAnalysisRule.getProperties(), controller.getEncryptor());
        ruleNode.setProperties(decryptedProperties, false, sensitiveDynamicPropertyNames);
        switch (flowAnalysisRule.getScheduledState()) {
            case DISABLED: {
                if (!ruleNode.isEnabled()) break;
                controller.disableFlowAnalysisRule(ruleNode);
                break;
            }
            case ENABLED: {
                if (ruleNode.isEnabled()) break;
                controller.enableFlowAnalysisRule(ruleNode);
            }
        }
    }

    private void inheritParameterProviders(FlowController controller, VersionedDataflow dataflow, AffectedComponentSet affectedComponentSet) {
        if (dataflow.getParameterProviders() == null) {
            return;
        }
        FlowManager flowManager = controller.getFlowManager();
        HashSet<String> versionedProviderIds = new HashSet<String>();
        for (VersionedParameterProvider versionedParameterProvider : dataflow.getParameterProviders()) {
            versionedProviderIds.add(versionedParameterProvider.getInstanceIdentifier());
            ParameterProviderNode existing = flowManager.getParameterProvider(versionedParameterProvider.getInstanceIdentifier());
            if (existing == null) {
                this.addParameterProvider(controller, versionedParameterProvider, controller.getEncryptor());
                continue;
            }
            if (!affectedComponentSet.isParameterProviderAffected(existing.getIdentifier())) continue;
            this.updateParameterProvider(existing, versionedParameterProvider, controller.getEncryptor());
        }
        for (ParameterProviderNode parameterProvider : flowManager.getAllParameterProviders()) {
            if (versionedProviderIds.contains(parameterProvider.getIdentifier())) continue;
            flowManager.removeParameterProvider(parameterProvider);
        }
    }

    private void addParameterProvider(FlowController controller, VersionedParameterProvider parameterProvider, PropertyEncryptor encryptor) {
        BundleCoordinate coordinate = FlowSynchronizationUtils.createBundleCoordinate(this.extensionManager, parameterProvider.getBundle(), parameterProvider.getType());
        ParameterProviderNode parameterProviderNode = controller.getFlowManager().createParameterProvider(parameterProvider.getType(), parameterProvider.getInstanceIdentifier(), coordinate, false);
        this.updateParameterProvider(parameterProviderNode, parameterProvider, encryptor);
    }

    private void updateParameterProvider(ParameterProviderNode parameterProviderNode, VersionedParameterProvider parameterProvider, PropertyEncryptor encryptor) {
        parameterProviderNode.setName(parameterProvider.getName());
        parameterProviderNode.setComments(parameterProvider.getComments());
        parameterProviderNode.setAnnotationData(parameterProvider.getAnnotationData());
        Map<String, String> decryptedProperties = FlowSynchronizationUtils.decryptProperties(parameterProvider.getProperties(), encryptor);
        parameterProviderNode.setProperties(decryptedProperties);
    }

    private void removeMissingParameterContexts(FlowController controller, VersionedDataflow dataflow) {
        controller.getFlowManager().withParameterContextResolution(() -> {
            ParameterContextManager contextManager = controller.getFlowManager().getParameterContextManager();
            this.removeMissingParameterContexts(contextManager, dataflow);
        });
    }

    private void removeMissingParameterContexts(ParameterContextManager contextManager, VersionedDataflow dataflow) {
        if (dataflow == null) {
            return;
        }
        List proposedParameterContexts = dataflow.getParameterContexts();
        Set proposedContextNames = proposedParameterContexts.stream().map(VersionedComponent::getName).collect(Collectors.toSet());
        Map existingContextsByName = contextManager.getParameterContextNameMapping();
        for (Map.Entry entry : existingContextsByName.entrySet()) {
            if (proposedContextNames.contains(entry.getKey())) continue;
            contextManager.removeParameterContext(((ParameterContext)entry.getValue()).getIdentifier());
        }
    }

    private void inheritParameterContexts(FlowController controller, VersionedDataflow dataflow) {
        controller.getFlowManager().withParameterContextResolution(() -> {
            List parameterContexts = dataflow.getParameterContexts();
            HashMap<String, VersionedParameterContext> namedParameterContexts = new HashMap<String, VersionedParameterContext>();
            parameterContexts.forEach(context -> namedParameterContexts.put(context.getName(), (VersionedParameterContext)context));
            for (VersionedParameterContext versionedParameterContext : parameterContexts) {
                this.inheritParameterContext(versionedParameterContext, controller.getFlowManager(), namedParameterContexts, controller.getEncryptor());
            }
        });
    }

    private void inheritParameterContext(VersionedParameterContext versionedParameterContext, FlowManager flowManager, Map<String, VersionedParameterContext> namedParameterContexts, PropertyEncryptor encryptor) {
        ParameterContextManager contextManager = flowManager.getParameterContextManager();
        ParameterContext existingContext = (ParameterContext)contextManager.getParameterContextNameMapping().get(versionedParameterContext.getName());
        if (existingContext == null) {
            this.addParameterContext(versionedParameterContext, flowManager, namedParameterContexts, encryptor);
        } else {
            this.updateParameterContext(versionedParameterContext, existingContext, flowManager, namedParameterContexts, encryptor);
        }
    }

    private void addParameterContext(VersionedParameterContext versionedParameterContext, FlowManager flowManager, Map<String, VersionedParameterContext> namedParameterContexts, PropertyEncryptor encryptor) {
        Map<String, Parameter> parameters = this.createParameterMap(versionedParameterContext, encryptor);
        ParameterContextManager contextManager = flowManager.getParameterContextManager();
        List<String> referenceIds = this.findReferencedParameterContextIds(versionedParameterContext, contextManager, namedParameterContexts);
        StandardParameterProviderConfiguration parameterProviderConfiguration = null;
        if (versionedParameterContext.getParameterProvider() != null) {
            parameterProviderConfiguration = new StandardParameterProviderConfiguration(versionedParameterContext.getParameterProvider(), versionedParameterContext.getParameterGroupName(), versionedParameterContext.isSynchronized());
        }
        flowManager.createParameterContext(versionedParameterContext.getInstanceIdentifier(), versionedParameterContext.getName(), versionedParameterContext.getDescription(), parameters, referenceIds, (ParameterProviderConfiguration)parameterProviderConfiguration);
        logger.info("Added Parameter Context {}", (Object)versionedParameterContext.getName());
    }

    private List<String> findReferencedParameterContextIds(VersionedParameterContext versionedParameterContext, ParameterContextManager contextManager, Map<String, VersionedParameterContext> namedParameterContexts) {
        ArrayList<String> referenceIds = new ArrayList<String>();
        Map parameterContextsByName = contextManager.getParameterContextNameMapping();
        if (versionedParameterContext.getInheritedParameterContexts() != null) {
            for (String inheritedContextName : versionedParameterContext.getInheritedParameterContexts()) {
                VersionedParameterContext inheritedParameterContext = namedParameterContexts.get(inheritedContextName);
                if (inheritedParameterContext == null) {
                    ParameterContext existingContext = (ParameterContext)parameterContextsByName.get(inheritedContextName);
                    if (existingContext == null) {
                        logger.warn("Parameter Context {} inherits from Parameter Context {} but cannot find a Parameter Context with name {}", new Object[]{versionedParameterContext.getName(), inheritedContextName, inheritedContextName});
                        continue;
                    }
                    referenceIds.add(existingContext.getIdentifier());
                    continue;
                }
                referenceIds.add(inheritedParameterContext.getInstanceIdentifier());
            }
        }
        return referenceIds;
    }

    private Map<String, Parameter> createParameterMap(VersionedParameterContext versionedParameterContext, PropertyEncryptor encryptor) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        for (VersionedParameter versioned : versionedParameterContext.getParameters()) {
            ParameterDescriptor descriptor = new ParameterDescriptor.Builder().description(versioned.getDescription()).name(versioned.getName()).sensitive(versioned.isSensitive()).build();
            String rawValue = versioned.getValue();
            String parameterValue = rawValue == null ? null : (versioned.isSensitive() ? FlowSynchronizationUtils.decrypt(rawValue, encryptor) : rawValue);
            Parameter parameter = new Parameter(descriptor, parameterValue, null, Boolean.valueOf(versioned.isProvided()));
            parameters.put(versioned.getName(), parameter);
        }
        return parameters;
    }

    private void updateParameterContext(VersionedParameterContext versionedParameterContext, ParameterContext parameterContext, FlowManager flowManager, Map<String, VersionedParameterContext> namedParameterContexts, PropertyEncryptor encryptor) {
        Map<String, Parameter> parameters = this.createParameterMap(versionedParameterContext, encryptor);
        HashMap currentValues = new HashMap();
        parameterContext.getParameters().values().forEach(param -> currentValues.put(param.getDescriptor().getName(), param.getValue()));
        if (logger.isDebugEnabled()) {
            Map<String, String> proposedValues = parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Parameter)entry.getValue()).getValue()));
            logger.debug("For Parameter Context {}, current parameters = {}, proposed = {}", new Object[]{parameterContext.getName(), currentValues, proposedValues});
        }
        HashMap<String, Parameter> updatedParameters = new HashMap<String, Parameter>();
        HashSet<String> proposedParameterNames = new HashSet<String>();
        for (VersionedParameter parameter : versionedParameterContext.getParameters()) {
            String parameterName = parameter.getName();
            String currentValue = (String)currentValues.get(parameterName);
            proposedParameterNames.add(parameterName);
            if (Objects.equals(currentValue, parameter.getValue())) continue;
            Parameter updatedParameterObject = parameters.get(parameterName);
            updatedParameters.put(parameterName, updatedParameterObject);
        }
        for (ParameterDescriptor existingParameterDescriptor : parameterContext.getParameters().keySet()) {
            String name = existingParameterDescriptor.getName();
            if (proposedParameterNames.contains(name)) continue;
            updatedParameters.put(name, null);
        }
        if (updatedParameters.isEmpty()) {
            logger.debug("No Parameters to update for Parameter Context {}", (Object)parameterContext.getName());
        } else {
            parameterContext.setParameters(updatedParameters);
            logger.info("Updated the following Parameters for Parameter Context {}: {}", (Object)parameterContext.getName(), updatedParameters.keySet());
        }
        ParameterContextManager contextManager = flowManager.getParameterContextManager();
        List<String> inheritedContextIds = this.findReferencedParameterContextIds(versionedParameterContext, contextManager, namedParameterContexts);
        List referencedContexts = inheritedContextIds.stream().map(arg_0 -> ((ParameterContextManager)contextManager).getParameterContext(arg_0)).collect(Collectors.toList());
        parameterContext.setInheritedParameterContexts(referencedContexts);
    }

    private void inheritControllerServices(FlowController controller, VersionedDataflow dataflow, AffectedComponentSet affectedComponentSet) {
        ControllerServiceNode serviceNode;
        FlowManager flowManager = controller.getFlowManager();
        HashSet<ControllerServiceNode> toEnable = new HashSet<ControllerServiceNode>();
        HashSet<ControllerServiceNode> toDisable = new HashSet<ControllerServiceNode>();
        List controllerServices = dataflow.getControllerServices();
        HashMap<ControllerServiceNode, Map> controllerServicesAddedAndProperties = new HashMap<ControllerServiceNode, Map>();
        for (VersionedControllerService versionedControllerService : controllerServices) {
            serviceNode = flowManager.getRootControllerService(versionedControllerService.getInstanceIdentifier());
            if (serviceNode != null) continue;
            ControllerServiceNode added = this.addRootControllerService(controller, versionedControllerService);
            controllerServicesAddedAndProperties.put(added, versionedControllerService.getProperties());
        }
        for (VersionedControllerService versionedControllerService : controllerServices) {
            serviceNode = flowManager.getRootControllerService(versionedControllerService.getInstanceIdentifier());
            if (!controllerServicesAddedAndProperties.containsKey(serviceNode) && !affectedComponentSet.isControllerServiceAffected(serviceNode.getIdentifier())) continue;
            this.updateRootControllerService(serviceNode, versionedControllerService, controller.getEncryptor());
        }
        for (Map.Entry entry : controllerServicesAddedAndProperties.entrySet()) {
            ControllerServiceNode service = (ControllerServiceNode)entry.getKey();
            Map originalPropertyValues = (Map)entry.getValue();
            StandardControllerServiceFactory serviceFactory = new StandardControllerServiceFactory(controller.getExtensionManager(), controller.getFlowManager(), controller.getControllerServiceProvider(), (ComponentNode)service);
            service.migrateConfiguration(originalPropertyValues, (ControllerServiceFactory)serviceFactory);
        }
        for (VersionedControllerService versionedControllerService : controllerServices) {
            serviceNode = flowManager.getRootControllerService(versionedControllerService.getInstanceIdentifier());
            if (versionedControllerService.getScheduledState() == org.apache.nifi.flow.ScheduledState.ENABLED) {
                toEnable.add(serviceNode);
                continue;
            }
            toDisable.add(serviceNode);
        }
        if (!toEnable.isEmpty()) {
            controller.getControllerServiceProvider().enableControllerServices(toEnable);
        }
        if (!toDisable.isEmpty()) {
            controller.getControllerServiceProvider().disableControllerServicesAsync(toDisable);
        }
        this.removeMissingServices(controller, dataflow);
    }

    private void removeMissingServices(FlowController controller, VersionedDataflow dataflow) {
        if (dataflow == null) {
            return;
        }
        Set retainedServiceIds = dataflow.getControllerServices().stream().map(VersionedComponent::getInstanceIdentifier).collect(Collectors.toSet());
        List<ControllerServiceNode> toRemove = controller.getFlowManager().getRootControllerServices().stream().filter(service -> !retainedServiceIds.contains(service.getIdentifier())).toList();
        for (ControllerServiceNode serviceToRemove : toRemove) {
            try {
                controller.getFlowManager().removeRootControllerService(serviceToRemove);
            }
            catch (Exception e) {
                throw new IllegalStateException("Inherited Dataflow does not have Controller-Level Controller Service %s but failed to remove it from flow".formatted(serviceToRemove), e);
            }
        }
    }

    private ControllerServiceNode addRootControllerService(FlowController controller, VersionedControllerService versionedControllerService) {
        BundleCoordinate bundleCoordinate = FlowSynchronizationUtils.createBundleCoordinate(this.extensionManager, versionedControllerService.getBundle(), versionedControllerService.getType());
        ControllerServiceNode serviceNode = controller.getFlowManager().createControllerService(versionedControllerService.getType(), versionedControllerService.getInstanceIdentifier(), bundleCoordinate, Collections.emptySet(), true, true, null);
        controller.getFlowManager().addRootControllerService(serviceNode);
        return serviceNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootControllerService(ControllerServiceNode serviceNode, VersionedControllerService versionedControllerService, PropertyEncryptor encryptor) {
        serviceNode.pauseValidationTrigger();
        try {
            serviceNode.setName(versionedControllerService.getName());
            serviceNode.setAnnotationData(versionedControllerService.getAnnotationData());
            serviceNode.setComments(versionedControllerService.getComments());
            if (versionedControllerService.getBulletinLevel() != null) {
                serviceNode.setBulletinLevel(LogLevel.valueOf((String)versionedControllerService.getBulletinLevel()));
            } else {
                serviceNode.setBulletinLevel(LogLevel.WARN);
            }
            Set<String> sensitiveDynamicPropertyNames = FlowSynchronizationUtils.getSensitiveDynamicPropertyNames((ComponentNode)serviceNode, (VersionedConfigurableExtension)versionedControllerService);
            Map<String, String> decryptedProperties = FlowSynchronizationUtils.decryptProperties(versionedControllerService.getProperties(), encryptor);
            serviceNode.setProperties(decryptedProperties, false, sensitiveDynamicPropertyNames);
        }
        finally {
            serviceNode.resumeValidationTrigger();
        }
    }

    private void inheritAuthorizations(DataFlow existingFlow, DataFlow proposedFlow, FlowController controller) {
        Authorizer authorizer = controller.getAuthorizer();
        if (!(authorizer instanceof ManagedAuthorizer)) {
            return;
        }
        ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
        String proposedAuthFingerprint = proposedFlow.getAuthorizerFingerprint() == null ? "" : new String(proposedFlow.getAuthorizerFingerprint(), StandardCharsets.UTF_8);
        AuthorizerCheck authorizerCheck = new AuthorizerCheck();
        FlowInheritability authorizerInheritability = authorizerCheck.checkInheritability(existingFlow, proposedFlow, controller);
        if (authorizerInheritability.isInheritable()) {
            logger.debug("Authorizations are inheritable. Will inherit from proposed fingerprint {}", (Object)proposedAuthFingerprint);
            managedAuthorizer.inheritFingerprint(proposedAuthFingerprint);
        } else if (!Objects.equals(managedAuthorizer.getFingerprint(), proposedAuthFingerprint)) {
            logger.debug("Authorizations are not inheritable. Will force inheritance of proposed fingerprint {}", (Object)proposedAuthFingerprint);
            managedAuthorizer.forciblyInheritFingerprint(proposedAuthFingerprint);
        }
    }

    private void checkFlowInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController controller, BundleUpdateStrategy bundleUpdateStrategy) {
        logger.debug("Checking if proposed dataflow is inheritable: {}", (Object)proposedFlow);
        boolean existingFlowEmpty = this.isExistingFlowEmpty(controller);
        if (bundleUpdateStrategy == BundleUpdateStrategy.USE_SPECIFIED_OR_FAIL) {
            BundleCompatibilityCheck bundleCompatibilityCheck = new BundleCompatibilityCheck();
            FlowInheritability bundleInheritability = bundleCompatibilityCheck.checkInheritability(existingFlow, proposedFlow, controller);
            if (!bundleInheritability.isInheritable()) {
                throw new UninheritableFlowException("Proposed flow could not be inherited because it references one or more Bundles that are not available in this NiFi instance: " + bundleInheritability.getExplanation());
            }
            logger.debug("Bundle Compatibility check passed");
        }
        logger.debug("Checking authorizer inheritability");
        AuthorizerCheck authorizerCheck = new AuthorizerCheck();
        FlowInheritability authorizerInheritability = authorizerCheck.checkInheritability(existingFlow, proposedFlow, controller);
        Authorizer authorizer = controller.getAuthorizer();
        if (existingFlowEmpty) {
            logger.debug("Existing flow is empty so will not check Authorizer inheritability. Authorizers will be forcibly inherited if necessary.");
        } else if (!controller.isInitialized() && authorizer instanceof ManagedAuthorizer) {
            logger.debug("Authorizations are not inheritable, but Authorizer is a Managed Authorizer and the Controller has not yet been initialized, so it can be forcibly inherited.");
        } else {
            if (!authorizerInheritability.isInheritable() && authorizerInheritability.getExplanation() != null) {
                throw new UninheritableFlowException("Proposed Authorizer is not inheritable by the Flow Controller because NiFi has already started the dataflow and Authorizer has differences: " + authorizerInheritability.getExplanation());
            }
            logger.debug("Authorizer inheritability check passed");
        }
    }

    private boolean isExistingFlowEmpty(FlowController controller) {
        FlowManager flowManager = controller.getFlowManager();
        ProcessGroup rootGroup = flowManager.getRootGroup();
        if (!rootGroup.isEmpty()) {
            logger.debug("Existing Dataflow is not empty because Root Group is not empty");
            return false;
        }
        Set rootControllerServices = flowManager.getRootControllerServices();
        if (!rootControllerServices.isEmpty()) {
            logger.debug("Existing Dataflow is not empty because there are {} Root-Level Controller Services", (Object)rootControllerServices.size());
            return false;
        }
        Set reportingTaskNodes = flowManager.getAllReportingTasks();
        if (!reportingTaskNodes.isEmpty()) {
            logger.debug("Existing Dataflow is not empty because there are {} Reporting Tasks", (Object)reportingTaskNodes.size());
            return false;
        }
        Set parameterContexts = flowManager.getParameterContextManager().getParameterContexts();
        if (!parameterContexts.isEmpty()) {
            logger.debug("Existing Dataflow is not empty because there are {} Parameter Contexts", (Object)parameterContexts.size());
            return false;
        }
        Set parameterProviders = flowManager.getAllParameterProviders();
        if (!parameterProviders.isEmpty()) {
            logger.debug("Existing Dataflow is not empty because there are {} Parameter Providers", (Object)parameterProviders.size());
            return false;
        }
        Set registryClients = controller.getFlowManager().getAllFlowRegistryClients();
        if (!registryClients.isEmpty()) {
            logger.debug("Existing Dataflow is not empty because there are {} NiFi Registries", (Object)registryClients.size());
            return false;
        }
        logger.debug("Existing Dataflow is empty");
        return true;
    }

    public static boolean isFlowEmpty(DataFlow dataFlow) {
        if (dataFlow == null || dataFlow.getFlow() == null || dataFlow.getFlow().length == 0) {
            return true;
        }
        return VersionedFlowSynchronizer.isFlowEmpty(dataFlow.getVersionedDataflow());
    }

    private static boolean isFlowEmpty(VersionedDataflow dataflow) {
        if (dataflow == null) {
            return true;
        }
        if (!CollectionUtils.isEmpty((Collection)dataflow.getReportingTasks())) {
            return false;
        }
        if (!CollectionUtils.isEmpty((Collection)dataflow.getParameterProviders())) {
            return false;
        }
        if (!CollectionUtils.isEmpty((Collection)dataflow.getControllerServices())) {
            return false;
        }
        if (!CollectionUtils.isEmpty((Collection)dataflow.getRegistries())) {
            return false;
        }
        if (!CollectionUtils.isEmpty((Collection)dataflow.getParameterContexts())) {
            return false;
        }
        VersionedProcessGroup rootGroup = dataflow.getRootGroup();
        return VersionedFlowSynchronizer.isFlowEmpty(rootGroup);
    }

    private static boolean isFlowEmpty(VersionedProcessGroup group) {
        if (group == null) {
            return true;
        }
        return CollectionUtils.isEmpty((Collection)group.getProcessors()) && CollectionUtils.isEmpty((Collection)group.getConnections()) && CollectionUtils.isEmpty((Collection)group.getFunnels()) && CollectionUtils.isEmpty((Collection)group.getLabels()) && CollectionUtils.isEmpty((Collection)group.getInputPorts()) && CollectionUtils.isEmpty((Collection)group.getOutputPorts()) && CollectionUtils.isEmpty((Collection)group.getProcessGroups()) && CollectionUtils.isEmpty((Collection)group.getRemoteProcessGroups()) && CollectionUtils.isEmpty((Collection)group.getControllerServices()) && group.getParameterContextName() == null;
    }

    private DataFlow getExistingDataFlow(FlowController controller) {
        byte[] existingAuthFingerprint;
        FlowManager flowManager = controller.getFlowManager();
        ProcessGroup root = flowManager.getRootGroup();
        HashSet missingComponents = new HashSet();
        flowManager.getAllControllerServices().stream().filter(ComponentNode::isExtensionMissing).forEach(cs -> missingComponents.add(cs.getIdentifier()));
        flowManager.getAllReportingTasks().stream().filter(ComponentNode::isExtensionMissing).forEach(r -> missingComponents.add(r.getIdentifier()));
        flowManager.getAllParameterProviders().stream().filter(ComponentNode::isExtensionMissing).forEach(r -> missingComponents.add(r.getIdentifier()));
        flowManager.getAllFlowRegistryClients().stream().filter(ComponentNode::isExtensionMissing).forEach(c -> missingComponents.add(c.getIdentifier()));
        root.findAllProcessors().stream().filter(AbstractComponentNode::isExtensionMissing).forEach(p -> missingComponents.add(p.getIdentifier()));
        logger.trace("Exporting snippets from controller");
        byte[] existingSnippets = controller.getSnippetManager().export();
        Authorizer authorizer = controller.getAuthorizer();
        if (AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)authorizer)) {
            ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
            existingAuthFingerprint = managedAuthorizer.getFingerprint().getBytes(StandardCharsets.UTF_8);
        } else {
            existingAuthFingerprint = null;
        }
        try {
            byte[] existingFlow = controller.isFlowSynchronized() ? this.toBytes(controller) : this.readFlowFromDisk();
            return new StandardDataFlow(existingFlow, existingSnippets, existingAuthFingerprint, missingComponents);
        }
        catch (IOException e) {
            throw new FlowSerializationException((Throwable)e);
        }
    }

    private byte[] toBytes(FlowController flowController) throws FlowSerializationException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        VersionedFlowSerializer flowSerializer = new VersionedFlowSerializer(this.extensionManager);
        flowController.serialize(flowSerializer, result);
        return result.toByteArray();
    }

    /*
     * Exception decompiling
     */
    private byte[] readFlowFromDisk() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void inheritSnippets(FlowController controller, DataFlow proposedFlow) {
        logger.trace("Clearing existing snippets");
        SnippetManager snippetManager = controller.getSnippetManager();
        snippetManager.clear();
        logger.trace("Loading proposed snippets");
        byte[] proposedSnippets = proposedFlow.getSnippets();
        if (proposedSnippets != null && proposedSnippets.length > 0) {
            for (StandardSnippet snippet : SnippetManager.parseBytes(proposedSnippets)) {
                snippetManager.addSnippet(snippet);
            }
        }
    }

    private void backupExistingFlow() {
        if (this.flowStorageFile.exists()) {
            try {
                File archiveFile = this.archiveManager.archive(this.flowStorageFile);
                logger.info("Successfully created backup of existing flow to {} before inheriting dataflow", (Object)archiveFile.getAbsolutePath());
            }
            catch (IOException ioe) {
                throw new UninheritableFlowException("Could not inherit flow because failed to make a backup of existing flow", ioe);
            }
        }
    }

    private static class FlowControllerComponentScheduler
    extends AbstractComponentScheduler
    implements ComponentScheduler {
        private final FlowController flowController;

        public FlowControllerComponentScheduler(FlowController flowController, VersionedComponentStateLookup stateLookup) {
            super(flowController.getControllerServiceProvider(), stateLookup);
            this.flowController = flowController;
        }

        public void startNow(Connectable component) {
            if (ExecutionEngine.STATELESS == component.getProcessGroup().resolveExecutionEngine()) {
                logger.info("{} should be running but will not start it because its Process Group is configured to run Stateless", (Object)component);
                return;
            }
            switch (component.getConnectableType()) {
                case PROCESSOR: {
                    this.flowController.startProcessor(component.getProcessGroupIdentifier(), component.getIdentifier());
                    break;
                }
                case INPUT_PORT: 
                case OUTPUT_PORT: {
                    this.flowController.startConnectable(component);
                    break;
                }
                case REMOTE_INPUT_PORT: 
                case REMOTE_OUTPUT_PORT: {
                    this.flowController.startTransmitting((RemoteGroupPort)component);
                }
            }
        }

        public void stopComponent(Connectable component) {
            this.flowController.stopConnectable(component);
        }

        protected void startNow(ReportingTaskNode reportingTask) {
            this.flowController.startReportingTask(reportingTask);
        }

        protected void startNow(ProcessGroup statelessGroup) {
            this.flowController.startProcessGroup(statelessGroup);
        }
    }
}

