/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.python.BoundObjectCounts;
import org.apache.nifi.python.PythonBridge;
import org.apache.nifi.python.PythonProcessorDetails;

public class PythonBridgeDiagnosticTask
implements DiagnosticTask {
    private final PythonBridge pythonBridge;

    public PythonBridgeDiagnosticTask(PythonBridge pythonBridge) {
        this.pythonBridge = pythonBridge;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<Object> details = new ArrayList<Object>();
        List processorDetails = this.pythonBridge.getProcessorTypes();
        details.add("Python Processors Available:");
        for (PythonProcessorDetails procDetails : processorDetails) {
            details.add(procDetails.getProcessorType() + " :: " + procDetails.getProcessorVersion());
        }
        Map counts = this.pythonBridge.getProcessCountsPerType();
        details.add("");
        details.add("Number of Python Processes for each Processor Type:");
        counts.forEach((key, value) -> details.add(key + " : " + value));
        if (verbose) {
            details.add("");
            details.add("Bound Object Counts:");
            List boundObjectCounts = this.pythonBridge.getBoundObjectCounts();
            for (BoundObjectCounts objectCounts : boundObjectCounts) {
                details.add(objectCounts.getProcess());
                details.add(objectCounts.getProcessorType());
                ArrayList countsList = new ArrayList(objectCounts.getCounts().entrySet());
                Comparator comparator = Map.Entry.comparingByValue();
                Comparator reversed = comparator.reversed();
                countsList.sort(reversed);
                countsList.forEach(entry -> details.add((String)entry.getKey() + " : " + String.valueOf(entry.getValue())));
                details.add("");
            }
        }
        return new StandardDiagnosticsDumpElement("Python Bridge", details);
    }
}

