/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleInitializationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.InitializationException;

public class GhostFlowAnalysisRule
implements FlowAnalysisRule {
    private String id;
    private String canonicalClassName;
    private ComponentLog logger;

    public void setIdentifier(String id) {
        this.id = id;
    }

    public void setCanonicalClassName(String canonicalClassName) {
        this.canonicalClassName = canonicalClassName;
    }

    public Collection<ValidationResult> validate(ValidationContext context) {
        return Collections.singleton(new ValidationResult.Builder().input("Any Property").subject("Missing Flow Analysis Rule").valid(false).explanation("Flow Analysis Rule is of type " + this.canonicalClassName + ", but this is not a valid Flow Analysis Rule type").build());
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        return this.buildDescriptor(name);
    }

    private PropertyDescriptor buildDescriptor(String propertyName) {
        return new PropertyDescriptor.Builder().name(propertyName).description(propertyName).required(true).sensitive(true).build();
    }

    public void onPropertyModified(PropertyDescriptor descriptor, String oldValue, String newValue) {
    }

    public List<PropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptyList();
    }

    public String getIdentifier() {
        return this.id;
    }

    public String toString() {
        return "GhostFlowAnalysisRule[id=" + this.id + "]";
    }

    public void initialize(FlowAnalysisRuleInitializationContext context) throws InitializationException {
        this.logger = context.getLogger();
    }
}

