/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.FlowFilePrioritizer;

public class QueuePrioritizer
implements Comparator<FlowFileRecord>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Comparator<FlowFileRecord> penaltyComparator = Comparator.comparing(FlowFile::isPenalized).thenComparingLong(record -> record.isPenalized() ? record.getPenaltyExpirationMillis() : 0L);
    private static final Comparator<FlowFileRecord> claimComparator = Comparator.comparing(FlowFileRecord::getContentClaim, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparingLong(FlowFileRecord::getContentClaimOffset);
    private static final Comparator<FlowFileRecord> idComparator = Comparator.comparingLong(FlowFile::getId);
    private final transient List<FlowFilePrioritizer> prioritizers;

    public QueuePrioritizer(List<FlowFilePrioritizer> priorities) {
        this.prioritizers = priorities == null ? List.of() : List.copyOf(priorities);
    }

    @Override
    public int compare(FlowFileRecord f1, FlowFileRecord f2) {
        int penaltyComparisonResult = penaltyComparator.compare(f1, f2);
        if (penaltyComparisonResult != 0) {
            return penaltyComparisonResult;
        }
        for (FlowFilePrioritizer comparator : this.prioritizers) {
            int prioritizerComparisonResult = comparator.compare((Object)f1, (Object)f2);
            if (prioritizerComparisonResult == 0) continue;
            return prioritizerComparisonResult;
        }
        int claimComparisionResult = claimComparator.compare(f1, f2);
        if (claimComparisionResult != 0) {
            return claimComparisionResult;
        }
        return idComparator.compare(f1, f2);
    }
}

