/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.Map;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.reporting.AbstractReportingContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.ReportingContext;

public class StandardReportingContext
extends AbstractReportingContext
implements ReportingContext {
    private final FlowController flowController;
    private final EventAccess eventAccess;
    private final boolean analyticsEnabled;

    public StandardReportingContext(FlowController flowController, BulletinRepository bulletinRepository, Map<PropertyDescriptor, String> properties, ReportingTaskNode reportingTaskNode, ParameterLookup parameterLookup) {
        super(reportingTaskNode, bulletinRepository, properties, flowController.getControllerServiceProvider(), parameterLookup);
        this.flowController = flowController;
        this.eventAccess = flowController.getEventAccess();
        this.analyticsEnabled = flowController.getStatusAnalyticsEngine() != null;
    }

    public EventAccess getEventAccess() {
        return this.eventAccess;
    }

    public StateManager getStateManager() {
        return this.flowController.getStateManagerProvider().getStateManager(this.getReportingTask().getIdentifier());
    }

    protected FlowManager getFlowManager() {
        return this.flowController.getFlowManager();
    }

    public boolean isClustered() {
        return this.flowController.isConfiguredForClustering();
    }

    public String getClusterNodeIdentifier() {
        NodeIdentifier nodeId = this.flowController.getNodeId();
        return nodeId == null ? null : nodeId.getId();
    }

    public boolean isAnalyticsEnabled() {
        return this.analyticsEnabled;
    }
}

