/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.NodeStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.StorageStatus;
import org.apache.nifi.controller.status.history.ComponentDetails;
import org.apache.nifi.controller.status.history.ComponentStatusHistory;
import org.apache.nifi.controller.status.history.ConnectionStatusDescriptor;
import org.apache.nifi.controller.status.history.EmptyStatusHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.NodeStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.ProcessorStatusDescriptor;
import org.apache.nifi.controller.status.history.RemoteProcessGroupStatusDescriptor;
import org.apache.nifi.controller.status.history.StandardGarbageCollectionHistory;
import org.apache.nifi.controller.status.history.StandardMetricDescriptor;
import org.apache.nifi.controller.status.history.StandardStatusHistory;
import org.apache.nifi.controller.status.history.StandardStatusSnapshot;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.util.ComponentMetrics;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.RingBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolatileComponentStatusRepository
implements StatusHistoryRepository {
    private static final Logger logger = LoggerFactory.getLogger(VolatileComponentStatusRepository.class);
    private static final Set<MetricDescriptor<?>> DEFAULT_PROCESSOR_METRICS = Arrays.stream(ProcessorStatusDescriptor.values()).map(ProcessorStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    private static final Set<MetricDescriptor<?>> DEFAULT_CONNECTION_METRICS = Arrays.stream(ConnectionStatusDescriptor.values()).map(ConnectionStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    private static final Set<MetricDescriptor<?>> DEFAULT_GROUP_METRICS = Arrays.stream(ProcessGroupStatusDescriptor.values()).map(ProcessGroupStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    private static final Set<MetricDescriptor<?>> DEFAULT_RPG_METRICS = Arrays.stream(RemoteProcessGroupStatusDescriptor.values()).map(RemoteProcessGroupStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    private static final Set<MetricDescriptor<NodeStatus>> DEFAULT_NODE_METRICS = Arrays.stream(NodeStatusDescriptor.values()).map(NodeStatusDescriptor::getDescriptor).collect(Collectors.toSet());
    private static final String STORAGE_FREE_DESCRIPTION = "The usable space available for use by the underlying storage mechanism.";
    private static final String STORAGE_USED_DESCRIPTION = "The space in use on the underlying storage mechanism";
    private static final String GC_TIME_DESCRIPTION = "The sum time the garbage collection has run since the start of the Java virtual machine.";
    private static final String GC_TIME_DIFF_DESCRIPTION = "The sum time the garbage collection has run since the last measurement.";
    private static final String GC_COUNT_DESCRIPTION = "The sum amount of occasions the garbage collection has run since the start of the Java virtual machine.";
    private static final String GC_COUNT_DIFF_DESCRIPTION = "The sum amount of occasions the garbage collection has run since the last measurement.";
    public static final String NUM_DATA_POINTS_PROPERTY = "nifi.components.status.repository.buffer.size";
    public static final int DEFAULT_NUM_DATA_POINTS = 288;
    private final Map<String, ComponentStatusHistory> componentStatusHistories = new HashMap<String, ComponentStatusHistory>();
    protected final RingBuffer<Date> timestamps;
    private final RingBuffer<List<GarbageCollectionStatus>> gcStatuses;
    private final RingBuffer<NodeStatus> nodeStatuses;
    private final int numDataPoints;
    private volatile long lastCaptureTime = 0L;

    public VolatileComponentStatusRepository() {
        this.numDataPoints = 288;
        this.gcStatuses = null;
        this.timestamps = null;
        this.nodeStatuses = null;
    }

    public VolatileComponentStatusRepository(NiFiProperties nifiProperties) {
        this.numDataPoints = nifiProperties.getIntegerProperty(NUM_DATA_POINTS_PROPERTY, Integer.valueOf(288));
        this.gcStatuses = new RingBuffer(this.numDataPoints);
        this.timestamps = new RingBuffer(this.numDataPoints);
        this.nodeStatuses = new RingBuffer(this.numDataPoints);
    }

    public synchronized void capture(NodeStatus nodeStatus, ProcessGroupStatus rootGroupStatus, List<GarbageCollectionStatus> gcStatus, Date timestamp) {
        Date evicted = (Date)this.timestamps.add((Object)timestamp);
        if (evicted != null) {
            this.componentStatusHistories.values().forEach(history -> history.expireBefore(evicted));
        }
        this.capture(rootGroupStatus, timestamp);
        this.nodeStatuses.add((Object)nodeStatus);
        this.gcStatuses.add(gcStatus);
        logger.debug("Captured metrics for {}", (Object)this);
        this.lastCaptureTime = Math.max(this.lastCaptureTime, timestamp.getTime());
    }

    private void capture(ProcessGroupStatus groupStatus, Date timestamp) {
        StatusSnapshot snapshot;
        ComponentDetails componentDetails;
        ComponentDetails groupDetails = ComponentDetails.forProcessGroup((ProcessGroupStatus)groupStatus);
        StatusSnapshot groupSnapshot = ComponentMetrics.createSnapshot(groupStatus, timestamp);
        this.updateStatusHistory(groupSnapshot, groupDetails, timestamp);
        for (ProcessorStatus processorStatus : groupStatus.getProcessorStatus()) {
            componentDetails = ComponentDetails.forProcessor((ProcessorStatus)processorStatus);
            snapshot = ComponentMetrics.createSnapshot(processorStatus, timestamp);
            this.updateStatusHistory(snapshot, componentDetails, timestamp);
        }
        for (ConnectionStatus connectionStatus : groupStatus.getConnectionStatus()) {
            componentDetails = ComponentDetails.forConnection((ConnectionStatus)connectionStatus);
            snapshot = ComponentMetrics.createSnapshot(connectionStatus, timestamp);
            this.updateStatusHistory(snapshot, componentDetails, timestamp);
        }
        for (RemoteProcessGroupStatus rpgStatus : groupStatus.getRemoteProcessGroupStatus()) {
            componentDetails = ComponentDetails.forRemoteProcessGroup((RemoteProcessGroupStatus)rpgStatus);
            snapshot = ComponentMetrics.createSnapshot(rpgStatus, timestamp);
            this.updateStatusHistory(snapshot, componentDetails, timestamp);
        }
        for (ProcessGroupStatus childStatus : groupStatus.getProcessGroupStatus()) {
            this.capture(childStatus, timestamp);
        }
    }

    private void updateStatusHistory(StatusSnapshot statusSnapshot, ComponentDetails componentDetails, Date timestamp) {
        String componentId = componentDetails.getComponentId();
        ComponentStatusHistory procHistory = this.componentStatusHistories.computeIfAbsent(componentId, id -> new ComponentStatusHistory(componentDetails, this.numDataPoints));
        procHistory.update(statusSnapshot, componentDetails);
    }

    public StatusHistory getProcessorStatusHistory(String processorId, Date start, Date end, int preferredDataPoints, boolean includeCounters) {
        return this.getStatusHistory(processorId, includeCounters, DEFAULT_PROCESSOR_METRICS, start, end, preferredDataPoints);
    }

    public StatusHistory getConnectionStatusHistory(String connectionId, Date start, Date end, int preferredDataPoints) {
        return this.getStatusHistory(connectionId, true, DEFAULT_CONNECTION_METRICS, start, end, preferredDataPoints);
    }

    public StatusHistory getProcessGroupStatusHistory(String processGroupId, Date start, Date end, int preferredDataPoints) {
        return this.getStatusHistory(processGroupId, true, DEFAULT_GROUP_METRICS, start, end, preferredDataPoints);
    }

    public StatusHistory getRemoteProcessGroupStatusHistory(String remoteGroupId, Date start, Date end, int preferredDataPoints) {
        return this.getStatusHistory(remoteGroupId, true, DEFAULT_RPG_METRICS, start, end, preferredDataPoints);
    }

    public StatusHistory getNodeStatusHistory(Date start, Date end) {
        int i;
        List nodeStatusList = this.nodeStatuses.asList();
        List gcStatusList = this.gcStatuses.asList();
        LinkedList<StandardStatusSnapshot> snapshots = new LinkedList<StandardStatusSnapshot>();
        HashSet<Object> metricDescriptors = new HashSet<Object>();
        HashSet<MetricDescriptor<NodeStatus>> nodeStatusDescriptors = new HashSet<MetricDescriptor<NodeStatus>>(DEFAULT_NODE_METRICS);
        LinkedList<StandardMetricDescriptor<List<GarbageCollectionStatus>>> gcMetricDescriptors = new LinkedList<StandardMetricDescriptor<List<GarbageCollectionStatus>>>();
        LinkedList<StandardMetricDescriptor<List<GarbageCollectionStatus>>> gcMetricDescriptorsDifferential = new LinkedList<StandardMetricDescriptor<List<GarbageCollectionStatus>>>();
        AtomicInteger counter = new AtomicInteger(DEFAULT_NODE_METRICS.size() - 1);
        if (nodeStatusList.size() > 0) {
            NodeStatus referenceNodeStatus = (NodeStatus)nodeStatusList.get(0);
            for (i = 0; i < referenceNodeStatus.getContentRepositories().size(); ++i) {
                nodeStatusDescriptors.add((MetricDescriptor<NodeStatus>)this.getContentStorageFree(referenceNodeStatus, i, counter.incrementAndGet()));
                nodeStatusDescriptors.add((MetricDescriptor<NodeStatus>)this.getContentStorageUsed(referenceNodeStatus, i, counter.incrementAndGet()));
            }
            for (i = 0; i < referenceNodeStatus.getProvenanceRepositories().size(); ++i) {
                nodeStatusDescriptors.add((MetricDescriptor<NodeStatus>)this.getProvenanceStorageFree(referenceNodeStatus, i, counter.incrementAndGet()));
                nodeStatusDescriptors.add((MetricDescriptor<NodeStatus>)this.getProvenanceStorageUsed(referenceNodeStatus, i, counter.incrementAndGet()));
            }
        }
        if (gcStatusList.size() > 0) {
            List gcStatuses = (List)gcStatusList.get(0);
            for (i = 0; i < gcStatuses.size(); ++i) {
                String memoryManager = ((GarbageCollectionStatus)gcStatuses.get(i)).getMemoryManagerName();
                gcMetricDescriptors.add(this.getGarbageCollectorTime(i, memoryManager, counter.incrementAndGet()));
                gcMetricDescriptors.add(VolatileComponentStatusRepository.getGarbageCollectorCount(i, memoryManager, counter.incrementAndGet()));
                gcMetricDescriptorsDifferential.add(VolatileComponentStatusRepository.getGarbageCollectorTimeDifference(i, memoryManager, counter.incrementAndGet()));
                gcMetricDescriptorsDifferential.add(VolatileComponentStatusRepository.getGarbageCollectorCountDifference(i, memoryManager, counter.incrementAndGet()));
            }
        }
        metricDescriptors.addAll(nodeStatusDescriptors);
        metricDescriptors.addAll(gcMetricDescriptors);
        metricDescriptors.addAll(gcMetricDescriptorsDifferential);
        for (int i2 = 0; i2 < nodeStatusList.size(); ++i2) {
            StandardStatusSnapshot snapshot = new StandardStatusSnapshot(metricDescriptors);
            NodeStatus nodeStatus = (NodeStatus)nodeStatusList.get(i2);
            List garbageCollectionStatuses = (List)gcStatusList.get(i2);
            snapshot.setTimestamp(new Date(nodeStatus.getCreatedAtInMs()));
            nodeStatusDescriptors.forEach(d -> snapshot.addStatusMetric(d, d.getValueFunction().getValue((Object)nodeStatus)));
            gcMetricDescriptors.forEach(d -> snapshot.addStatusMetric(d, d.getValueFunction().getValue((Object)garbageCollectionStatuses)));
            if (!snapshots.isEmpty()) {
                for (j = 0; j < gcMetricDescriptorsDifferential.size(); ++j) {
                    long previousValue = ((StatusSnapshot)snapshots.getLast()).getStatusMetric((MetricDescriptor)gcMetricDescriptors.get(j));
                    long currentValue = snapshot.getStatusMetric((MetricDescriptor)gcMetricDescriptors.get(j));
                    snapshot.addStatusMetric((MetricDescriptor)gcMetricDescriptorsDifferential.get(j), Long.valueOf(currentValue - previousValue));
                }
            } else {
                for (j = 0; j < gcMetricDescriptorsDifferential.size(); ++j) {
                    snapshot.addStatusMetric((MetricDescriptor)gcMetricDescriptorsDifferential.get(j), Long.valueOf(0L));
                }
            }
            snapshots.add(snapshot);
        }
        return new StandardStatusHistory(snapshots, new HashMap(), new Date());
    }

    private StandardMetricDescriptor<NodeStatus> getProvenanceStorageUsed(NodeStatus referenceNodeStatus, int storageNumber, int order) {
        return new StandardMetricDescriptor(() -> order, "provenanceStorage" + storageNumber + "Used", "Provenance Repository (" + ((StorageStatus)referenceNodeStatus.getProvenanceRepositories().get(storageNumber)).getName() + ") Used Space", STORAGE_USED_DESCRIPTION, MetricDescriptor.Formatter.DATA_SIZE, n -> ((StorageStatus)n.getProvenanceRepositories().get(storageNumber)).getUsedSpace());
    }

    private StandardMetricDescriptor<NodeStatus> getProvenanceStorageFree(NodeStatus referenceNodeStatus, int storageNumber, int order) {
        return new StandardMetricDescriptor(() -> order, "provenanceStorage" + storageNumber + "Free", "Provenance Repository (" + ((StorageStatus)referenceNodeStatus.getProvenanceRepositories().get(storageNumber)).getName() + ") Free Space", STORAGE_FREE_DESCRIPTION, MetricDescriptor.Formatter.DATA_SIZE, n -> ((StorageStatus)n.getProvenanceRepositories().get(storageNumber)).getFreeSpace());
    }

    private StandardMetricDescriptor<NodeStatus> getContentStorageUsed(NodeStatus referenceNodeStatus, int storageNumber, int order) {
        return new StandardMetricDescriptor(() -> order, "contentStorage" + storageNumber + "Used", "Content Repository (" + ((StorageStatus)referenceNodeStatus.getContentRepositories().get(storageNumber)).getName() + ") Used Space", STORAGE_USED_DESCRIPTION, MetricDescriptor.Formatter.DATA_SIZE, n -> ((StorageStatus)n.getContentRepositories().get(storageNumber)).getUsedSpace());
    }

    private StandardMetricDescriptor<NodeStatus> getContentStorageFree(NodeStatus referenceNodeStatus, int storageNumber, int order) {
        return new StandardMetricDescriptor(() -> order, "contentStorage" + storageNumber + "Free", "Content Repository (" + ((StorageStatus)referenceNodeStatus.getContentRepositories().get(storageNumber)).getName() + ") Free Space", STORAGE_FREE_DESCRIPTION, MetricDescriptor.Formatter.DATA_SIZE, n -> ((StorageStatus)n.getContentRepositories().get(storageNumber)).getFreeSpace());
    }

    private static StandardMetricDescriptor<List<GarbageCollectionStatus>> getGarbageCollectorCount(int gcNumber, String memoryManagerName, int order) {
        return new StandardMetricDescriptor(() -> order, "gc" + gcNumber + "Count", memoryManagerName + " Collection Count", GC_COUNT_DESCRIPTION, MetricDescriptor.Formatter.COUNT, gcs -> ((GarbageCollectionStatus)gcs.get(gcNumber)).getCollectionCount());
    }

    private StandardMetricDescriptor<List<GarbageCollectionStatus>> getGarbageCollectorTime(int gcNumber, String memoryManagerName, int order) {
        return new StandardMetricDescriptor(() -> order, "gc" + gcNumber + "Time", memoryManagerName + " Collection Time (milliseconds)", GC_TIME_DESCRIPTION, MetricDescriptor.Formatter.COUNT, gcs -> ((GarbageCollectionStatus)gcs.get(gcNumber)).getCollectionMillis());
    }

    private static StandardMetricDescriptor<List<GarbageCollectionStatus>> getGarbageCollectorTimeDifference(int gcNumber, String memoryManagerName, int order) {
        return new StandardMetricDescriptor(() -> order, "gc" + gcNumber + "TimeDifference", memoryManagerName + " Collection Time (5 mins, in milliseconds)", GC_TIME_DIFF_DESCRIPTION, MetricDescriptor.Formatter.COUNT, gcs -> 0L);
    }

    private static StandardMetricDescriptor<List<GarbageCollectionStatus>> getGarbageCollectorCountDifference(int gcNumber, String memoryManagerName, int order) {
        return new StandardMetricDescriptor(() -> order, "gc" + gcNumber + "CountDifference", memoryManagerName + " Collection Count (5 mins)", GC_COUNT_DIFF_DESCRIPTION, MetricDescriptor.Formatter.COUNT, gcs -> 0L);
    }

    private synchronized StatusHistory getStatusHistory(String componentId, boolean includeCounters, Set<MetricDescriptor<?>> defaultMetricDescriptors, Date start, Date end, int preferredDataPoints) {
        ComponentStatusHistory history = this.componentStatusHistories.get(componentId);
        if (history == null) {
            return new EmptyStatusHistory();
        }
        List<Date> dates = this.filterDates(start, end, preferredDataPoints);
        return history.toStatusHistory(dates, includeCounters, defaultMetricDescriptors);
    }

    protected List<Date> filterDates(Date start, Date end, int preferredDataPoints) {
        Date startDate = start == null ? new Date(0L) : start;
        Date endDate = end == null ? new Date() : end;
        List filteredDates = this.timestamps.asList().stream().filter(p -> !(!p.after(startDate) && !p.equals(startDate) || !p.before(endDate) && !p.equals(endDate))).collect(Collectors.toList());
        return filteredDates.subList(Math.max(filteredDates.size() - preferredDataPoints, 0), filteredDates.size());
    }

    public GarbageCollectionHistory getGarbageCollectionHistory(Date start, Date end) {
        StandardGarbageCollectionHistory history = new StandardGarbageCollectionHistory();
        this.gcStatuses.forEach(statusSet -> {
            for (GarbageCollectionStatus gcStatus : statusSet) {
                if (gcStatus.getTimestamp().before(start) || gcStatus.getTimestamp().after(end)) continue;
                history.addGarbageCollectionStatus(gcStatus);
            }
            return true;
        });
        return history;
    }

    public void start() {
    }

    public void shutdown() {
    }
}

