/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.shell.result;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.nifi.diagnostics.bootstrap.shell.result.ShellCommandResult;

public class SingleLineResult
implements ShellCommandResult {
    private final String label;
    private final String commandName;

    public SingleLineResult(String label, String commandName) {
        this.label = label;
        this.commandName = commandName;
    }

    @Override
    public Collection<String> createResult(InputStream inputStream) {
        ArrayList<String> arrayList;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                result.add(String.format("%s : %s", this.label, line));
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to process result for command: %s", this.commandName), e);
            }
        }
        reader.close();
        return arrayList;
    }
}

