/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.tasks;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.RepositoryStatusReport;
import org.apache.nifi.diagnostics.DiagnosticTask;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;
import org.apache.nifi.diagnostics.StandardDiagnosticsDumpElement;
import org.apache.nifi.processor.DataUnit;

public class ProcessorTimingDiagnosticTask
implements DiagnosticTask {
    private final FlowFileEventRepository eventRepo;
    private final FlowManager flowManager;
    private static final String PROCESSOR_TIMING_FORMAT = "| %1$-36.36s | %2$-36.36s | %3$-36.36s | %4$-36.36s | %5$15.15s | %6$27.27s | %7$25.25s | %8$16.16s | %9$16.16s | %10$20.20s | %11$13.13s | %12$11.11s | %13$11.11s |";

    public ProcessorTimingDiagnosticTask(FlowFileEventRepository flowFileEventRepository, FlowManager flowManager) {
        this.eventRepo = flowFileEventRepository;
        this.flowManager = flowManager;
    }

    public DiagnosticsDumpElement captureDump(boolean verbose) {
        ArrayList<Object> details = new ArrayList<Object>();
        RepositoryStatusReport statusReport = this.eventRepo.reportTransferEvents(System.currentTimeMillis());
        Map eventsByComponentId = statusReport.getReportEntries();
        ArrayList<ProcessorTiming> timings = new ArrayList<ProcessorTiming>();
        eventsByComponentId.entrySet().stream().map(entry -> this.getTiming((String)entry.getKey(), (FlowFileEvent)entry.getValue())).filter(Objects::nonNull).forEach(timings::add);
        timings.sort(Comparator.comparing(ProcessorTiming::getCpuNanos).reversed());
        DecimalFormat dataSizeFormat = new DecimalFormat("#,###,###.##");
        DecimalFormat percentageFormat = new DecimalFormat("##.##");
        NumberFormat secondsFormat = NumberFormat.getInstance();
        long totalCpuNanos = 0L;
        long totalProcNanos = 0L;
        long totalReadNanos = 0L;
        long totalWriteNanos = 0L;
        long totalSessionCommitNanos = 0L;
        long totalBytesRead = 0L;
        long totalBytesWritten = 0L;
        long totalGcNanos = 0L;
        for (ProcessorTiming timing : timings) {
            totalCpuNanos += timing.getCpuNanos();
            totalProcNanos += timing.getProcessingNanos();
            totalReadNanos += timing.getReadNanos();
            totalWriteNanos += timing.getWriteNanos();
            totalSessionCommitNanos += timing.getSessionCommitNanos();
            totalBytesRead += timing.getBytesRead();
            totalBytesWritten += timing.getBytesWritten();
            totalGcNanos += timing.getGarbageCollectionNanos();
        }
        if (totalCpuNanos < 1L) {
            details.add("No Processor Timing Diagnostic information has been gathered.");
            return new StandardDiagnosticsDumpElement("Processor Timing Diagnostics (Stats over last 5 minutes)", details);
        }
        details.add(String.format(PROCESSOR_TIMING_FORMAT, "Processor ID", "Processor Name", "Processor Type", "Process Group Name", "Processing Secs", "CPU Secs (% time using CPU)", "Pct CPU Time Used by Proc", "Disk Read Secs", "Disk Write Secs", "Session Commit Secs", "GC Millis", "MB Read", "MB Written"));
        for (ProcessorTiming timing : timings) {
            long procNanos = timing.getProcessingNanos();
            if (procNanos < 1L) continue;
            String cpuTime = this.nanosToPercentTime(timing.getCpuNanos(), procNanos, secondsFormat);
            String cpuPct = percentageFormat.format(timing.getCpuNanos() * 100L / totalCpuNanos);
            String readTime = this.nanosToPercentTime(timing.getReadNanos(), procNanos, secondsFormat);
            String writeTime = this.nanosToPercentTime(timing.getWriteNanos(), procNanos, secondsFormat);
            String commitTime = this.nanosToPercentTime(timing.getSessionCommitNanos(), procNanos, secondsFormat);
            String gcTime = this.nanosToPercentTime(timing.getGarbageCollectionNanos(), procNanos, secondsFormat);
            String formatted = String.format(PROCESSOR_TIMING_FORMAT, timing.getId(), timing.getName(), timing.getType(), timing.getGroupName(), secondsFormat.format(TimeUnit.NANOSECONDS.toSeconds(timing.getProcessingNanos())), cpuTime, cpuPct, readTime, writeTime, commitTime, gcTime, dataSizeFormat.format(DataUnit.B.toMB((double)timing.getBytesRead())), dataSizeFormat.format(DataUnit.B.toMB((double)timing.getBytesWritten())));
            details.add(formatted);
        }
        String formatted = String.format(PROCESSOR_TIMING_FORMAT, "Total", "--", "--", "--", secondsFormat.format(TimeUnit.NANOSECONDS.toSeconds(totalProcNanos)), this.nanosToPercentTime(totalCpuNanos, totalProcNanos, secondsFormat), "100.00", this.nanosToPercentTime(totalReadNanos, totalProcNanos, secondsFormat), this.nanosToPercentTime(totalWriteNanos, totalProcNanos, secondsFormat), this.nanosToPercentTime(totalSessionCommitNanos, totalProcNanos, secondsFormat), this.nanosToPercentTime(totalGcNanos, totalProcNanos, secondsFormat), dataSizeFormat.format(DataUnit.B.toMB((double)totalBytesRead)), dataSizeFormat.format(DataUnit.B.toMB((double)totalBytesWritten)));
        details.add(formatted);
        double mbReadPerSecond = DataUnit.B.toMB((double)totalBytesRead) / 300.0;
        double mbWrittenPerSecond = DataUnit.B.toMB((double)totalBytesWritten) / 300.0;
        details.add("");
        details.add("Average MB/sec read from Content Repo in last 5 mins: " + dataSizeFormat.format(mbReadPerSecond));
        details.add("Average MB/sec written to Content Repo in last 5 mins: " + dataSizeFormat.format(mbWrittenPerSecond));
        return new StandardDiagnosticsDumpElement("Processor Timing Diagnostics (Stats over last 5 minutes)", details);
    }

    private String nanosToPercentTime(long nanos, long processingNanos, NumberFormat secondsFormat) {
        return secondsFormat.format(TimeUnit.NANOSECONDS.toSeconds(nanos)) + " (" + Math.min(100, (int)(nanos * 100L / processingNanos)) + "%)";
    }

    private ProcessorTiming getTiming(String processorId, FlowFileEvent flowFileEvent) {
        ProcessorNode processorNode = this.flowManager.getProcessorNode(processorId);
        if (processorNode == null) {
            return null;
        }
        ProcessorTiming timing = new ProcessorTiming(processorNode, flowFileEvent);
        return timing;
    }

    private static class ProcessorTiming {
        private final String id;
        private final String name;
        private final String type;
        private final String groupName;
        private final FlowFileEvent flowFileEvent;

        public ProcessorTiming(ProcessorNode processor, FlowFileEvent flowFileEvent) {
            this.id = processor.getIdentifier();
            this.name = processor.getName();
            this.type = processor.getComponentType();
            this.groupName = processor.getProcessGroup().getName();
            this.flowFileEvent = flowFileEvent;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public long getProcessingNanos() {
            return this.flowFileEvent.getProcessingNanoseconds();
        }

        public long getCpuNanos() {
            return this.flowFileEvent.getCpuNanoseconds();
        }

        public long getReadNanos() {
            return this.flowFileEvent.getContentReadNanoseconds();
        }

        public long getWriteNanos() {
            return this.flowFileEvent.getContentWriteNanoseconds();
        }

        public long getSessionCommitNanos() {
            return this.flowFileEvent.getSessionCommitNanoseconds();
        }

        public long getBytesRead() {
            return this.flowFileEvent.getBytesRead();
        }

        public long getBytesWritten() {
            return this.flowFileEvent.getBytesWritten();
        }

        public long getGarbageCollectionNanos() {
            return TimeUnit.MILLISECONDS.toNanos(this.flowFileEvent.getGargeCollectionMillis());
        }
    }
}

