/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.components.PortFunction;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.state.StatelessStateManagerProvider;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SchedulingAgentCallback;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.scheduling.LifecycleState;
import org.apache.nifi.controller.scheduling.LifecycleStateManager;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.scheduling.StatelessProcessScheduler;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.tasks.StatelessFlowTask;
import org.apache.nifi.flow.VersionedExternalFlow;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.StatelessGroupFactory;
import org.apache.nifi.groups.StatelessGroupNode;
import org.apache.nifi.groups.StatelessGroupNodeInitializationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.stateless.engine.ProcessContextFactory;
import org.apache.nifi.stateless.engine.StatelessProcessContextFactory;
import org.apache.nifi.stateless.flow.DataflowDefinition;
import org.apache.nifi.stateless.flow.StandardDataflowDefinition;
import org.apache.nifi.stateless.flow.StandardStatelessFlow;
import org.apache.nifi.stateless.flow.StatelessDataflow;
import org.apache.nifi.stateless.flow.TransactionThresholds;
import org.apache.nifi.stateless.repository.RepositoryContextFactory;
import org.apache.nifi.util.FormatUtils;

public class StandardStatelessGroupNode
implements StatelessGroupNode {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private volatile ScheduledState currentState = ScheduledState.STOPPED;
    private volatile ScheduledState desiredState = ScheduledState.STOPPED;
    private volatile int maxConcurrentTasks = 1;
    private final AtomicLong yieldExpiration = new AtomicLong(0L);
    private final ProcessGroup processGroup;
    private final ControllerServiceProvider controllerServiceProvider;
    private final StateManagerProvider stateManagerProvider;
    private final ExtensionManager extensionManager;
    private final RepositoryContextFactory statelessRepoContextFactory;
    private final FlowFileRepository nifiFlowFileRepository;
    private final ContentRepository nifiContentRepository;
    private final ProvenanceEventRepository nifiProvenanceRepo;
    private final BulletinRepository bulletinRepository;
    private final StatelessGroupFactory statelessGroupFactory;
    private final LifecycleStateManager lifecycleStateManager;
    private final FlowFileEventRepository flowFileEventRepository;
    private final long boredYieldMillis;
    private volatile List<Connection> incomingConnections;
    private volatile Set<Connection> allOutgoingConnections;
    private volatile Map<String, Set<Connection>> outgoingConnectionsByPort;
    private volatile Map<String, Relationship> relationships;
    private final BlockingQueue<StatelessFlowTask> flowTaskQueue = new LinkedBlockingDeque<StatelessFlowTask>();
    private volatile List<StatelessFlowTask> initializedFlowTasks;
    private volatile boolean primaryNodeOnly = false;
    private volatile long schedulingNanos = 1L;
    private ComponentLog logger;

    private StandardStatelessGroupNode(Builder builder) {
        this.processGroup = builder.rootGroup;
        this.controllerServiceProvider = builder.controllerServiceProvider;
        this.stateManagerProvider = builder.stateManagerProvider;
        this.extensionManager = builder.extensionManager;
        this.statelessRepoContextFactory = builder.statelessRepoContextFactory;
        this.nifiFlowFileRepository = builder.nifiFlowFileRepository;
        this.nifiContentRepository = builder.nifiContentRepository;
        this.nifiProvenanceRepo = builder.nifiProvenanceRepo;
        this.bulletinRepository = builder.bulletinRepository;
        this.statelessGroupFactory = builder.statelessGroupFactory;
        this.lifecycleStateManager = builder.lifecycleStateManager;
        this.flowFileEventRepository = builder.flowFileEventRepository;
        this.boredYieldMillis = builder.boredYieldMillis;
    }

    public void initialize(StatelessGroupNodeInitializationContext initializationContext) {
        this.logger = initializationContext.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ScheduledExecutorService executor, SchedulingAgentCallback schedulingAgentCallback, LifecycleState lifecycleState) {
        this.writeLock.lock();
        try {
            if (this.currentState != ScheduledState.STOPPED) {
                this.logger.warn("Cannot start {} because it is not currently stopped; its current state is {}", new Object[]{this, this.currentState});
                return;
            }
            this.desiredState = ScheduledState.RUNNING;
            this.currentState = ScheduledState.STARTING;
            this.logger.info("Starting {}", new Object[]{this});
        }
        finally {
            this.writeLock.unlock();
        }
        this.getProcessGroup().findAllInputPorts().forEach(Port::onSchedulingStart);
        this.getProcessGroup().findAllOutputPorts().forEach(Port::onSchedulingStart);
        executor.submit(() -> this.initialize(executor, schedulingAgentCallback, lifecycleState));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(ScheduledExecutorService executor, SchedulingAgentCallback schedulingAgentCallback, LifecycleState lifecycleState) {
        if (this.getDesiredState() != ScheduledState.RUNNING) {
            this.shutdown();
            return;
        }
        if (!lifecycleState.isScheduled()) {
            this.logger.debug("Triggered to initialize {} but Lifecycle State indicates that the component is not scheduled. Will not initialize", new Object[]{this});
            return;
        }
        lifecycleState.incrementActiveThreadCount(null);
        try {
            boolean triggerSerially;
            this.logger.info("Initializing {}", new Object[]{this});
            this.flowTaskQueue.clear();
            boolean runOnPrimaryNodeOnly = false;
            ArrayList<ProcessorNode> triggerSeriallyProcessors = new ArrayList<ProcessorNode>();
            long schedulingNanos = 1L;
            for (ProcessorNode processorNode : this.processGroup.findAllProcessors()) {
                if (processorNode.isIsolated()) {
                    runOnPrimaryNodeOnly = true;
                    triggerSeriallyProcessors.add(processorNode);
                } else if (processorNode.isTriggeredSerially()) {
                    triggerSeriallyProcessors.add(processorNode);
                }
                if (!this.isSourceProcessor(processorNode)) continue;
                long processorNanos = processorNode.getSchedulingPeriod(TimeUnit.NANOSECONDS);
                schedulingNanos = Math.max(schedulingNanos, processorNanos);
            }
            this.primaryNodeOnly = runOnPrimaryNodeOnly;
            this.schedulingNanos = schedulingNanos;
            boolean bl = triggerSerially = !triggerSeriallyProcessors.isEmpty();
            if (this.maxConcurrentTasks > 1 && triggerSerially) {
                this.logger.warn("Flow is configured to run using the Stateless Engine with {} max concurrent tasks. However, {} only allows a single concurrent task or allows running only on the Primary Node, so the flow will run with a single concurrent task", new Object[]{this.maxConcurrentTasks, triggerSeriallyProcessors});
            }
            ArrayList<StandardStatelessFlow> createdFlows = new ArrayList<StandardStatelessFlow>();
            this.initializedFlowTasks = new ArrayList<StatelessFlowTask>();
            try {
                VersionedExternalFlow versionedExternalFlow = this.statelessGroupFactory.createVersionedExternalFlow(this.processGroup);
                this.initializeInputsAndOutputs();
                String timeout = this.processGroup.getStatelessFlowTimeout();
                long timeoutMillis = (long)FormatUtils.getPreciseTimeDuration((String)timeout, (TimeUnit)TimeUnit.MILLISECONDS);
                int concurrentTasks = triggerSerially ? 1 : this.maxConcurrentTasks;
                for (int i = 0; i < concurrentTasks; ++i) {
                    StandardStatelessFlow statelessFlow = this.createStatelessFlow(this.processGroup, versionedExternalFlow);
                    createdFlows.add(statelessFlow);
                    StatelessFlowTask task = new StatelessFlowTask.Builder().statelessGroupNode(this).nifiFlowFileRepository(this.nifiFlowFileRepository).nifiContentRepository(this.nifiContentRepository).nifiProvenanceRepository(this.nifiProvenanceRepo).statelessFlow((StatelessDataflow)statelessFlow).flowFileEventRepository(this.flowFileEventRepository).timeout(Math.max(0L, timeoutMillis), TimeUnit.MILLISECONDS).logger(this.logger).build();
                    this.flowTaskQueue.offer(task);
                    this.initializedFlowTasks.add(task);
                }
            }
            catch (Exception e) {
                for (StandardStatelessFlow flow : createdFlows) {
                    try {
                        flow.shutdown(false, true);
                    }
                    catch (Exception ex) {
                        this.logger.error("Failed to shutdown Stateless Flow {}", new Object[]{flow, ex});
                    }
                }
                this.flowTaskQueue.clear();
                this.logger.error("Failed to start {}; will try again in 10 seconds", new Object[]{this, e});
                executor.schedule(() -> this.initialize(executor, schedulingAgentCallback, lifecycleState), 10L, TimeUnit.SECONDS);
                lifecycleState.decrementActiveThreadCount();
                return;
            }
            this.initializeInputsAndOutputs();
            boolean shutdown = false;
            this.writeLock.lock();
            try {
                if (this.desiredState == ScheduledState.RUNNING) {
                    schedulingAgentCallback.trigger();
                    this.logger.info("{} has been started", new Object[]{this});
                    this.currentState = ScheduledState.RUNNING;
                } else {
                    this.logger.info("{} completed setup but is no longer scheduled to run; desired state is now {}; will shutdown", new Object[]{this, this.desiredState});
                    shutdown = true;
                }
            }
            finally {
                this.writeLock.unlock();
            }
            if (shutdown) {
                this.shutdown();
            }
        }
        finally {
            lifecycleState.decrementActiveThreadCount();
        }
    }

    private void initializeInputsAndOutputs() {
        ArrayList<Connection> incomingConnections = new ArrayList<Connection>();
        for (Port port : this.processGroup.getInputPorts()) {
            incomingConnections.addAll(port.getIncomingConnections());
        }
        this.incomingConnections = incomingConnections;
        HashMap<String, Relationship> relationships = new HashMap<String, Relationship>();
        HashMap<String, Set> outgoingConnections = new HashMap<String, Set>();
        HashSet allOutgoingConnections = new HashSet();
        for (Port port : this.processGroup.getOutputPorts()) {
            allOutgoingConnections.addAll(port.getConnections());
            outgoingConnections.put(port.getName(), port.getConnections());
            relationships.put(port.getName(), new Relationship.Builder().name(port.getName()).build());
        }
        this.outgoingConnectionsByPort = Collections.unmodifiableMap(outgoingConnections);
        this.allOutgoingConnections = Collections.unmodifiableSet(allOutgoingConnections);
        this.relationships = Collections.unmodifiableMap(relationships);
    }

    private void shutdown() {
        this.logger.info("{} has been stopped", new Object[]{this});
        this.writeLock.lock();
        try {
            this.shutdownFlows();
            this.processGroup.stopComponents();
            this.flowTaskQueue.clear();
            this.currentState = ScheduledState.STOPPED;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void shutdownFlows() {
        List<StatelessFlowTask> tasks = this.initializedFlowTasks;
        if (tasks != null) {
            tasks.forEach(StatelessFlowTask::shutdown);
        }
    }

    private StandardStatelessFlow createStatelessFlow(ProcessGroup group, VersionedExternalFlow versionedExternalFlow) {
        Set failurePortNames = group.getOutputPorts().stream().filter(port -> port.getPortFunction() == PortFunction.FAILURE).map(Connectable::getName).collect(Collectors.toSet());
        StandardDataflowDefinition dataflowDefinition = new StandardDataflowDefinition.Builder().versionedExternalFlow(versionedExternalFlow).failurePortNames(failurePortNames).transactionThresholds(TransactionThresholds.UNLIMITED).build();
        StatelessProcessScheduler processScheduler = new StatelessProcessScheduler(this.extensionManager, Duration.of(10L, ChronoUnit.SECONDS)){

            public void yield(ProcessorNode procNode) {
                if (StandardStatelessGroupNode.this.isSourceProcessor(procNode)) {
                    StandardStatelessGroupNode.this.yield(procNode.getYieldPeriod(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
                }
            }
        };
        StatelessStateManagerProvider statelessStateManagerProvider = new StatelessStateManagerProvider();
        StatelessProcessContextFactory processContextFactory = new StatelessProcessContextFactory(this.controllerServiceProvider, this.stateManagerProvider);
        ProcessGroup rootGroup = this.statelessGroupFactory.createStatelessProcessGroup(group, versionedExternalFlow);
        StandardStatelessFlow dataflow = new StandardStatelessFlow(rootGroup, Collections.emptyList(), this.controllerServiceProvider, (ProcessContextFactory)processContextFactory, this.statelessRepoContextFactory, (DataflowDefinition)dataflowDefinition, statelessStateManagerProvider, (ProcessScheduler)processScheduler, this.bulletinRepository, this.lifecycleStateManager, Duration.of(10L, ChronoUnit.SECONDS));
        dataflow.initialize();
        return dataflow;
    }

    private boolean isSourceProcessor(ProcessorNode procNode) {
        List incomingConnections = procNode.getIncomingConnections();
        if (incomingConnections.isEmpty()) {
            return true;
        }
        for (Connection connection : incomingConnections) {
            boolean selfLoop = connection.getSource() == procNode;
            if (selfLoop) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> stop(ProcessScheduler processScheduler, ScheduledExecutorService executor, SchedulingAgent schedulingAgent, LifecycleState lifecycleState) {
        this.logger.info("Stopping {}", new Object[]{this});
        lifecycleState.incrementActiveThreadCount(null);
        this.writeLock.lock();
        try {
            schedulingAgent.unschedule((Connectable)this, lifecycleState);
            if (this.currentState == ScheduledState.STOPPED || this.currentState == ScheduledState.STOPPING) {
                this.logger.debug("Attempt to stop {} but state is already {}", new Object[]{this, this.currentState});
                lifecycleState.decrementActiveThreadCount();
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            if (this.currentState != ScheduledState.STARTING && this.currentState != ScheduledState.RUNNING) {
                this.logger.warn("Cannot stop {} because it is not currently running or starting; its current state is {}", new Object[]{this, this.currentState});
                lifecycleState.decrementActiveThreadCount();
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                return completableFuture;
            }
            this.desiredState = ScheduledState.STOPPED;
            this.currentState = ScheduledState.STOPPING;
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            processScheduler.submitFrameworkTask(() -> {
                this.shutdownFlows();
                this.stopPorts();
                this.stopCanvasComponents(processScheduler).join();
                lifecycleState.decrementActiveThreadCount();
                this.currentState = ScheduledState.STOPPED;
                this.logger.info("{} is now fully stopped.", new Object[]{this});
                this.flowTaskQueue.clear();
                future.complete(null);
            });
            CompletableFuture<Void> completableFuture = future;
            return completableFuture;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private CompletableFuture<Void> stopCanvasComponents(ProcessScheduler scheduler) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (ProcessorNode procNode : this.getProcessGroup().findAllProcessors()) {
            CompletableFuture stopProcessorFuture = scheduler.stopProcessor(procNode);
            futures.add(stopProcessorFuture);
        }
        for (ProcessGroup innerGroup : this.getProcessGroup().findAllProcessGroups()) {
            innerGroup.getInputPorts().forEach(arg_0 -> ((ProcessScheduler)scheduler).stopPort(arg_0));
            innerGroup.getOutputPorts().forEach(arg_0 -> ((ProcessScheduler)scheduler).stopPort(arg_0));
        }
        Set controllerServices = this.getProcessGroup().findAllControllerServices();
        CompletableFuture[] processorFutureArray = futures.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> processorsStoppedFuture = CompletableFuture.allOf(processorFutureArray);
        CompletionStage allStoppedFuture = processorsStoppedFuture.thenAccept(completion -> this.controllerServiceProvider.disableControllerServicesAsync((Collection)controllerServices).join());
        return allStoppedFuture;
    }

    private void stopPorts() {
        ArrayList<Port> allPorts = new ArrayList<Port>();
        allPorts.addAll(this.getProcessGroup().findAllInputPorts());
        allPorts.addAll(this.getProcessGroup().findAllOutputPorts());
        allPorts.forEach(Port::shutdown);
        while (!this.isStopped(allPorts)) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private boolean isStopped(Collection<Port> ports) {
        for (Port port : ports) {
            if (!port.isRunning()) continue;
            return false;
        }
        return true;
    }

    public ScheduledState getCurrentState() {
        return this.currentState;
    }

    public ScheduledState getDesiredState() {
        return this.desiredState;
    }

    public String toString() {
        return "StandardStatelessGroupNode[group=" + String.valueOf(this.processGroup) + "]";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        StandardStatelessGroupNode that = (StandardStatelessGroupNode)other;
        return Objects.equals(this.processGroup, that.processGroup);
    }

    public int hashCode() {
        return Objects.hash(this.processGroup);
    }

    public Optional<String> getVersionedComponentId() {
        return this.processGroup.getVersionedComponentId();
    }

    public void setVersionedComponentId(String versionedComponentId) {
    }

    public Authorizable getParentAuthorizable() {
        return this.processGroup;
    }

    public Resource getResource() {
        return this.processGroup.getResource();
    }

    public String getProcessGroupIdentifier() {
        return this.processGroup.getIdentifier();
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) throws ProcessException {
        StatelessFlowTask task = (StatelessFlowTask)this.flowTaskQueue.poll();
        if (task == null) {
            return;
        }
        try {
            task.trigger();
        }
        catch (ProcessException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ProcessException("Failed while running Stateless Flow", (Throwable)e);
        }
        finally {
            if (this.desiredState == ScheduledState.RUNNING) {
                this.flowTaskQueue.offer(task);
            }
        }
    }

    public void setMaxConcurrentTasks(int taskCount) {
        this.maxConcurrentTasks = taskCount;
    }

    public int getMaxConcurrentTasks() {
        boolean triggerSerially = this.processGroup.findAllProcessors().stream().anyMatch(ProcessorNode::isTriggeredSerially);
        return triggerSerially ? 1 : this.maxConcurrentTasks;
    }

    public ScheduledState getScheduledState() {
        return this.getCurrentState();
    }

    public boolean isRunning() {
        ScheduledState state = this.getCurrentState();
        return state == ScheduledState.RUNNING || state == ScheduledState.RUN_ONCE || state == ScheduledState.STARTING;
    }

    public boolean isIsolated() {
        return this.primaryNodeOnly;
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos, TimeUnit.NANOSECONDS);
    }

    public String getSchedulingPeriod() {
        return this.schedulingNanos + " nanos";
    }

    public void setSchedulingPeriod(String schedulingPeriod) {
    }

    public Position getPosition() {
        return this.processGroup.getPosition();
    }

    public void setPosition(Position position) {
        this.processGroup.setPosition(position);
    }

    public String getIdentifier() {
        return this.processGroup.getIdentifier();
    }

    public Collection<Relationship> getRelationships() {
        return this.relationships.values();
    }

    public Relationship getRelationship(String relationshipName) {
        return this.relationships.get(relationshipName);
    }

    public void addConnection(Connection connection) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public boolean hasIncomingConnection() {
        return !this.incomingConnections.isEmpty();
    }

    public void removeConnection(Connection connection) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void updateConnection(Connection newConnection) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public List<Connection> getIncomingConnections() {
        return this.incomingConnections;
    }

    public Set<Connection> getConnections() {
        return this.allOutgoingConnections;
    }

    public Set<Connection> getConnections(Relationship relationship) {
        Set<Connection> connections = this.outgoingConnectionsByPort.get(relationship.getName());
        return connections == null ? Collections.emptySet() : connections;
    }

    public String getName() {
        return this.processGroup.getName();
    }

    public void setName(String name) {
    }

    public String getComments() {
        return null;
    }

    public void setComments(String comments) {
    }

    public boolean isTriggerWhenEmpty() {
        return false;
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup;
    }

    public void setProcessGroup(ProcessGroup group) {
        throw new UnsupportedOperationException();
    }

    public boolean isAutoTerminated(Relationship relationship) {
        return false;
    }

    public boolean isLossTolerant() {
        return false;
    }

    public void setLossTolerant(boolean lossTolerant) {
        throw new UnsupportedOperationException();
    }

    public ConnectableType getConnectableType() {
        return ConnectableType.STATELESS_GROUP;
    }

    public Collection<ValidationResult> getValidationErrors() {
        return Collections.emptyList();
    }

    public long getPenalizationPeriod(TimeUnit timeUnit) {
        return 0L;
    }

    public String getPenalizationPeriod() {
        return "0 secs";
    }

    public long getYieldPeriod(TimeUnit timeUnit) {
        return 0L;
    }

    public String getYieldPeriod() {
        return "0 secs";
    }

    public void setYieldPeriod(String yieldPeriod) {
    }

    public void setPenalizationPeriod(String penalizationPeriod) {
    }

    public void yield() {
    }

    public void yield(long yieldDuration, TimeUnit timeUnit) {
        long newExpiration = System.currentTimeMillis() + timeUnit.toMillis(yieldDuration);
        boolean updated = false;
        while (!updated) {
            long currentExpiration = this.yieldExpiration.get();
            if (newExpiration <= currentExpiration) {
                return;
            }
            updated = this.yieldExpiration.compareAndSet(currentExpiration, newExpiration);
        }
    }

    public long getYieldExpiration() {
        return this.yieldExpiration.get();
    }

    public long getBoredYieldDuration(TimeUnit timeUnit) {
        return TimeUnit.MILLISECONDS.convert(this.boredYieldMillis, timeUnit);
    }

    public boolean isSideEffectFree() {
        return false;
    }

    public void verifyCanDelete() throws IllegalStateException {
    }

    public void verifyCanDelete(boolean ignoreConnections) throws IllegalStateException {
    }

    public void verifyCanStart() throws IllegalStateException {
    }

    public void verifyCanStop() throws IllegalStateException {
    }

    public void verifyCanUpdate() throws IllegalStateException {
    }

    public void verifyCanEnable() throws IllegalStateException {
    }

    public void verifyCanDisable() throws IllegalStateException {
    }

    public void verifyCanClearState() throws IllegalStateException {
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return SchedulingStrategy.TIMER_DRIVEN;
    }

    public String getComponentType() {
        return "StatelessGroupNode";
    }

    public int getRetryCount() {
        return 0;
    }

    public void setRetryCount(Integer retryCount) {
    }

    public Set<String> getRetriedRelationships() {
        return Collections.emptySet();
    }

    public void setRetriedRelationships(Set<String> retriedRelationships) {
    }

    public boolean isRelationshipRetried(Relationship relationship) {
        return false;
    }

    public BackoffMechanism getBackoffMechanism() {
        return BackoffMechanism.PENALIZE_FLOWFILE;
    }

    public void setBackoffMechanism(BackoffMechanism backoffMechanism) {
    }

    public String getMaxBackoffPeriod() {
        return "0 sec";
    }

    public void setMaxBackoffPeriod(String maxBackoffPeriod) {
    }

    public String evaluateParameters(String value) {
        return value;
    }

    public static class Builder {
        private ProcessGroup rootGroup;
        private ControllerServiceProvider controllerServiceProvider;
        private ExtensionManager extensionManager;
        private RepositoryContextFactory statelessRepoContextFactory;
        private FlowFileRepository nifiFlowFileRepository;
        private ContentRepository nifiContentRepository;
        private ProvenanceEventRepository nifiProvenanceRepo;
        private StateManagerProvider stateManagerProvider;
        private BulletinRepository bulletinRepository;
        private StatelessGroupFactory statelessGroupFactory;
        private LifecycleStateManager lifecycleStateManager;
        private FlowFileEventRepository flowFileEventRepository;
        private long boredYieldMillis = 10L;

        public Builder rootGroup(ProcessGroup rootGroup) {
            this.rootGroup = rootGroup;
            return this;
        }

        public Builder controllerServiceProvider(ControllerServiceProvider controllerServiceProvider) {
            this.controllerServiceProvider = controllerServiceProvider;
            return this;
        }

        public Builder extensionManager(ExtensionManager extensionManager) {
            this.extensionManager = extensionManager;
            return this;
        }

        public Builder statelessRepositoryContextFactory(RepositoryContextFactory statelessRepoContextFactory) {
            this.statelessRepoContextFactory = statelessRepoContextFactory;
            return this;
        }

        public Builder nifiFlowFileRepository(FlowFileRepository nifiFlowFileRepository) {
            this.nifiFlowFileRepository = nifiFlowFileRepository;
            return this;
        }

        public Builder nifiContentRepository(ContentRepository nifiContentRepository) {
            this.nifiContentRepository = nifiContentRepository;
            return this;
        }

        public Builder nifiProvenanceRepository(ProvenanceEventRepository nifiProvenanceRepo) {
            this.nifiProvenanceRepo = nifiProvenanceRepo;
            return this;
        }

        public Builder stateManagerProvider(StateManagerProvider stateManagerProvider) {
            this.stateManagerProvider = stateManagerProvider;
            return this;
        }

        public Builder bulletinRepository(BulletinRepository bulletinRepository) {
            this.bulletinRepository = bulletinRepository;
            return this;
        }

        public Builder statelessGroupFactory(StatelessGroupFactory statelessGroupFactory) {
            this.statelessGroupFactory = statelessGroupFactory;
            return this;
        }

        public Builder lifecycleStateManager(LifecycleStateManager lifecycleStateManager) {
            this.lifecycleStateManager = lifecycleStateManager;
            return this;
        }

        public Builder flowFileEventRepository(FlowFileEventRepository flowFileEventRepository) {
            this.flowFileEventRepository = flowFileEventRepository;
            return this;
        }

        public Builder boredYieldDuration(long period, TimeUnit timeUnit) {
            this.boredYieldMillis = TimeUnit.MILLISECONDS.convert(period, timeUnit);
            return this;
        }

        public StatelessGroupNode build() {
            if (this.rootGroup == null) {
                throw new IllegalStateException("Root ProcessGroup must be provided");
            }
            if (this.controllerServiceProvider == null) {
                throw new IllegalStateException("Controller Service Provider must be provided");
            }
            if (this.extensionManager == null) {
                throw new IllegalStateException("Extension Manager must be provided");
            }
            if (this.statelessRepoContextFactory == null) {
                throw new IllegalStateException("Stateless Repository Context Factory must be provided");
            }
            if (this.nifiFlowFileRepository == null) {
                throw new IllegalStateException("FlowFile Repository must be provided");
            }
            if (this.nifiContentRepository == null) {
                throw new IllegalStateException("Content Repository must be provided");
            }
            if (this.nifiProvenanceRepo == null) {
                throw new IllegalStateException("Provenance Repository must be provided");
            }
            if (this.stateManagerProvider == null) {
                throw new IllegalStateException("State Manager Provider must be provided");
            }
            if (this.bulletinRepository == null) {
                throw new IllegalStateException("Bulletin Repository must be provided");
            }
            if (this.statelessGroupFactory == null) {
                throw new IllegalStateException("Stateless Group Factory must be provided");
            }
            if (this.lifecycleStateManager == null) {
                throw new IllegalStateException("Lifecycle State Manager must be provided");
            }
            if (this.flowFileEventRepository == null) {
                throw new IllegalStateException("FlowFile Event Repository must be provided");
            }
            return new StandardStatelessGroupNode(this);
        }
    }
}

