/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.leader.election.StandaloneLeaderElectionManager;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.factory.FactoryBean;

public class LeaderElectionManagerFactoryBean
implements FactoryBean<LeaderElectionManager> {
    private ExtensionManager extensionManager;
    private NiFiProperties properties;

    public LeaderElectionManager getObject() throws Exception {
        boolean isNode = this.properties.isNode();
        if (isNode) {
            return this.loadClusterLeaderElectionManager();
        }
        return new StandaloneLeaderElectionManager();
    }

    public Class<?> getObjectType() {
        return LeaderElectionManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    private LeaderElectionManager loadClusterLeaderElectionManager() throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String leaderElectionImplementation = this.properties.getProperty("nifi.cluster.leader.election.implementation", "CuratorLeaderElectionManager");
        Set extensions = this.extensionManager.getExtensions(LeaderElectionManager.class);
        Optional<ExtensionDefinition> extensionFound = extensions.stream().filter(extensionDefinition -> {
            String extensionClassName = extensionDefinition.getImplementationClassName();
            return extensionClassName.equals(leaderElectionImplementation) || extensionClassName.endsWith(leaderElectionImplementation);
        }).findFirst();
        ExtensionDefinition extension = extensionFound.orElseThrow(() -> {
            String message = String.format("No Extensions Found for %s", LeaderElectionManager.class.getName());
            return new IllegalStateException(message);
        });
        String extensionImplementationClass = extension.getImplementationClassName();
        return (LeaderElectionManager)NarThreadContextClassLoader.createInstance((ExtensionManager)this.extensionManager, (String)extensionImplementationClass, LeaderElectionManager.class, (NiFiProperties)this.properties);
    }
}

