/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.validation.RuleViolation;
import org.apache.nifi.validation.RuleViolationKey;
import org.apache.nifi.validation.RuleViolationsManager;

public class StandardRuleViolationsManager
implements RuleViolationsManager {
    private final ConcurrentMap<String, ConcurrentMap<RuleViolationKey, RuleViolation>> subjectIdToRuleViolation = new ConcurrentHashMap<String, ConcurrentMap<RuleViolationKey, RuleViolation>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upsertComponentViolations(String componentId, Collection<RuleViolation> violations) {
        ConcurrentMap componentRuleViolations;
        ConcurrentMap concurrentMap = componentRuleViolations = this.subjectIdToRuleViolation.computeIfAbsent(componentId, __ -> new ConcurrentHashMap());
        synchronized (concurrentMap) {
            componentRuleViolations.values().stream().filter(violation -> violation.getScope().equals(componentId)).forEach(violation -> violation.setAvailable(false));
            violations.forEach(violation -> componentRuleViolations.compute(new RuleViolationKey((RuleViolation)violation), (ruleViolationKey, currentViolation) -> violation));
            componentRuleViolations.entrySet().removeIf(keyAndViolation -> {
                RuleViolation violation = (RuleViolation)keyAndViolation.getValue();
                return violation.getScope().equals(componentId) && !violation.isAvailable();
            });
        }
    }

    public synchronized void upsertGroupViolations(VersionedProcessGroup processGroup, Collection<RuleViolation> groupViolations, Map<VersionedComponent, Collection<RuleViolation>> componentToRuleViolations) {
        this.hideGroupViolations(processGroup);
        groupViolations.forEach(groupViolation -> this.subjectIdToRuleViolation.computeIfAbsent(groupViolation.getSubjectId(), __ -> new ConcurrentHashMap()).compute(new RuleViolationKey((RuleViolation)groupViolation), (ruleViolationKey, currentViolation) -> groupViolation));
        componentToRuleViolations.forEach((component, componentViolations) -> {
            ConcurrentMap componentRuleViolations = this.subjectIdToRuleViolation.computeIfAbsent(component.getIdentifier(), __ -> new ConcurrentHashMap());
            componentViolations.forEach(componentViolation -> componentRuleViolations.compute(new RuleViolationKey((RuleViolation)componentViolation), (ruleViolationKey, currentViolation) -> componentViolation));
        });
        this.purgeGroupViolations(processGroup);
    }

    private void hideGroupViolations(VersionedProcessGroup processGroup) {
        String groupId = processGroup.getIdentifier();
        this.subjectIdToRuleViolation.values().stream().map(Map::values).flatMap(Collection::stream).filter(violation -> violation.getScope().equals(groupId)).forEach(violation -> violation.setAvailable(false));
        processGroup.getProcessGroups().forEach(childProcessGroup -> this.hideGroupViolations((VersionedProcessGroup)childProcessGroup));
    }

    private void purgeGroupViolations(VersionedProcessGroup processGroup) {
        String groupId = processGroup.getIdentifier();
        this.subjectIdToRuleViolation.values().forEach(violationMap -> violationMap.entrySet().removeIf(keyAndViolation -> {
            RuleViolation violation = (RuleViolation)keyAndViolation.getValue();
            return violation.getScope().equals(groupId) && !violation.isAvailable();
        }));
        processGroup.getProcessGroups().forEach(childProcessGroup -> this.purgeGroupViolations((VersionedProcessGroup)childProcessGroup));
    }

    public Collection<RuleViolation> getRuleViolationsForSubject(String subjectId) {
        HashSet<RuleViolation> ruleViolationsForSubject = Optional.ofNullable((ConcurrentMap)this.subjectIdToRuleViolation.get(subjectId)).map(Map::values).map(HashSet::new).orElse(new HashSet());
        return ruleViolationsForSubject;
    }

    public Collection<RuleViolation> getRuleViolationsForGroup(String groupId) {
        Set<RuleViolation> groupViolations = this.subjectIdToRuleViolation.values().stream().map(Map::values).flatMap(Collection::stream).filter(violation -> groupId.equals(violation.getGroupId())).collect(Collectors.toSet());
        return groupViolations;
    }

    public Collection<RuleViolation> getAllRuleViolations() {
        Set<RuleViolation> allRuleViolations = this.subjectIdToRuleViolation.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toSet());
        return allRuleViolations;
    }

    public void removeRuleViolationsForSubject(String subjectId) {
        this.subjectIdToRuleViolation.remove(subjectId);
    }

    public void removeRuleViolationsForRule(String ruleId) {
        this.subjectIdToRuleViolation.values().stream().forEach(violationMap -> violationMap.entrySet().removeIf(keyAndViolation -> ((RuleViolation)keyAndViolation.getValue()).getRuleId().equals(ruleId)));
    }

    public void cleanUp() {
        this.subjectIdToRuleViolation.entrySet().removeIf(subjectIdAndViolationMap -> ((ConcurrentMap)subjectIdAndViolationMap.getValue()).isEmpty());
    }
}

