/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.components;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.AsyncLoadedProcessor;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.python.BoundObjectCounts;
import org.apache.nifi.python.PythonBridge;
import org.apache.nifi.python.PythonBridgeInitializationContext;
import org.apache.nifi.python.PythonProcessorDetails;

public class ClassLoaderAwarePythonBridge
implements PythonBridge {
    private final PythonBridge delegate;
    private final ClassLoader classLoader;

    public ClassLoaderAwarePythonBridge(PythonBridge delegate, ClassLoader classLoader) {
        this.delegate = delegate;
        this.classLoader = classLoader;
    }

    public void initialize(PythonBridgeInitializationContext context) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            this.delegate.initialize(context);
        }
    }

    public void start() throws IOException {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            this.delegate.start();
        }
    }

    public void shutdown() {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            this.delegate.shutdown();
        }
    }

    public void ping() throws IOException {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            this.delegate.ping();
        }
    }

    public List<PythonProcessorDetails> getProcessorTypes() {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            List list = this.delegate.getProcessorTypes();
            return list;
        }
    }

    public Map<String, Integer> getProcessCountsPerType() {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            Map map = this.delegate.getProcessCountsPerType();
            return map;
        }
    }

    public List<BoundObjectCounts> getBoundObjectCounts() {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            List list = this.delegate.getBoundObjectCounts();
            return list;
        }
    }

    public void discoverExtensions(boolean includeNarDirectories) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            this.delegate.discoverExtensions(includeNarDirectories);
        }
    }

    public AsyncLoadedProcessor createProcessor(String identifier, String type, String version, boolean preferIsolatedProcess, boolean initialize) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            AsyncLoadedProcessor asyncLoadedProcessor = this.delegate.createProcessor(identifier, type, version, preferIsolatedProcess, initialize);
            return asyncLoadedProcessor;
        }
    }

    public void onProcessorRemoved(String identifier, String type, String version) {
        try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            this.delegate.onProcessorRemoved(identifier, type, version);
        }
    }
}

