/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.validation.ValidationTrigger;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.LoggableComponent;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.reporting.AbstractReportingTaskNode;
import org.apache.nifi.controller.reporting.StandardReportingContext;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.ReportingTask;

public class StandardReportingTaskNode
extends AbstractReportingTaskNode
implements ReportingTaskNode {
    private final FlowController flowController;

    public StandardReportingTaskNode(LoggableComponent<ReportingTask> reportingTask, String id, FlowController controller, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger) {
        super(reportingTask, id, controller.getControllerServiceProvider(), processScheduler, validationContextFactory, reloadComponent, extensionManager, validationTrigger);
        this.flowController = controller;
    }

    public StandardReportingTaskNode(LoggableComponent<ReportingTask> reportingTask, String id, FlowController controller, ProcessScheduler processScheduler, ValidationContextFactory validationContextFactory, String componentType, String canonicalClassName, ReloadComponent reloadComponent, ExtensionManager extensionManager, ValidationTrigger validationTrigger, boolean isExtensionMissing) {
        super(reportingTask, id, controller.getControllerServiceProvider(), processScheduler, validationContextFactory, componentType, canonicalClassName, reloadComponent, extensionManager, validationTrigger, isExtensionMissing);
        this.flowController = controller;
    }

    public Authorizable getParentAuthorizable() {
        return this.flowController;
    }

    public Resource getResource() {
        return ResourceFactory.getComponentResource((ResourceType)ResourceType.ReportingTask, (String)this.getIdentifier(), (String)this.getName());
    }

    public boolean isRestricted() {
        return this.getReportingTask().getClass().isAnnotationPresent(Restricted.class);
    }

    public Class<?> getComponentClass() {
        return this.getReportingTask().getClass();
    }

    public boolean isDeprecated() {
        return this.getReportingTask().getClass().isAnnotationPresent(DeprecationNotice.class);
    }

    public ReportingContext getReportingContext() {
        return new StandardReportingContext(this.flowController, this.flowController.getBulletinRepository(), this.getEffectivePropertyValues(), this, ParameterLookup.EMPTY);
    }

    protected List<ValidationResult> validateConfig() {
        return Collections.emptyList();
    }

    protected ParameterContext getParameterContext() {
        return null;
    }

    public void start() {
        this.verifyCanStart();
        this.flowController.startReportingTask(this);
    }

    public void stop() {
        this.verifyCanStop();
        this.flowController.stopReportingTask(this);
    }

    public void enable() {
        this.verifyCanEnable();
        this.flowController.enableReportingTask(this);
    }

    public void disable() {
        this.verifyCanDisable();
        this.flowController.disableReportingTask(this);
    }
}

