/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Objects;
import javax.crypto.CipherOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.controller.repository.FileSystemRepository;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.repository.encryption.AesCtrStreamRepositoryEncryptor;
import org.apache.nifi.repository.encryption.RepositoryEncryptor;
import org.apache.nifi.repository.encryption.configuration.EncryptedRepositoryType;
import org.apache.nifi.repository.encryption.configuration.EncryptionMetadataHeader;
import org.apache.nifi.repository.encryption.configuration.kms.StandardRepositoryKeyProviderFactory;
import org.apache.nifi.security.kms.KeyProvider;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.apache.nifi.stream.io.NonCloseableOutputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedFileSystemRepository
extends FileSystemRepository {
    private static final Logger logger = LoggerFactory.getLogger(EncryptedFileSystemRepository.class);
    private final RepositoryEncryptor<OutputStream, InputStream> repositoryEncryptor;
    private final String keyId;

    public EncryptedFileSystemRepository(NiFiProperties niFiProperties) throws IOException {
        super(niFiProperties);
        StandardRepositoryKeyProviderFactory repositoryKeyProviderFactory = new StandardRepositoryKeyProviderFactory();
        KeyProvider keyProvider = repositoryKeyProviderFactory.getKeyProvider(EncryptedRepositoryType.CONTENT, niFiProperties);
        this.repositoryEncryptor = new AesCtrStreamRepositoryEncryptor(keyProvider, EncryptionMetadataHeader.CONTENT);
        this.keyId = Objects.requireNonNull(niFiProperties.getRepositoryEncryptionKeyId(), "Key Identifier required");
    }

    @Override
    public long importFrom(InputStream content, ContentClaim claim) throws IOException {
        try (OutputStream out = this.write(claim);){
            long l = StreamUtils.copy((InputStream)content, (OutputStream)out);
            return l;
        }
    }

    @Override
    public long exportTo(ContentClaim claim, OutputStream destination) throws IOException {
        logger.warn("Exporting content from {} to output stream {}. This content will be decrypted", (Object)claim.getResourceClaim().getId(), (Object)destination);
        return super.exportTo(claim, destination);
    }

    @Override
    public long exportTo(ContentClaim claim, OutputStream destination, long offset, long length) throws IOException {
        logger.warn("Exporting content from {} (offset: {}, length: {}) to output stream {}. This content will be decrypted", new Object[]{claim.getResourceClaim().getId(), offset, length, destination});
        return super.exportTo(claim, destination, offset, length);
    }

    @Override
    public long exportTo(ContentClaim claim, Path destination, boolean append) throws IOException {
        logger.warn("Exporting content from {} to path {}. This content will be decrypted", (Object)claim.getResourceClaim().getId(), (Object)destination);
        return super.exportTo(claim, destination, append);
    }

    @Override
    public long exportTo(ContentClaim claim, Path destination, boolean append, long offset, long length) throws IOException {
        logger.warn("Exporting content from {} (offset: {}, length: {}) to path {}. This content will be decrypted", new Object[]{claim.getResourceClaim().getId(), offset, length, destination});
        return super.exportTo(claim, destination, append, offset, length);
    }

    @Override
    public InputStream read(ResourceClaim claim) {
        throw new UnsupportedOperationException("Cannot read full ResourceClaim as a Stream when using EncryptedFileSystemRepository");
    }

    public boolean isResourceClaimStreamSupported() {
        return false;
    }

    @Override
    public InputStream read(ContentClaim claim) throws IOException {
        InputStream inputStream = super.read(claim);
        if (claim == null) {
            return inputStream;
        }
        String recordId = EncryptedFileSystemRepository.getRecordId(claim);
        return (InputStream)this.repositoryEncryptor.decrypt((Object)inputStream, recordId);
    }

    @Override
    public OutputStream write(ContentClaim claim) throws IOException {
        StandardContentClaim scc = EncryptedFileSystemRepository.validateContentClaimForWriting(claim);
        ByteCountingOutputStream claimStream = this.getWritableClaimStreamByResourceClaim(scc.getResourceClaim());
        long startingOffset = claimStream.getBytesWritten();
        String recordId = EncryptedFileSystemRepository.getRecordId(claim);
        return new EncryptedContentRepositoryOutputStream(scc, claimStream, recordId, startingOffset);
    }

    public static String getRecordId(ContentClaim claim) {
        if (claim != null && claim.getResourceClaim() != null && !StringUtils.isBlank((CharSequence)claim.getResourceClaim().getId())) {
            return "nifi-ecr-rc-" + claim.getResourceClaim().getId() + "+" + claim.getOffset();
        }
        String tempId = "nifi-ecr-ts-" + System.nanoTime();
        logger.error("Cannot determine record ID from null content claim or claim with missing/empty resource claim ID; using timestamp-generated ID [{}+0]", (Object)tempId);
        return tempId;
    }

    private class EncryptedContentRepositoryOutputStream
    extends FileSystemRepository.ContentRepositoryOutputStream {
        private CipherOutputStream cipherOutputStream;
        private long startingOffset;

        EncryptedContentRepositoryOutputStream(StandardContentClaim scc, ByteCountingOutputStream byteCountingOutputStream, String recordId, long startingOffset) {
            super(scc, byteCountingOutputStream, 0);
            this.startingOffset = startingOffset;
            this.cipherOutputStream = (CipherOutputStream)EncryptedFileSystemRepository.this.repositoryEncryptor.encrypt((Object)new NonCloseableOutputStream((OutputStream)byteCountingOutputStream), recordId, EncryptedFileSystemRepository.this.keyId);
        }

        @Override
        public String toString() {
            return "EncryptedFileSystemRepository Stream [" + String.valueOf(this.scc) + "]";
        }

        @Override
        public synchronized void write(int b) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(b);
            this.writeBytes(bb.array(), 0, 4);
        }

        @Override
        public synchronized void write(byte[] b) throws IOException {
            this.writeBytes(b, 0, b.length);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.writeBytes(b, off, len);
        }

        private void writeBytes(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            try {
                this.cipherOutputStream.write(b, off, len);
                this.scc.setLength(this.bcos.getBytesWritten() - this.startingOffset);
            }
            catch (IOException ioe) {
                this.recycle = false;
                throw new IOException("Failed to write to " + String.valueOf((Object)this), ioe);
            }
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Stream is closed");
            }
            this.cipherOutputStream.flush();
        }

        @Override
        public synchronized void close() throws IOException {
            this.closed = true;
            this.doFinal();
            super.close();
        }

        private void doFinal() throws IOException {
            this.cipherOutputStream.flush();
            this.cipherOutputStream.close();
            this.scc.setLength(this.bcos.getBytesWritten() - this.startingOffset);
        }

        @Override
        public synchronized ContentClaim newContentClaim() throws IOException {
            this.doFinal();
            this.startingOffset = this.bcos.getBytesWritten();
            this.scc = new StandardContentClaim(this.scc.getResourceClaim(), this.startingOffset);
            String newRecordId = EncryptedFileSystemRepository.getRecordId((ContentClaim)this.scc);
            this.cipherOutputStream = (CipherOutputStream)EncryptedFileSystemRepository.this.repositoryEncryptor.encrypt((Object)new NonCloseableOutputStream((OutputStream)this.bcos), newRecordId, EncryptedFileSystemRepository.this.keyId);
            EncryptedFileSystemRepository.this.incrementClaimaintCount((ContentClaim)this.scc);
            return this.scc;
        }
    }
}

