/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.AbstractComponentNode;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.serialization.ComponentSetFilter;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.flow.ComponentType;
import org.apache.nifi.flow.ConnectableComponent;
import org.apache.nifi.flow.ConnectableComponentType;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedConnection;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.StatelessGroupScheduledState;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.diff.DifferenceType;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.remote.RemoteGroupPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AffectedComponentSet {
    private static final Logger logger = LoggerFactory.getLogger(AffectedComponentSet.class);
    private static final Set<ControllerServiceState> ACTIVE_CONTROLLER_SERVICE_STATES = new HashSet<ControllerServiceState>(Arrays.asList(ControllerServiceState.ENABLED, ControllerServiceState.ENABLING, ControllerServiceState.DISABLING));
    private final FlowController flowController;
    private final FlowManager flowManager;
    private final Set<Port> inputPorts = new HashSet<Port>();
    private final Set<Port> outputPorts = new HashSet<Port>();
    private final Set<RemoteGroupPort> remoteInputPorts = new HashSet<RemoteGroupPort>();
    private final Set<RemoteGroupPort> remoteOutputPorts = new HashSet<RemoteGroupPort>();
    private final Set<ProcessorNode> processors = new HashSet<ProcessorNode>();
    private final Set<ControllerServiceNode> controllerServices = new HashSet<ControllerServiceNode>();
    private final Set<ReportingTaskNode> reportingTasks = new HashSet<ReportingTaskNode>();
    private final Set<FlowAnalysisRuleNode> flowAnalysisRules = new HashSet<FlowAnalysisRuleNode>();
    private final Set<ParameterProviderNode> parameterProviders = new HashSet<ParameterProviderNode>();
    private final Set<FlowRegistryClientNode> flowRegistryClients = new HashSet<FlowRegistryClientNode>();
    private final Set<ProcessGroup> statelessProcessGroups = new HashSet<ProcessGroup>();

    public AffectedComponentSet(FlowController flowController) {
        this.flowController = flowController;
        this.flowManager = flowController.getFlowManager();
    }

    public void addInputPort(Port port) {
        if (port == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(port.getProcessGroup());
        if (statelessGroup == null) {
            this.inputPorts.add(port);
        } else {
            this.statelessProcessGroups.add(statelessGroup);
        }
    }

    public void addOutputPort(Port port) {
        if (port == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(port.getProcessGroup());
        if (statelessGroup == null) {
            this.outputPorts.add(port);
        } else {
            this.statelessProcessGroups.add(statelessGroup);
        }
    }

    public void addRemoteInputPort(RemoteGroupPort port) {
        if (port == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(port.getProcessGroup());
        if (statelessGroup == null) {
            this.remoteInputPorts.add(port);
        } else {
            this.statelessProcessGroups.add(statelessGroup);
        }
    }

    public void addRemoteOutputPort(RemoteGroupPort port) {
        if (port == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(port.getProcessGroup());
        if (statelessGroup == null) {
            this.remoteOutputPorts.add(port);
        } else {
            this.statelessProcessGroups.add(statelessGroup);
        }
    }

    public void addRemoteProcessGroup(RemoteProcessGroup remoteProcessGroup) {
        if (remoteProcessGroup == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(remoteProcessGroup.getProcessGroup());
        if (statelessGroup == null) {
            remoteProcessGroup.getInputPorts().forEach(this::addRemoteInputPort);
            remoteProcessGroup.getOutputPorts().forEach(this::addRemoteOutputPort);
        } else {
            this.statelessProcessGroups.add(statelessGroup);
        }
    }

    public void addProcessor(ProcessorNode processor) {
        if (processor == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(processor.getProcessGroup());
        if (statelessGroup == null) {
            this.processors.add(processor);
        } else {
            this.statelessProcessGroups.add(statelessGroup);
        }
    }

    public void addStatelessGroup(ProcessGroup group) {
        if (group == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(group);
        if (statelessGroup == null) {
            return;
        }
        this.statelessProcessGroups.add(statelessGroup);
    }

    public void addControllerService(ControllerServiceNode controllerService) {
        if (controllerService == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(controllerService.getProcessGroup());
        if (statelessGroup != null) {
            this.statelessProcessGroups.add(statelessGroup);
            return;
        }
        this.controllerServices.add(controllerService);
        List referencingComponents = controllerService.getReferences().findRecursiveReferences(ComponentNode.class);
        for (ComponentNode reference : referencingComponents) {
            if (reference instanceof ControllerServiceNode) {
                this.addControllerService((ControllerServiceNode)reference);
                continue;
            }
            if (reference instanceof ProcessorNode) {
                this.addProcessor((ProcessorNode)reference);
                continue;
            }
            if (reference instanceof ReportingTaskNode) {
                this.addReportingTask((ReportingTaskNode)reference);
                continue;
            }
            if (reference instanceof FlowAnalysisRuleNode) {
                this.addFlowAnalysisRule((FlowAnalysisRuleNode)reference);
                continue;
            }
            if (reference instanceof ParameterProviderNode) {
                this.addParameterProvider((ParameterProviderNode)reference);
                continue;
            }
            if (!(reference instanceof FlowRegistryClientNode)) continue;
            this.addFlowRegistryClient((FlowRegistryClientNode)reference);
        }
    }

    public boolean isControllerServiceAffected(String serviceId) {
        for (ControllerServiceNode serviceNode : this.controllerServices) {
            if (!serviceNode.getIdentifier().equals(serviceId)) continue;
            return true;
        }
        return false;
    }

    private void addControllerServiceWithoutReferences(ControllerServiceNode controllerService) {
        if (controllerService == null) {
            return;
        }
        this.controllerServices.add(controllerService);
    }

    public void addReportingTask(ReportingTaskNode task) {
        if (task == null) {
            return;
        }
        this.reportingTasks.add(task);
    }

    public boolean isReportingTaskAffected(String reportingTaskId) {
        for (ReportingTaskNode taskNode : this.reportingTasks) {
            if (!taskNode.getIdentifier().equals(reportingTaskId)) continue;
            return true;
        }
        return false;
    }

    public void addFlowAnalysisRule(FlowAnalysisRuleNode rule) {
        if (rule == null) {
            return;
        }
        this.flowAnalysisRules.add(rule);
    }

    public boolean isFlowAnalysisRuleAffected(String flowAnalysisRuleId) {
        for (FlowAnalysisRuleNode ruleNode : this.flowAnalysisRules) {
            if (!ruleNode.getIdentifier().equals(flowAnalysisRuleId)) continue;
            return true;
        }
        return false;
    }

    public void addParameterProvider(ParameterProviderNode parameterProvider) {
        if (parameterProvider == null) {
            return;
        }
        this.parameterProviders.add(parameterProvider);
    }

    public boolean isParameterProviderAffected(String parameterProviderId) {
        for (ParameterProviderNode parameterProviderNode : this.parameterProviders) {
            if (!parameterProviderNode.getIdentifier().equals(parameterProviderId)) continue;
            return true;
        }
        return false;
    }

    public void addFlowRegistryClient(FlowRegistryClientNode flowRegistryClient) {
        if (flowRegistryClient == null) {
            return;
        }
        this.flowRegistryClients.add(flowRegistryClient);
    }

    public boolean isFlowRegistryClientAffected(String flowRegistryClientId) {
        for (FlowRegistryClientNode flowRegistryClientNode : this.flowRegistryClients) {
            if (!flowRegistryClientNode.getIdentifier().equals(flowRegistryClientId)) continue;
            return true;
        }
        return false;
    }

    public void addConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        this.addConnectable(connection.getSource());
        this.addConnectable(connection.getDestination());
    }

    public void addConnectable(Connectable connectable) {
        if (connectable == null) {
            return;
        }
        switch (connectable.getConnectableType()) {
            case INPUT_PORT: {
                this.addInputPort((Port)connectable);
                break;
            }
            case OUTPUT_PORT: {
                this.addOutputPort((Port)connectable);
                break;
            }
            case PROCESSOR: {
                this.addProcessor((ProcessorNode)connectable);
                break;
            }
            case REMOTE_INPUT_PORT: {
                this.addRemoteInputPort((RemoteGroupPort)connectable);
                break;
            }
            case REMOTE_OUTPUT_PORT: {
                this.addRemoteOutputPort((RemoteGroupPort)connectable);
            }
        }
    }

    public void addAffectedComponents(FlowDifference difference) {
        DifferenceType differenceType = difference.getDifferenceType();
        if (differenceType == DifferenceType.COMPONENT_ADDED) {
            if (difference.getComponentB().getComponentType() == ComponentType.CONNECTION) {
                this.addComponentsForNewConnection((VersionedConnection)difference.getComponentB());
            }
            return;
        }
        if (differenceType == DifferenceType.PARAMETER_VALUE_CHANGED || differenceType == DifferenceType.PARAMETER_DESCRIPTION_CHANGED || differenceType == DifferenceType.PARAMETER_REMOVED) {
            this.addComponentsForParameterUpdate(difference);
            return;
        }
        if (differenceType == DifferenceType.PARAMETER_CONTEXT_CHANGED) {
            this.addComponentsForParameterContextChange(difference);
            return;
        }
        if (differenceType == DifferenceType.INHERITED_CONTEXTS_CHANGED) {
            this.addComponentsForInheritedParameterContextChange(difference);
        }
        if (differenceType == DifferenceType.RPG_URL_CHANGED) {
            String instanceId = difference.getComponentA().getInstanceIdentifier();
            RemoteProcessGroup rpg = this.flowManager.getRootGroup().findRemoteProcessGroup(instanceId);
            if (rpg != null) {
                this.addRemoteProcessGroup(rpg);
            }
        }
        if (differenceType == DifferenceType.COMPONENT_REMOVED && difference.getComponentA().getComponentType() == ComponentType.PROCESS_GROUP) {
            this.addAllComponentsWithinGroup(difference.getComponentA().getInstanceIdentifier());
        }
        this.addAffectedComponents(difference.getComponentA());
    }

    private void addAllComponentsWithinGroup(String groupId) {
        ProcessGroup processGroup = this.flowManager.getGroup(groupId);
        if (processGroup == null) {
            return;
        }
        processGroup.getProcessors().forEach(this::addProcessor);
        processGroup.getControllerServices(false).forEach(this::addControllerServiceWithoutReferences);
        processGroup.getInputPorts().forEach(this::addInputPort);
        processGroup.getOutputPorts().forEach(this::addOutputPort);
        processGroup.getRemoteProcessGroups().forEach(this::addRemoteProcessGroup);
        processGroup.getProcessGroups().forEach(child -> this.addAllComponentsWithinGroup(child.getIdentifier()));
    }

    private void addComponentsForInheritedParameterContextChange(FlowDifference difference) {
        String parameterContextId = difference.getComponentA().getInstanceIdentifier();
        ParameterContext context = this.flowManager.getParameterContextManager().getParameterContext(parameterContextId);
        if (context == null) {
            return;
        }
        Set boundGroups = context.getParameterReferenceManager().getProcessGroupsBound(context);
        for (ProcessGroup group : boundGroups) {
            ProcessGroup statelessGroup = this.getStatelessGroup(group);
            if (statelessGroup != null) {
                this.statelessProcessGroups.add(statelessGroup);
                continue;
            }
            group.getProcessors().stream().filter(AbstractComponentNode::isReferencingParameter).forEach(this::addProcessor);
            group.getControllerServices(false).stream().filter(ComponentNode::isReferencingParameter).forEach(this::addControllerService);
        }
    }

    private void addComponentsForParameterContextChange(FlowDifference difference) {
        String groupId = difference.getComponentA().getInstanceIdentifier();
        ProcessGroup group = this.flowManager.getGroup(groupId);
        if (group == null) {
            return;
        }
        ProcessGroup statelessGroup = this.getStatelessGroup(group);
        if (statelessGroup != null) {
            this.statelessProcessGroups.add(statelessGroup);
            return;
        }
        group.getProcessors().stream().filter(AbstractComponentNode::isReferencingParameter).forEach(this::addProcessor);
        group.getControllerServices(false).stream().filter(ComponentNode::isReferencingParameter).forEach(this::addControllerService);
    }

    private ProcessGroup getStatelessGroup(ProcessGroup start) {
        if (start == null) {
            return null;
        }
        ExecutionEngine executionEngine = start.getExecutionEngine();
        switch (executionEngine) {
            case STATELESS: {
                return start;
            }
            case INHERITED: {
                return this.getStatelessGroup(start.getParent());
            }
        }
        return null;
    }

    private void addComponentsForParameterUpdate(FlowDifference difference) {
        DifferenceType differenceType = difference.getDifferenceType();
        Optional optionalParameterName = difference.getFieldName();
        if (!optionalParameterName.isPresent()) {
            logger.warn("Encountered a Flow Difference {} with Difference Type of {} but no indication as to which parameter was updated.", (Object)difference, (Object)differenceType);
            return;
        }
        String parameterName = (String)optionalParameterName.get();
        String contextId = difference.getComponentA().getInstanceIdentifier();
        ParameterContext parameterContext = this.flowManager.getParameterContextManager().getParameterContext(contextId);
        if (parameterContext == null) {
            logger.warn("Encountered a Flow Difference {} with a Difference Type of {} but found no Parameter Context with Instance ID {}", new Object[]{difference, differenceType, contextId});
            return;
        }
        Set referencingServices = parameterContext.getParameterReferenceManager().getControllerServicesReferencing(parameterContext, parameterName);
        Set referencingProcessors = parameterContext.getParameterReferenceManager().getProcessorsReferencing(parameterContext, parameterName);
        referencingServices.forEach(this::addControllerService);
        referencingProcessors.forEach(this::addProcessor);
    }

    private void addComponentsForNewConnection(VersionedConnection connection) {
        ConnectableComponent destinationComponent;
        Connectable destinationConnectable;
        ConnectableComponent sourceComponent = connection.getSource();
        Connectable sourceConnectable = this.getConnectable(sourceComponent.getType(), sourceComponent.getInstanceIdentifier());
        if (sourceConnectable != null) {
            this.addConnectable(sourceConnectable);
        }
        if ((destinationConnectable = this.getConnectable((destinationComponent = connection.getDestination()).getType(), destinationComponent.getInstanceIdentifier())) != null) {
            this.addConnectable(destinationConnectable);
        }
    }

    private Connectable getConnectable(ConnectableComponentType type, String identifier) {
        switch (type) {
            case FUNNEL: {
                return this.flowManager.getFunnel(identifier);
            }
            case INPUT_PORT: {
                return this.flowManager.getInputPort(identifier);
            }
            case OUTPUT_PORT: {
                return this.flowManager.getOutputPort(identifier);
            }
            case PROCESSOR: {
                return this.flowManager.getProcessorNode(identifier);
            }
            case REMOTE_INPUT_PORT: 
            case REMOTE_OUTPUT_PORT: {
                return this.flowManager.getRootGroup().findRemoteGroupPort(identifier);
            }
        }
        return null;
    }

    private void addAffectedComponents(VersionedComponent versionedComponent) {
        String componentId = versionedComponent.getInstanceIdentifier();
        switch (versionedComponent.getComponentType()) {
            case CONNECTION: {
                this.addConnection(this.flowManager.getConnection(componentId));
                break;
            }
            case CONTROLLER_SERVICE: {
                this.addControllerService(this.flowManager.getControllerServiceNode(componentId));
                break;
            }
            case INPUT_PORT: {
                this.addInputPort(this.flowManager.getInputPort(componentId));
                break;
            }
            case OUTPUT_PORT: {
                this.addOutputPort(this.flowManager.getOutputPort(componentId));
                break;
            }
            case PROCESS_GROUP: {
                ProcessGroup group = this.flowManager.getGroup(componentId);
                ProcessGroup statelessGroup = this.getStatelessGroup(group);
                this.addStatelessGroup(statelessGroup);
                break;
            }
            case PROCESSOR: {
                this.addProcessor(this.flowManager.getProcessorNode(componentId));
                break;
            }
            case REMOTE_INPUT_PORT: {
                RemoteGroupPort remoteInputPort = this.flowManager.getRootGroup().findRemoteGroupPort(componentId);
                if (remoteInputPort == null) break;
                this.addRemoteInputPort(remoteInputPort);
                break;
            }
            case REMOTE_OUTPUT_PORT: {
                RemoteGroupPort remoteOutputPort = this.flowManager.getRootGroup().findRemoteGroupPort(componentId);
                if (remoteOutputPort == null) break;
                this.addRemoteOutputPort(remoteOutputPort);
                break;
            }
            case FLOW_REGISTRY_CLIENT: {
                this.addFlowRegistryClient(this.flowManager.getFlowRegistryClient(componentId));
            }
            case REMOTE_PROCESS_GROUP: {
                this.addRemoteProcessGroup(this.flowManager.getRootGroup().findRemoteProcessGroup(componentId));
                break;
            }
            case REPORTING_TASK: {
                this.addReportingTask(this.flowManager.getReportingTaskNode(componentId));
                break;
            }
            case FLOW_ANALYSIS_RULE: {
                this.addFlowAnalysisRule(this.flowManager.getFlowAnalysisRuleNode(componentId));
            }
        }
    }

    public AffectedComponentSet toActiveSet() {
        AffectedComponentSet active = new AffectedComponentSet(this.flowController);
        this.inputPorts.stream().filter(port -> port.getScheduledState() == ScheduledState.RUNNING).forEach(active::addInputPort);
        this.outputPorts.stream().filter(port -> port.getScheduledState() == ScheduledState.RUNNING).forEach(active::addOutputPort);
        this.remoteInputPorts.stream().filter(port -> port.getScheduledState() == ScheduledState.RUNNING).forEach(active::addRemoteInputPort);
        this.remoteOutputPorts.stream().filter(port -> port.getScheduledState() == ScheduledState.RUNNING).forEach(active::addRemoteOutputPort);
        this.processors.stream().filter(this::isActive).forEach(active::addProcessor);
        this.reportingTasks.stream().filter(task -> task.getScheduledState() == ScheduledState.STARTING || task.getScheduledState() == ScheduledState.RUNNING || task.isRunning()).forEach(active::addReportingTask);
        this.flowAnalysisRules.stream().filter(rule -> rule.getState() == FlowAnalysisRuleState.ENABLED).forEach(active::addFlowAnalysisRule);
        this.controllerServices.stream().filter(service -> ACTIVE_CONTROLLER_SERVICE_STATES.contains(service.getState())).forEach(active::addControllerServiceWithoutReferences);
        this.statelessProcessGroups.stream().filter(group -> group.getStatelessScheduledState() == StatelessGroupScheduledState.RUNNING).forEach(active::addStatelessGroup);
        return active;
    }

    private boolean isActive(ProcessorNode processor) {
        ScheduledState scheduledState = processor.getPhysicalScheduledState();
        return scheduledState == ScheduledState.STARTING || scheduledState == ScheduledState.RUNNING || processor.isRunning() || this.flowController.isStartAfterInitialization((Connectable)processor);
    }

    private boolean isStopped(ProcessorNode processor) {
        ScheduledState state = processor.getPhysicalScheduledState();
        boolean stateCorrect = state == ScheduledState.STOPPED || state == ScheduledState.DISABLED;
        return stateCorrect && !processor.isRunning();
    }

    public void start() {
        logger.info("Starting the following components: {}", (Object)this);
        this.flowController.getControllerServiceProvider().enableControllerServices(this.controllerServices);
        this.inputPorts.forEach(port -> port.getProcessGroup().startInputPort(port));
        this.outputPorts.forEach(port -> port.getProcessGroup().startOutputPort(port));
        this.remoteInputPorts.forEach(port -> port.getRemoteProcessGroup().startTransmitting(port));
        this.remoteOutputPorts.forEach(port -> port.getRemoteProcessGroup().startTransmitting(port));
        this.processors.forEach(processor -> processor.getProcessGroup().startProcessor(processor, false));
        this.reportingTasks.forEach(this.flowController::startReportingTask);
        this.flowAnalysisRules.forEach(this.flowController::enableFlowAnalysisRule);
        this.statelessProcessGroups.forEach(group -> group.startProcessing());
    }

    public void removeComponents(ComponentSetFilter filter) {
        this.inputPorts.removeIf(filter::testInputPort);
        this.outputPorts.removeIf(filter::testOutputPort);
        this.remoteInputPorts.removeIf(filter::testRemoteInputPort);
        this.remoteOutputPorts.removeIf(filter::testRemoteOutputPort);
        this.processors.removeIf(filter::testProcessor);
        this.controllerServices.removeIf(filter::testControllerService);
        this.reportingTasks.removeIf(filter::testReportingTask);
        this.flowAnalysisRules.removeIf(filter::testFlowAnalysisRule);
        this.flowRegistryClients.removeIf(filter::testFlowRegistryClient);
        this.statelessProcessGroups.removeIf(filter::testStatelessGroup);
    }

    public AffectedComponentSet toExistingSet() {
        ControllerServiceProvider serviceProvider = this.flowController.getControllerServiceProvider();
        AffectedComponentSet existing = new AffectedComponentSet(this.flowController);
        this.inputPorts.stream().filter(port -> port.getProcessGroup().getInputPort(port.getIdentifier()) != null).forEach(existing::addInputPort);
        this.outputPorts.stream().filter(port -> port.getProcessGroup().getOutputPort(port.getIdentifier()) != null).forEach(existing::addOutputPort);
        this.remoteInputPorts.stream().filter(port -> port.getProcessGroup().findRemoteGroupPort(port.getIdentifier()) != null).forEach(existing::addRemoteInputPort);
        this.remoteOutputPorts.stream().filter(port -> port.getProcessGroup().findRemoteGroupPort(port.getIdentifier()) != null).forEach(existing::addRemoteOutputPort);
        this.processors.stream().filter(processor -> processor.getProcessGroup().getProcessor(processor.getIdentifier()) != null).forEach(existing::addProcessor);
        this.reportingTasks.stream().filter(task -> this.flowController.getReportingTaskNode(task.getIdentifier()) != null).forEach(existing::addReportingTask);
        this.flowAnalysisRules.stream().filter(rule -> this.flowController.getFlowAnalysisRuleNode(rule.getIdentifier()) != null).forEach(existing::addFlowAnalysisRule);
        this.controllerServices.stream().filter(service -> serviceProvider.getControllerServiceNode(service.getIdentifier()) != null).forEach(existing::addControllerServiceWithoutReferences);
        this.flowRegistryClients.stream().filter(client -> this.flowManager.getFlowRegistryClient(client.getIdentifier()) != null).forEach(existing::addFlowRegistryClient);
        this.statelessProcessGroups.stream().filter(group -> this.flowManager.getGroup(group.getIdentifier()) != null).forEach(existing::addStatelessGroup);
        return existing;
    }

    public AffectedComponentSet toStartableSet() {
        AffectedComponentSet startable = new AffectedComponentSet(this.flowController);
        this.inputPorts.stream().filter(this::isStartable).forEach(startable::addInputPort);
        this.outputPorts.stream().filter(this::isStartable).forEach(startable::addOutputPort);
        this.remoteInputPorts.stream().filter(this::isStartable).forEach(startable::addRemoteInputPort);
        this.remoteOutputPorts.stream().filter(this::isStartable).forEach(startable::addRemoteOutputPort);
        this.processors.stream().filter(this::isStartable).forEach(startable::addProcessor);
        this.reportingTasks.stream().filter(this::isStartable).forEach(startable::addReportingTask);
        this.flowAnalysisRules.stream().filter(this::isStartable).forEach(startable::addFlowAnalysisRule);
        this.controllerServices.stream().filter(this::isStartable).forEach(startable::addControllerServiceWithoutReferences);
        this.statelessProcessGroups.stream().filter(this::isStartable).forEach(startable::addStatelessGroup);
        return startable;
    }

    private boolean isStartable(ComponentNode componentNode) {
        if (componentNode == null) {
            return false;
        }
        if (componentNode instanceof ProcessorNode) {
            return ((ProcessorNode)componentNode).getScheduledState() != ScheduledState.DISABLED;
        }
        if (componentNode instanceof ReportingTaskNode) {
            return ((ReportingTaskNode)componentNode).getScheduledState() != ScheduledState.DISABLED;
        }
        return true;
    }

    private boolean isStartable(ProcessGroup group) {
        if (group == null) {
            return false;
        }
        if (group.getExecutionEngine() != ExecutionEngine.STATELESS) {
            return false;
        }
        return group.getStatelessScheduledState() == StatelessGroupScheduledState.STOPPED;
    }

    private boolean isStartable(Port port) {
        if (port == null) {
            return false;
        }
        return port.getScheduledState() != ScheduledState.DISABLED;
    }

    public void stop() {
        logger.info("Stopping the following components: {}", (Object)this);
        long start = System.currentTimeMillis();
        this.inputPorts.forEach(port -> port.getProcessGroup().stopInputPort(port));
        this.outputPorts.forEach(port -> port.getProcessGroup().stopOutputPort(port));
        this.remoteInputPorts.forEach(port -> port.getRemoteProcessGroup().stopTransmitting(port));
        this.remoteOutputPorts.forEach(port -> port.getRemoteProcessGroup().stopTransmitting(port));
        this.processors.forEach(processor -> processor.getProcessGroup().stopProcessor(processor));
        this.reportingTasks.forEach(this.flowController::stopReportingTask);
        this.flowAnalysisRules.forEach(this.flowController::disableFlowAnalysisRule);
        this.statelessProcessGroups.forEach(group -> group.stopProcessing());
        this.waitForConnectablesStopped();
        if (!this.controllerServices.isEmpty()) {
            CompletableFuture disableFuture = this.flowController.getControllerServiceProvider().disableControllerServicesAsync(this.controllerServices);
            this.waitForControllerServicesStopped(disableFuture);
        }
        long millis = System.currentTimeMillis() - start;
        logger.info("Successfully stopped all components in {} milliseconds", (Object)millis);
    }

    private void waitForControllerServicesStopped(Future<Void> future) {
        try {
            while (true) {
                logger.info("Waiting for all Controller Services to become disabled...");
                if (logger.isDebugEnabled()) {
                    Set activeServices = this.controllerServices.stream().filter(ControllerServiceNode::isActive).collect(Collectors.toSet());
                    logger.debug("There are currently {} active Controller Services: {}", (Object)activeServices.size(), activeServices);
                }
                try {
                    future.get(10L, TimeUnit.SECONDS);
                    return;
                }
                catch (TimeoutException activeServices) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new UninheritableFlowException("Could not disable all affected Controller Services", e);
        }
    }

    private void waitForConnectablesStopped() {
        long count = 0L;
        try {
            while (!this.componentsStopped()) {
                if (count++ % 1000L == 0L) {
                    logger.info("Waiting for all required Processors and Reporting Tasks to stop...");
                    if (this.reportingTasks.isEmpty() && this.processors.isEmpty() && this.statelessProcessGroups.isEmpty()) {
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        Set activeReportingTasks = this.reportingTasks.stream().filter(ReportingTaskNode::isRunning).collect(Collectors.toSet());
                        logger.debug("There are currently {} active Reporting Tasks: {}", (Object)activeReportingTasks.size(), activeReportingTasks);
                        Set activeProcessors = this.processors.stream().filter(processor -> !this.isStopped((ProcessorNode)processor)).collect(Collectors.toSet());
                        logger.debug("There are currently {} active Processors: {}", (Object)activeProcessors.size(), activeProcessors);
                        Set activeStatelessGroups = this.statelessProcessGroups.stream().filter(ProcessGroup::isStatelessActive).collect(Collectors.toSet());
                        logger.debug("There are currently {} active Stateless Groups: {}", (Object)activeStatelessGroups.size(), activeStatelessGroups);
                    }
                }
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            throw new UninheritableFlowException("Could not stop all affected components", e);
        }
    }

    private boolean componentsStopped() {
        if (this.processors.stream().anyMatch(processor -> !this.isStopped((ProcessorNode)processor))) {
            return false;
        }
        if (this.reportingTasks.stream().anyMatch(ReportingTaskNode::isRunning)) {
            return false;
        }
        return !this.statelessProcessGroups.stream().anyMatch(ProcessGroup::isStatelessActive);
    }

    public String toString() {
        return "AffectedComponentSet[inputPorts=" + String.valueOf(this.inputPorts) + ", outputPorts=" + String.valueOf(this.outputPorts) + ", remoteInputPorts=" + String.valueOf(this.remoteInputPorts) + ", remoteOutputPorts=" + String.valueOf(this.remoteOutputPorts) + ", processors=" + String.valueOf(this.processors) + ", parameterProviders=" + String.valueOf(this.parameterProviders) + ", flowRegistryClients=" + String.valueOf(this.flowRegistryClients) + ", controllerServices=" + String.valueOf(this.controllerServices) + ", reportingTasks=" + String.valueOf(this.reportingTasks) + ", flowAnalysisRules=" + String.valueOf(this.flowAnalysisRules) + ", statelessProcessGroups=" + String.valueOf(this.statelessProcessGroups) + "]";
    }
}

