/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.serialization.FlowSynchronizationUtils;
import org.apache.nifi.controller.serialization.VersionedReportingTaskImportResult;
import org.apache.nifi.controller.serialization.VersionedReportingTaskImporter;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.flow.VersionedConfigurableExtension;
import org.apache.nifi.flow.VersionedControllerService;
import org.apache.nifi.flow.VersionedReportingTask;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.scheduling.SchedulingStrategy;

public class StandardVersionedReportingTaskImporter
implements VersionedReportingTaskImporter {
    final FlowController flowController;

    public StandardVersionedReportingTaskImporter(FlowController flowController) {
        this.flowController = flowController;
    }

    @Override
    public VersionedReportingTaskImportResult importSnapshot(VersionedReportingTaskSnapshot reportingTaskSnapshot) {
        List<VersionedControllerService> controllerServices = Optional.ofNullable(reportingTaskSnapshot.getControllerServices()).orElse(Collections.emptyList());
        Set<ControllerServiceNode> controllerServiceNodes = this.importControllerServices(controllerServices);
        List<VersionedReportingTask> reportingTasks = Optional.ofNullable(reportingTaskSnapshot.getReportingTasks()).orElse(Collections.emptyList());
        Set<ReportingTaskNode> reportingTaskNodes = this.importReportingTasks(reportingTasks);
        return new VersionedReportingTaskImportResult(reportingTaskNodes, controllerServiceNodes);
    }

    private Set<ReportingTaskNode> importReportingTasks(List<VersionedReportingTask> reportingTasks) {
        HashSet<ReportingTaskNode> taskNodes = new HashSet<ReportingTaskNode>();
        for (VersionedReportingTask reportingTask : reportingTasks) {
            ReportingTaskNode taskNode = this.addReportingTask(reportingTask);
            taskNodes.add(taskNode);
        }
        return taskNodes;
    }

    private ReportingTaskNode addReportingTask(VersionedReportingTask reportingTask) {
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        BundleCoordinate coordinate = FlowSynchronizationUtils.createBundleCoordinate(extensionManager, reportingTask.getBundle(), reportingTask.getType());
        ReportingTaskNode taskNode = this.flowController.createReportingTask(reportingTask.getType(), reportingTask.getInstanceIdentifier(), coordinate, false);
        taskNode.setName(reportingTask.getName());
        taskNode.setComments(reportingTask.getComments());
        taskNode.setSchedulingPeriod(reportingTask.getSchedulingPeriod());
        taskNode.setSchedulingStrategy(SchedulingStrategy.valueOf((String)reportingTask.getSchedulingStrategy()));
        taskNode.setAnnotationData(reportingTask.getAnnotationData());
        Set<String> sensitiveDynamicPropertyNames = FlowSynchronizationUtils.getSensitiveDynamicPropertyNames((ComponentNode)taskNode, (VersionedConfigurableExtension)reportingTask);
        Map<String, String> decryptedProperties = FlowSynchronizationUtils.decryptProperties(reportingTask.getProperties(), this.flowController.getEncryptor());
        taskNode.setProperties(decryptedProperties, false, sensitiveDynamicPropertyNames);
        return taskNode;
    }

    private Set<ControllerServiceNode> importControllerServices(List<VersionedControllerService> controllerServices) {
        ControllerServiceNode serviceNode;
        HashSet<ControllerServiceNode> controllerServicesAdded = new HashSet<ControllerServiceNode>();
        for (VersionedControllerService versionedControllerService : controllerServices) {
            serviceNode = this.flowController.getFlowManager().getRootControllerService(versionedControllerService.getInstanceIdentifier());
            if (serviceNode != null) continue;
            ControllerServiceNode added = this.addRootControllerService(versionedControllerService);
            controllerServicesAdded.add(added);
        }
        for (VersionedControllerService versionedControllerService : controllerServices) {
            serviceNode = this.flowController.getFlowManager().getRootControllerService(versionedControllerService.getInstanceIdentifier());
            if (!controllerServicesAdded.contains(serviceNode)) continue;
            this.updateRootControllerService(serviceNode, versionedControllerService, this.flowController.getEncryptor());
        }
        return controllerServicesAdded;
    }

    private ControllerServiceNode addRootControllerService(VersionedControllerService controllerService) {
        FlowManager flowManager = this.flowController.getFlowManager();
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        BundleCoordinate bundleCoordinate = FlowSynchronizationUtils.createBundleCoordinate(extensionManager, controllerService.getBundle(), controllerService.getType());
        ControllerServiceNode serviceNode = flowManager.createControllerService(controllerService.getType(), controllerService.getInstanceIdentifier(), bundleCoordinate, Collections.emptySet(), true, true, null);
        serviceNode.setVersionedComponentId(controllerService.getIdentifier());
        flowManager.addRootControllerService(serviceNode);
        return serviceNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootControllerService(ControllerServiceNode serviceNode, VersionedControllerService controllerService, PropertyEncryptor encryptor) {
        serviceNode.pauseValidationTrigger();
        try {
            serviceNode.setName(controllerService.getName());
            serviceNode.setAnnotationData(controllerService.getAnnotationData());
            serviceNode.setComments(controllerService.getComments());
            if (controllerService.getBulletinLevel() != null) {
                serviceNode.setBulletinLevel(LogLevel.valueOf((String)controllerService.getBulletinLevel()));
            } else {
                serviceNode.setBulletinLevel(LogLevel.WARN);
            }
            Set<String> sensitiveDynamicPropertyNames = FlowSynchronizationUtils.getSensitiveDynamicPropertyNames((ComponentNode)serviceNode, (VersionedConfigurableExtension)controllerService);
            Map<String, String> decryptedProperties = FlowSynchronizationUtils.decryptProperties(controllerService.getProperties(), encryptor);
            serviceNode.setProperties(decryptedProperties, false, sensitiveDynamicPropertyNames);
        }
        finally {
            serviceNode.resumeValidationTrigger();
        }
    }
}

