/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.controller.status.history.ComponentDetails;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.MetricRollingBuffer;
import org.apache.nifi.controller.status.history.StandardStatusHistory;
import org.apache.nifi.controller.status.history.StatusHistory;
import org.apache.nifi.controller.status.history.StatusSnapshot;

public class ComponentStatusHistory {
    private final MetricRollingBuffer snapshots;
    private ComponentDetails componentDetails;

    public ComponentStatusHistory(ComponentDetails details, int maxCapacity) {
        this.componentDetails = details;
        this.snapshots = new MetricRollingBuffer(maxCapacity);
    }

    public void expireBefore(Date timestamp) {
        this.snapshots.expireBefore(timestamp);
    }

    public void update(StatusSnapshot snapshot, ComponentDetails details) {
        if (snapshot == null) {
            return;
        }
        this.snapshots.update(snapshot);
        this.componentDetails = details;
    }

    public StatusHistory toStatusHistory(List<Date> timestamps, boolean includeCounters, Set<MetricDescriptor<?>> defaultStatusMetrics) {
        Date dateGenerated = new Date();
        Map componentDetailsMap = this.componentDetails.toMap();
        List<StatusSnapshot> snapshotList = this.snapshots.getSnapshots(timestamps, includeCounters, defaultStatusMetrics);
        return new StandardStatusHistory(snapshotList, componentDetailsMap, dateGenerated);
    }
}

