/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.diagnostics.GarbageCollection;
import org.apache.nifi.diagnostics.StorageUsage;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemDiagnosticsFactory {
    private final Logger logger = LoggerFactory.getLogger(SystemDiagnosticsFactory.class);

    public SystemDiagnostics create(FlowFileRepository flowFileRepo, ContentRepository contentRepo, ProvenanceRepository provenanceRepository, ResourceClaimManager resourceClaimManager) {
        SystemDiagnostics systemDiagnostics = new SystemDiagnostics();
        MemoryMXBean memory = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = memory.getHeapMemoryUsage();
        MemoryUsage nonHeap = memory.getNonHeapMemoryUsage();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        systemDiagnostics.setDaemonThreads(threads.getDaemonThreadCount());
        systemDiagnostics.setTotalThreads(threads.getThreadCount());
        systemDiagnostics.setTotalHeap(heap.getCommitted());
        systemDiagnostics.setUsedHeap(heap.getUsed());
        systemDiagnostics.setMaxHeap(heap.getMax());
        systemDiagnostics.setTotalNonHeap(nonHeap.getCommitted());
        systemDiagnostics.setUsedNonHeap(nonHeap.getUsed());
        systemDiagnostics.setMaxNonHeap(nonHeap.getMax());
        systemDiagnostics.setUptime(runtime.getUptime());
        systemDiagnostics.setAvailableProcessors(os.getAvailableProcessors());
        double systemLoad = os.getSystemLoadAverage();
        if (systemLoad >= 0.0) {
            systemDiagnostics.setProcessorLoadAverage(Double.valueOf(systemLoad));
        } else {
            systemDiagnostics.setProcessorLoadAverage(Double.valueOf(-1.0));
        }
        StorageUsage flowFileRepoStorageUsage = new StorageUsage();
        flowFileRepoStorageUsage.setIdentifier("FlowFile Repository");
        try {
            flowFileRepoStorageUsage.setFreeSpace(flowFileRepo.getUsableStorageSpace());
            flowFileRepoStorageUsage.setTotalSpace(flowFileRepo.getStorageCapacity());
        }
        catch (IOException ioe) {
            flowFileRepoStorageUsage.setFreeSpace(0L);
            flowFileRepoStorageUsage.setTotalSpace(-1L);
            this.logger.warn("Unable to determine FlowFile Repository usage", (Throwable)ioe);
        }
        systemDiagnostics.setFlowFileRepositoryStorageUsage(flowFileRepoStorageUsage);
        Set containerNames = contentRepo.getContainerNames();
        LinkedHashMap<String, StorageUsage> fileRepositoryUsage = new LinkedHashMap<String, StorageUsage>(containerNames.size());
        for (String containerName : containerNames) {
            long containerCapacity = -1L;
            long containerFree = 0L;
            try {
                containerFree = contentRepo.getContainerUsableSpace(containerName);
                containerCapacity = contentRepo.getContainerCapacity(containerName);
            }
            catch (IOException ioe) {
                this.logger.warn("Unable to determine Content Repository usage for container {}", (Object)containerName, (Object)ioe);
            }
            StorageUsage storageUsage = new StorageUsage();
            storageUsage.setIdentifier(containerName);
            storageUsage.setFreeSpace(containerFree);
            storageUsage.setTotalSpace(containerCapacity);
            fileRepositoryUsage.put(containerName, storageUsage);
        }
        systemDiagnostics.setContentRepositoryStorageUsage(fileRepositoryUsage);
        Set provContainerNames = provenanceRepository.getContainerNames();
        LinkedHashMap<Object, StorageUsage> provRepositoryUsage = new LinkedHashMap<Object, StorageUsage>(provContainerNames.size());
        for (Object containerName : provContainerNames) {
            long containerCapacity = -1L;
            long containerFree = 0L;
            try {
                containerFree = provenanceRepository.getContainerUsableSpace((String)containerName);
                containerCapacity = provenanceRepository.getContainerCapacity((String)containerName);
            }
            catch (IOException ioe) {
                this.logger.warn("Unable to determine Provenance Repository usage for container {}", containerName, (Object)ioe);
            }
            StorageUsage storageUsage = new StorageUsage();
            storageUsage.setIdentifier((String)containerName);
            storageUsage.setFreeSpace(containerFree);
            storageUsage.setTotalSpace(containerCapacity);
            provRepositoryUsage.put(containerName, storageUsage);
        }
        systemDiagnostics.setProvenanceRepositoryStorageUsage(provRepositoryUsage);
        LinkedHashMap<String, GarbageCollection> garbageCollection = new LinkedHashMap<String, GarbageCollection>(garbageCollectors.size());
        for (GarbageCollectorMXBean garbageCollector : garbageCollectors) {
            GarbageCollection garbageCollectionEntry = new GarbageCollection();
            garbageCollectionEntry.setCollectionCount(garbageCollector.getCollectionCount());
            garbageCollectionEntry.setCollectionTime(garbageCollector.getCollectionTime());
            garbageCollection.put(garbageCollector.getName(), garbageCollectionEntry);
        }
        systemDiagnostics.setGarbageCollection(garbageCollection);
        OperatingSystemMXBean osStats = ManagementFactory.getOperatingSystemMXBean();
        try {
            Class<?> unixOsMxBeanClass = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            if (unixOsMxBeanClass.isAssignableFrom(osStats.getClass())) {
                Method totalPhysicalMemory = unixOsMxBeanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
                totalPhysicalMemory.setAccessible(true);
                Long ramBytes = (Long)totalPhysicalMemory.invoke((Object)osStats, new Object[0]);
                if (ramBytes != null) {
                    systemDiagnostics.setTotalPhysicalMemory(ramBytes.longValue());
                }
                Method maxFileDescriptors = unixOsMxBeanClass.getMethod("getMaxFileDescriptorCount", new Class[0]);
                maxFileDescriptors.setAccessible(true);
                Long maxOpenFileDescriptors = (Long)maxFileDescriptors.invoke((Object)osStats, new Object[0]);
                if (maxOpenFileDescriptors != null) {
                    systemDiagnostics.setMaxOpenFileHandles(maxOpenFileDescriptors.longValue());
                }
                Method openFileDescriptors = unixOsMxBeanClass.getMethod("getOpenFileDescriptorCount", new Class[0]);
                openFileDescriptors.setAccessible(true);
                Long openDescriptorCount = (Long)openFileDescriptors.invoke((Object)osStats, new Object[0]);
                if (openDescriptorCount != null) {
                    systemDiagnostics.setOpenFileHandles(openDescriptorCount.longValue());
                }
            }
        }
        catch (Throwable unixOsMxBeanClass) {
            // empty catch block
        }
        HashMap<ResourceClaim, Integer> claimantCounts = new HashMap<ResourceClaim, Integer>();
        HashSet<ResourceClaim> destructableClaims = new HashSet<ResourceClaim>();
        for (String containerName : contentRepo.getContainerNames()) {
            try {
                Set resourceClaims = contentRepo.getActiveResourceClaims(containerName);
                for (ResourceClaim resourceClaim : resourceClaims) {
                    int claimantCount = resourceClaimManager.getClaimantCount(resourceClaim);
                    claimantCounts.put(resourceClaim, claimantCount);
                    if (!resourceClaimManager.isDestructable(resourceClaim)) continue;
                    destructableClaims.add(resourceClaim);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to determine Resource Claim usage for Content Repository Container {}", (Object)containerName, (Object)e);
            }
        }
        systemDiagnostics.setClaimantCounts(claimantCounts);
        systemDiagnostics.setDestructableClaims(destructableClaims);
        systemDiagnostics.setCreationTimestamp(new Date().getTime());
        return systemDiagnostics;
    }
}

