/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.flowanalysis;

import java.util.function.Supplier;
import org.apache.nifi.controller.flowanalysis.FlowAnalyzer;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerFlowAnalysisTask
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FlowAnalyzer flowAnalyzer;
    private final Supplier<VersionedProcessGroup> rootProcessGroupSupplier;

    public TriggerFlowAnalysisTask(FlowAnalyzer flowAnalyzer, Supplier<VersionedProcessGroup> rootProcessGroupSupplier) {
        this.flowAnalyzer = flowAnalyzer;
        this.rootProcessGroupSupplier = rootProcessGroupSupplier;
    }

    @Override
    public void run() {
        if (this.flowAnalyzer.isFlowAnalysisRequired()) {
            this.logger.debug("Triggering analysis of entire flow");
            try {
                this.flowAnalyzer.analyzeProcessGroup(this.rootProcessGroupSupplier.get());
                this.flowAnalyzer.setFlowAnalysisRequired(false);
            }
            catch (Throwable t) {
                this.logger.error("Encountered unexpected error when attempting to analyze flow", t);
            }
        } else {
            this.logger.trace("Flow hasn't changed, flow analysis is put on hold");
        }
    }
}

