/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.configuration;

import javax.net.ssl.SSLContext;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.heartbeat.HeartbeatMonitor;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.impl.NodeProtocolSenderListener;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.StandardFlowService;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.metrics.RingBufferEventRepository;
import org.apache.nifi.controller.status.history.JsonNodeStatusHistoryDumpFactory;
import org.apache.nifi.controller.status.history.StatusHistoryDumpFactory;
import org.apache.nifi.controller.status.history.StatusHistoryRepository;
import org.apache.nifi.controller.status.history.VolatileComponentStatusRepository;
import org.apache.nifi.diagnostics.DiagnosticsFactory;
import org.apache.nifi.diagnostics.bootstrap.BootstrapDiagnosticsFactory;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.encrypt.PropertyEncryptorFactory;
import org.apache.nifi.extension.manifest.parser.ExtensionManifestParser;
import org.apache.nifi.extension.manifest.parser.jaxb.JAXBExtensionManifestParser;
import org.apache.nifi.manifest.RuntimeManifestService;
import org.apache.nifi.manifest.StandardRuntimeManifestService;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.validation.RuleViolationsManager;
import org.apache.nifi.validation.StandardRuleViolationsManager;
import org.apache.nifi.web.revision.RevisionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FlowControllerConfiguration {
    private NiFiProperties properties;
    private ExtensionDiscoveringManager extensionManager;
    private AuditService auditService;
    private Authorizer authorizer;
    private RevisionManager revisionManager;
    private LeaderElectionManager leaderElectionManager;
    private SSLContext sslContext;
    private StateManagerProvider stateManagerProvider;
    private BulletinRepository bulletinRepository;
    private NodeProtocolSender nodeProtocolSender;
    private NodeProtocolSenderListener nodeProtocolSenderListener;
    private HeartbeatMonitor heartbeatMonitor;
    private ClusterCoordinator clusterCoordinator;

    @Autowired
    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setExtensionManager(ExtensionDiscoveringManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    @Autowired
    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    @Autowired
    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    @Autowired
    public void setRevisionManager(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    @Autowired
    public void setLeaderElectionManager(LeaderElectionManager leaderElectionManager) {
        this.leaderElectionManager = leaderElectionManager;
    }

    @Autowired
    public void setStateManagerProvider(StateManagerProvider stateManagerProvider) {
        this.stateManagerProvider = stateManagerProvider;
    }

    @Autowired
    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    @Autowired(required=false)
    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Qualifier(value="nodeProtocolSender")
    @Autowired(required=false)
    public void setNodeProtocolSender(NodeProtocolSender nodeProtocolSender) {
        this.nodeProtocolSender = nodeProtocolSender;
    }

    @Autowired(required=false)
    public void setNodeProtocolSenderListener(NodeProtocolSenderListener nodeProtocolSenderListener) {
        this.nodeProtocolSenderListener = nodeProtocolSenderListener;
    }

    @Autowired(required=false)
    public void setHeartbeatMonitor(HeartbeatMonitor heartbeatMonitor) {
        this.heartbeatMonitor = heartbeatMonitor;
    }

    @Autowired(required=false)
    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    @Bean
    public FlowController flowController() throws Exception {
        FlowController flowController = this.clusterCoordinator == null ? FlowController.createStandaloneInstance((FlowFileEventRepository)this.flowFileEventRepository(), this.sslContext, this.properties, this.authorizer, this.auditService, this.propertyEncryptor(), this.bulletinRepository, this.extensionManager, this.statusHistoryRepository(), this.ruleViolationsManager(), this.stateManagerProvider) : FlowController.createClusteredInstance((FlowFileEventRepository)this.flowFileEventRepository(), this.sslContext, this.properties, this.authorizer, this.auditService, this.propertyEncryptor(), this.nodeProtocolSender, this.bulletinRepository, this.clusterCoordinator, this.heartbeatMonitor, this.leaderElectionManager, this.extensionManager, this.revisionManager, this.statusHistoryRepository(), this.ruleViolationsManager(), this.stateManagerProvider);
        return flowController;
    }

    @Bean
    public FlowService flowService() throws Exception {
        StandardFlowService flowService = this.clusterCoordinator == null ? StandardFlowService.createStandaloneInstance(this.flowController(), this.properties, this.revisionManager, this.authorizer) : StandardFlowService.createClusteredInstance(this.flowController(), this.properties, this.nodeProtocolSenderListener, this.clusterCoordinator, this.revisionManager, this.authorizer);
        return flowService;
    }

    @Bean
    public RingBufferEventRepository flowFileEventRepository() {
        return new RingBufferEventRepository(5);
    }

    @Bean
    public RuleViolationsManager ruleViolationsManager() {
        return new StandardRuleViolationsManager();
    }

    @Bean
    public PropertyEncryptor propertyEncryptor() {
        return PropertyEncryptorFactory.getPropertyEncryptor(this.properties);
    }

    @Bean
    public StatusHistoryRepository statusHistoryRepository() throws Exception {
        String configuredClassName = this.properties.getProperty("nifi.components.status.repository.implementation");
        String className = configuredClassName == null ? VolatileComponentStatusRepository.class.getName() : configuredClassName;
        StatusHistoryRepository statusHistoryRepository = (StatusHistoryRepository)NarThreadContextClassLoader.createInstance((ExtensionManager)this.extensionManager, (String)className, StatusHistoryRepository.class, (NiFiProperties)this.properties);
        statusHistoryRepository.start();
        return statusHistoryRepository;
    }

    @Bean
    public StatusHistoryDumpFactory statusHistoryDumpFactory() throws Exception {
        JsonNodeStatusHistoryDumpFactory statusHistoryDumpFactory = new JsonNodeStatusHistoryDumpFactory();
        statusHistoryDumpFactory.setStatusHistoryRepository(this.statusHistoryRepository());
        return statusHistoryDumpFactory;
    }

    @Bean
    public DiagnosticsFactory diagnosticsFactory() throws Exception {
        BootstrapDiagnosticsFactory diagnosticsFactory = new BootstrapDiagnosticsFactory();
        diagnosticsFactory.setNifiProperties(this.properties);
        diagnosticsFactory.setFlowController(this.flowController());
        return diagnosticsFactory;
    }

    @Bean
    public ExtensionManifestParser extensionManifestParser() {
        return new JAXBExtensionManifestParser();
    }

    @Bean
    public RuntimeManifestService runtimeManifestService() {
        return new StandardRuntimeManifestService((ExtensionManager)this.extensionManager, this.extensionManifestParser());
    }
}

