/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.configuration;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.leader.election.StandaloneLeaderElectionManager;
import org.apache.nifi.controller.state.manager.StandardStateManagerProvider;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.events.StandardEventReporter;
import org.apache.nifi.events.VolatileBulletinRepository;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionDiscoveringManager;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.ExtensionManagerHolder;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ManagerConfiguration {
    private NiFiProperties properties;
    private SSLContext sslContext;

    @Autowired
    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    @Autowired(required=false)
    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Bean
    public ExtensionDiscoveringManager extensionManager() {
        return (ExtensionDiscoveringManager)ExtensionManagerHolder.getExtensionManager();
    }

    @Bean
    public StateManagerProvider stateManagerProvider() {
        try {
            return StandardStateManagerProvider.create((NiFiProperties)this.properties, (SSLContext)this.sslContext, (ExtensionManager)this.extensionManager(), (ParameterLookup)ParameterLookup.EMPTY);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create State Manager Provider", e);
        }
    }

    @Bean
    public LeaderElectionManager leaderElectionManager() throws Exception {
        StandaloneLeaderElectionManager leaderElectionManager;
        if (this.properties.isClustered()) {
            ExtensionDiscoveringManager extensionManager = this.extensionManager();
            String configuredClassName = this.properties.getProperty("nifi.cluster.leader.election.implementation", "CuratorLeaderElectionManager");
            Set extensions = extensionManager.getExtensions(LeaderElectionManager.class);
            Optional<ExtensionDefinition> extensionFound = extensions.stream().filter(extensionDefinition -> {
                String extensionClassName = extensionDefinition.getImplementationClassName();
                return extensionClassName.equals(configuredClassName) || extensionClassName.endsWith(configuredClassName);
            }).findFirst();
            ExtensionDefinition extension = extensionFound.orElseThrow(() -> {
                String message = String.format("No Extensions Found for %s", LeaderElectionManager.class.getName());
                return new IllegalStateException(message);
            });
            String extensionImplementationClass = extension.getImplementationClassName();
            leaderElectionManager = (LeaderElectionManager)NarThreadContextClassLoader.createInstance((ExtensionManager)extensionManager, (String)extensionImplementationClass, LeaderElectionManager.class, (NiFiProperties)this.properties);
        } else {
            leaderElectionManager = new StandaloneLeaderElectionManager();
        }
        return leaderElectionManager;
    }

    @Bean
    public BulletinRepository bulletinRepository() {
        return new VolatileBulletinRepository();
    }

    @Bean
    public EventReporter eventReporter() {
        return new StandardEventReporter(this.bulletinRepository());
    }
}

