/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchService;
import java.security.KeyStore;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.framework.ssl.FrameworkSslContextHolder;
import org.apache.nifi.framework.ssl.SecurityStoreChangedPathListener;
import org.apache.nifi.framework.ssl.WatchServiceMonitorCommand;
import org.apache.nifi.security.ssl.KeyManagerListener;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.TrustManagerListener;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
public class SslContextConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SslContextConfiguration.class);
    private static final String EMPTY = "";
    private NiFiProperties properties;

    @Autowired
    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    @Bean
    public SSLContext sslContext() {
        return FrameworkSslContextHolder.getSslContext();
    }

    @Bean
    public X509ExtendedKeyManager keyManager() {
        return FrameworkSslContextHolder.getKeyManager();
    }

    @Bean
    public X509ExtendedTrustManager trustManager() {
        return FrameworkSslContextHolder.getTrustManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Bean
    public WatchServiceMonitorCommand watchServiceMonitorCommand() {
        if (!this.isReloadEnabled()) return null;
        String reloadIntervalProperty = this.properties.getProperty("nifi.security.autoreload.interval");
        long reloadIntervalSeconds = Math.round(FormatUtils.getPreciseTimeDuration((String)reloadIntervalProperty, (TimeUnit)TimeUnit.SECONDS));
        Duration reloadDuration = Duration.ofSeconds(reloadIntervalSeconds);
        X509ExtendedKeyManager keyManager = this.keyManager();
        X509ExtendedTrustManager trustManager = this.trustManager();
        if (!(keyManager instanceof KeyManagerListener)) throw new IllegalStateException("Key Manager Listener or Trust Manager Listener not found");
        KeyManagerListener keyManagerListener = (KeyManagerListener)keyManager;
        if (!(trustManager instanceof TrustManagerListener)) throw new IllegalStateException("Key Manager Listener or Trust Manager Listener not found");
        TrustManagerListener trustManagerListener = (TrustManagerListener)trustManager;
        Set<Path> storeFileNames = this.getStoreFileNames();
        SecurityStoreChangedPathListener changedPathListener = new SecurityStoreChangedPathListener(storeFileNames, keyManagerListener, FrameworkSslContextHolder.getKeyManagerBuilder(), trustManagerListener, FrameworkSslContextHolder.getTrustManagerBuilder());
        WatchService watchService = this.storeWatchService();
        WatchServiceMonitorCommand command = new WatchServiceMonitorCommand(watchService, changedPathListener);
        this.watchServiceScheduler().scheduleAtFixedRate((Runnable)command, reloadDuration);
        logger.info("Scheduled Security Store Monitor with Duration [{}]", (Object)reloadDuration);
        return command;
    }

    @Bean
    public ThreadPoolTaskScheduler watchServiceScheduler() {
        ThreadPoolTaskScheduler scheduler;
        if (this.isReloadEnabled()) {
            scheduler = new ThreadPoolTaskScheduler();
            scheduler.setThreadNamePrefix("Security Store Monitor ");
        } else {
            scheduler = null;
        }
        return scheduler;
    }

    @Bean
    public WatchService storeWatchService() {
        WatchService watchService;
        String keyStoreProperty = this.properties.getProperty("nifi.security.keystore");
        if (keyStoreProperty == null || keyStoreProperty.isBlank()) {
            watchService = null;
        } else if (this.isReloadEnabled()) {
            Set<Path> storeDirectories = this.getStoreDirectories();
            FileSystem fileSystem = FileSystems.getDefault();
            try {
                watchService = fileSystem.newWatchService();
                for (Path storeDirectory : storeDirectories) {
                    storeDirectory.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException("Store Watch Service creation failed", e);
            }
        } else {
            watchService = null;
        }
        return watchService;
    }

    @Bean
    public KeyStore keyStore() {
        KeyStore keyStore;
        String keyStorePath = this.properties.getProperty("nifi.security.keystore");
        if (keyStorePath == null || keyStorePath.isBlank()) {
            keyStore = null;
        } else {
            char[] keyStorePassword = this.properties.getProperty("nifi.security.keystorePasswd", EMPTY).toCharArray();
            String keyStoreType = this.properties.getProperty("nifi.security.keystoreType");
            try (FileInputStream inputStream = new FileInputStream(keyStorePath);){
                keyStore = new StandardKeyStoreBuilder().inputStream((InputStream)inputStream).password(keyStorePassword).type(keyStoreType).build();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load Key Store [%s] Type [%s]".formatted(keyStorePath, keyStoreType), e);
            }
        }
        return keyStore;
    }

    @Bean
    public KeyStore trustStore() {
        KeyStore trustStore;
        String trustStorePath = this.properties.getProperty("nifi.security.truststore");
        if (trustStorePath == null || trustStorePath.isBlank()) {
            trustStore = null;
        } else {
            char[] trustStorePassword = this.properties.getProperty("nifi.security.truststorePasswd", EMPTY).toCharArray();
            String trustStoreType = this.properties.getProperty("nifi.security.truststoreType");
            try (FileInputStream inputStream = new FileInputStream(trustStorePath);){
                trustStore = new StandardKeyStoreBuilder().inputStream((InputStream)inputStream).password(trustStorePassword).type(trustStoreType).build();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load Trust Store [%s] Type [%s]".formatted(trustStorePath, trustStoreType), e);
            }
        }
        return trustStore;
    }

    private Set<Path> getStoreFileNames() {
        HashSet<Path> storeFileNames = new HashSet<Path>();
        Path keyStorePath = this.getKeyStorePath();
        this.addStoreFileName(keyStorePath, storeFileNames);
        Path trustStorePath = this.getTrustStorePath();
        this.addStoreFileName(trustStorePath, storeFileNames);
        return storeFileNames;
    }

    private void addStoreFileName(Path storePath, Set<Path> storeFileNames) {
        storeFileNames.add(storePath.getFileName());
        if (Files.isSymbolicLink(storePath)) {
            try {
                Path realStorePath = storePath.toRealPath(new LinkOption[0]);
                storeFileNames.add(realStorePath.getFileName());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to resolve Store Path Link [%s]".formatted(storePath), e);
            }
        }
    }

    private Set<Path> getStoreDirectories() {
        HashSet<Path> storeDirectories = new HashSet<Path>();
        Path keyStorePath = this.getKeyStorePath();
        this.addStorePath(keyStorePath, storeDirectories);
        Path trustStorePath = this.getTrustStorePath();
        this.addStorePath(trustStorePath, storeDirectories);
        return storeDirectories;
    }

    private void addStorePath(Path storePath, Set<Path> storeDirectories) {
        Path storeDirectory = storePath.getParent();
        storeDirectories.add(storeDirectory);
        if (Files.isSymbolicLink(storePath)) {
            try {
                Path realStorePath = storePath.toRealPath(new LinkOption[0]);
                Path realStoreDirectory = realStorePath.getParent();
                storeDirectories.add(realStoreDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to resolve Store Path Link [%s]".formatted(storePath), e);
            }
        }
    }

    private Path getKeyStorePath() {
        String keyStoreProperty = this.properties.getProperty("nifi.security.keystore");
        if (keyStoreProperty == null || keyStoreProperty.isBlank()) {
            throw new IllegalStateException("Security Property [%s] not configured".formatted("nifi.security.keystore"));
        }
        return Paths.get(keyStoreProperty, new String[0]).toAbsolutePath();
    }

    private Path getTrustStorePath() {
        String trustStoreProperty = this.properties.getProperty("nifi.security.truststore");
        if (trustStoreProperty == null || trustStoreProperty.isBlank()) {
            throw new IllegalStateException("Security Property [%s] not configured".formatted("nifi.security.truststore"));
        }
        return Paths.get(trustStoreProperty, new String[0]).toAbsolutePath();
    }

    private boolean isReloadEnabled() {
        String reloadEnabledProperty = this.properties.getProperty("nifi.security.autoreload.enabled");
        return Boolean.parseBoolean(reloadEnabledProperty);
    }
}

