/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Objects;
import javax.net.ssl.X509ExtendedKeyManager;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.StandardKeyManagerBuilder;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardX509ExtendedKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkKeyManagerBuilder
extends StandardKeyManagerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkKeyManagerBuilder.class);
    private final Path keyStorePath;
    private final StandardKeyStoreBuilder keyStoreBuilder;

    public FrameworkKeyManagerBuilder(Path keyStorePath, StandardKeyStoreBuilder keyStoreBuilder, char[] keyPassword) {
        this.keyStorePath = Objects.requireNonNull(keyStorePath, "Key Store Path required");
        this.keyStoreBuilder = Objects.requireNonNull(keyStoreBuilder, "Key Store Builder required");
        this.keyPassword(Objects.requireNonNull(keyPassword, "Key Password required"));
    }

    public X509ExtendedKeyManager build() {
        this.loadKeyStore();
        X509ExtendedKeyManager keyManager = super.build();
        logger.info("Key Manager loaded from Key Store [{}]", (Object)this.keyStorePath);
        return new StandardX509ExtendedKeyManager(keyManager);
    }

    private void loadKeyStore() {
        try (InputStream inputStream = Files.newInputStream(this.keyStorePath, new OpenOption[0]);){
            KeyStore loadedKeyStore = this.keyStoreBuilder.inputStream(inputStream).build();
            this.keyStore(loadedKeyStore);
        }
        catch (IOException e) {
            throw new BuilderConfigurationException("Key Store loading failed", (Throwable)e);
        }
    }
}

