/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.ssl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.framework.ssl.FrameworkKeyManagerBuilder;
import org.apache.nifi.framework.ssl.FrameworkSslContextHolder;
import org.apache.nifi.framework.ssl.FrameworkTrustManagerBuilder;
import org.apache.nifi.security.ssl.KeyManagerBuilder;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardSslContextBuilder;
import org.apache.nifi.security.ssl.TrustManagerBuilder;
import org.apache.nifi.util.NiFiProperties;

public class FrameworkSslContextProvider {
    private static final String EMPTY = "";
    private final NiFiProperties properties;

    public FrameworkSslContextProvider(NiFiProperties properties) {
        this.properties = Objects.requireNonNull(properties, "Application Properties required");
    }

    public Optional<SSLContext> loadSslContext() {
        Optional<SSLContext> sslContextHolder;
        KeyManagerBuilder keyManagerBuilder = this.getKeyManagerBuilder();
        TrustManagerBuilder trustManagerBuilder = this.getTrustManagerBuilder();
        if (keyManagerBuilder == null || trustManagerBuilder == null) {
            sslContextHolder = Optional.empty();
        } else {
            X509ExtendedKeyManager keyManager = keyManagerBuilder.build();
            X509ExtendedTrustManager trustManager = trustManagerBuilder.build();
            SSLContext sslContext = new StandardSslContextBuilder().keyManager((KeyManager)keyManager).trustManager((TrustManager)trustManager).build();
            sslContextHolder = Optional.of(sslContext);
            FrameworkSslContextHolder.setSslContext(sslContext);
            FrameworkSslContextHolder.setKeyManager(keyManager);
            FrameworkSslContextHolder.setKeyManagerBuilder(keyManagerBuilder);
            FrameworkSslContextHolder.setTrustManager(trustManager);
            FrameworkSslContextHolder.setTrustManagerBuilder(trustManagerBuilder);
        }
        return sslContextHolder;
    }

    private KeyManagerBuilder getKeyManagerBuilder() {
        FrameworkKeyManagerBuilder keyManagerBuilder;
        if (this.properties.isHTTPSConfigured()) {
            Path keyStorePath = this.getKeyStorePath();
            String keyStorePassword = this.properties.getProperty("nifi.security.keystorePasswd", EMPTY);
            char[] keyPassword = this.properties.getProperty("nifi.security.keyPasswd", keyStorePassword).toCharArray();
            String keyStoreType = this.properties.getProperty("nifi.security.keystoreType");
            StandardKeyStoreBuilder keyStoreBuilder = new StandardKeyStoreBuilder().password(keyStorePassword.toCharArray()).type(keyStoreType);
            keyManagerBuilder = new FrameworkKeyManagerBuilder(keyStorePath, keyStoreBuilder, keyPassword);
        } else {
            keyManagerBuilder = null;
        }
        return keyManagerBuilder;
    }

    private TrustManagerBuilder getTrustManagerBuilder() {
        FrameworkTrustManagerBuilder trustManagerBuilder;
        if (this.properties.isHTTPSConfigured()) {
            Path trustStorePath = this.getTrustStorePath();
            String trustStorePassword = this.properties.getProperty("nifi.security.truststorePasswd", EMPTY);
            String trustStoreType = this.properties.getProperty("nifi.security.truststoreType");
            StandardKeyStoreBuilder trustStoreBuilder = new StandardKeyStoreBuilder().password(trustStorePassword.toCharArray()).type(trustStoreType);
            trustManagerBuilder = new FrameworkTrustManagerBuilder(trustStorePath, trustStoreBuilder);
        } else {
            trustManagerBuilder = null;
        }
        return trustManagerBuilder;
    }

    private Path getKeyStorePath() {
        String keyStoreProperty = this.properties.getProperty("nifi.security.keystore");
        if (keyStoreProperty == null || keyStoreProperty.isBlank()) {
            throw new IllegalStateException("Security Property [%s] not configured".formatted("nifi.security.keystore"));
        }
        return Paths.get(keyStoreProperty, new String[0]);
    }

    private Path getTrustStorePath() {
        String trustStoreProperty = this.properties.getProperty("nifi.security.truststore");
        if (trustStoreProperty == null || trustStoreProperty.isBlank()) {
            throw new IllegalStateException("Security Property [%s] not configured".formatted("nifi.security.truststore"));
        }
        return Paths.get(trustStoreProperty, new String[0]);
    }
}

