/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Objects;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.security.ssl.BuilderConfigurationException;
import org.apache.nifi.security.ssl.StandardKeyStoreBuilder;
import org.apache.nifi.security.ssl.StandardTrustManagerBuilder;
import org.apache.nifi.security.ssl.StandardX509ExtendedTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkTrustManagerBuilder
extends StandardTrustManagerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkTrustManagerBuilder.class);
    private final Path trustStorePath;
    private final StandardKeyStoreBuilder trustStoreBuilder;

    public FrameworkTrustManagerBuilder(Path trustStorePath, StandardKeyStoreBuilder trustStoreBuilder) {
        this.trustStorePath = Objects.requireNonNull(trustStorePath, "Trust Store Path required");
        this.trustStoreBuilder = Objects.requireNonNull(trustStoreBuilder, "Trust Store Builder required");
    }

    public X509ExtendedTrustManager build() {
        this.loadTrustStore();
        X509ExtendedTrustManager trustManager = super.build();
        logger.info("Trust Manager loaded from Trust Store [{}]", (Object)this.trustStorePath);
        return new StandardX509ExtendedTrustManager(trustManager);
    }

    private void loadTrustStore() {
        try (InputStream inputStream = Files.newInputStream(this.trustStorePath, new OpenOption[0]);){
            KeyStore loadedTrustStore = this.trustStoreBuilder.inputStream(inputStream).build();
            this.trustStore(loadedTrustStore);
        }
        catch (IOException e) {
            throw new BuilderConfigurationException("Trust Store loading failed", (Throwable)e);
        }
    }
}

