/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.ssl;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.nifi.framework.ssl.WatchServiceMonitorCommand;
import org.apache.nifi.security.ssl.KeyManagerBuilder;
import org.apache.nifi.security.ssl.KeyManagerListener;
import org.apache.nifi.security.ssl.TrustManagerBuilder;
import org.apache.nifi.security.ssl.TrustManagerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityStoreChangedPathListener
implements WatchServiceMonitorCommand.ChangedPathListener {
    private static final Logger logger = LoggerFactory.getLogger(SecurityStoreChangedPathListener.class);
    private final Set<Path> storeFileNames;
    private final KeyManagerListener keyManagerListener;
    private final KeyManagerBuilder keyManagerBuilder;
    private final TrustManagerListener trustManagerListener;
    private final TrustManagerBuilder trustManagerBuilder;

    public SecurityStoreChangedPathListener(Set<Path> storeFileNames, KeyManagerListener keyManagerListener, KeyManagerBuilder keyManagerBuilder, TrustManagerListener trustManagerListener, TrustManagerBuilder trustManagerBuilder) {
        this.storeFileNames = Objects.requireNonNull(storeFileNames, "Store File Names required");
        this.keyManagerListener = Objects.requireNonNull(keyManagerListener, "Key Manager Listener required");
        this.keyManagerBuilder = Objects.requireNonNull(keyManagerBuilder, "Key Manager Builder required");
        this.trustManagerListener = Objects.requireNonNull(trustManagerListener, "Trust Manager Listener required");
        this.trustManagerBuilder = Objects.requireNonNull(trustManagerBuilder, "Trust Manager Builder required");
    }

    @Override
    public void onChanged(List<Path> changedPaths) {
        Optional<Path> storeFileNameFound = changedPaths.stream().map(Path::getFileName).filter(this.storeFileNames::contains).findFirst();
        if (storeFileNameFound.isPresent()) {
            X509ExtendedKeyManager keyManager = this.keyManagerBuilder.build();
            X509ExtendedTrustManager trustManager = this.trustManagerBuilder.build();
            this.keyManagerListener.setKeyManager(keyManager);
            this.trustManagerListener.setTrustManager(trustManager);
            logger.info("Key Manager and Trust Manager Reloaded from Changed Path [{}]", (Object)storeFileNameFound.get().toAbsolutePath());
        }
    }
}

