/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.ssl;

import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchServiceMonitorCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WatchServiceMonitorCommand.class);
    private final WatchService watchService;
    private final ChangedPathListener changedPathListener;

    public WatchServiceMonitorCommand(WatchService watchService, ChangedPathListener changedPathListener) {
        this.watchService = Objects.requireNonNull(watchService, "Watch Service required");
        this.changedPathListener = Objects.requireNonNull(changedPathListener, "Changed Path Listener required");
    }

    @Override
    public void run() {
        WatchKey watchKey = this.watchService.poll();
        if (watchKey == null) {
            logger.debug("Watch Key not found");
        } else {
            try {
                this.processWatchKey(watchKey);
            }
            finally {
                if (watchKey.reset()) {
                    logger.debug("Watch Key reset completed");
                } else {
                    logger.warn("Watch Key reset failed: Watch Service no longer valid");
                }
            }
        }
    }

    private void processWatchKey(WatchKey watchKey) {
        List<WatchEvent<?>> events = watchKey.pollEvents();
        List<Path> changedPaths = this.getChangedPaths(events);
        if (changedPaths.isEmpty()) {
            logger.debug("Changed Paths not found");
        } else {
            logger.debug("Changed Paths found {}", changedPaths);
            this.changedPathListener.onChanged(changedPaths);
        }
    }

    private List<Path> getChangedPaths(List<WatchEvent<?>> events) {
        ArrayList<Path> changedPaths = new ArrayList<Path>();
        for (WatchEvent<?> event : events) {
            Object context;
            WatchEvent.Kind<?> kind = event.kind();
            if (StandardWatchEventKinds.OVERFLOW == kind || !((context = event.context()) instanceof Path)) continue;
            Path path = (Path)context;
            changedPaths.add(path);
        }
        return changedPaths;
    }

    public static interface ChangedPathListener {
        public void onChanged(List<Path> var1);
    }
}

