/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.manifest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.c2.protocol.component.api.BuildInfo;
import org.apache.nifi.c2.protocol.component.api.RuntimeManifest;
import org.apache.nifi.extension.manifest.AllowableValue;
import org.apache.nifi.extension.manifest.ControllerServiceDefinition;
import org.apache.nifi.extension.manifest.ExpressionLanguageScope;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.extension.manifest.ExtensionManifest;
import org.apache.nifi.extension.manifest.ExtensionType;
import org.apache.nifi.extension.manifest.InputRequirement;
import org.apache.nifi.extension.manifest.MultiProcessorUseCase;
import org.apache.nifi.extension.manifest.ProcessorConfiguration;
import org.apache.nifi.extension.manifest.Property;
import org.apache.nifi.extension.manifest.Relationship;
import org.apache.nifi.extension.manifest.UseCase;
import org.apache.nifi.extension.manifest.parser.ExtensionManifestParser;
import org.apache.nifi.manifest.RuntimeManifestService;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.PythonBundle;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.python.PythonProcessorDetails;
import org.apache.nifi.python.processor.documentation.MultiProcessorUseCaseDetails;
import org.apache.nifi.python.processor.documentation.ProcessorConfigurationDetails;
import org.apache.nifi.python.processor.documentation.PropertyDescription;
import org.apache.nifi.python.processor.documentation.UseCaseDetails;
import org.apache.nifi.runtime.manifest.ExtensionManifestContainer;
import org.apache.nifi.runtime.manifest.RuntimeManifestBuilder;
import org.apache.nifi.runtime.manifest.impl.SchedulingDefaultsFactory;
import org.apache.nifi.runtime.manifest.impl.StandardRuntimeManifestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardRuntimeManifestService
implements RuntimeManifestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardRuntimeManifestService.class);
    private static final String RUNTIME_MANIFEST_IDENTIFIER = "nifi";
    private static final String RUNTIME_TYPE = "nifi";
    private final ExtensionManager extensionManager;
    private final ExtensionManifestParser extensionManifestParser;
    private final String runtimeManifestIdentifier;
    private final String runtimeType;

    public StandardRuntimeManifestService(ExtensionManager extensionManager, ExtensionManifestParser extensionManifestParser, String runtimeManifestIdentifier, String runtimeType) {
        this.extensionManager = extensionManager;
        this.extensionManifestParser = extensionManifestParser;
        this.runtimeManifestIdentifier = runtimeManifestIdentifier;
        this.runtimeType = runtimeType;
    }

    public StandardRuntimeManifestService(ExtensionManager extensionManager, ExtensionManifestParser extensionManifestParser) {
        this(extensionManager, extensionManifestParser, "nifi", "nifi");
    }

    public RuntimeManifest getManifest() {
        Set allBundles = this.extensionManager.getAllBundles();
        Bundle frameworkBundle = this.getFrameworkBundle();
        BundleDetails frameworkDetails = frameworkBundle.getBundleDetails();
        Date frameworkBuildDate = frameworkDetails.getBuildTimestampDate();
        BuildInfo buildInfo = new BuildInfo();
        buildInfo.setVersion(frameworkDetails.getCoordinate().getVersion());
        buildInfo.setRevision(frameworkDetails.getBuildRevision());
        buildInfo.setCompiler(frameworkDetails.getBuildJdk());
        buildInfo.setTimestamp(frameworkBuildDate == null ? null : Long.valueOf(frameworkBuildDate.getTime()));
        RuntimeManifestBuilder manifestBuilder = new StandardRuntimeManifestBuilder().identifier(this.runtimeManifestIdentifier).runtimeType(this.runtimeType).version(buildInfo.getVersion()).schedulingDefaults(SchedulingDefaultsFactory.getNifiSchedulingDefaults()).buildInfo(buildInfo);
        for (Bundle bundle : allBundles) {
            this.getExtensionManifest(bundle).ifPresent(arg_0 -> ((RuntimeManifestBuilder)manifestBuilder).addBundle(arg_0));
        }
        this.getPythonExtensionManifests().forEach(arg_0 -> ((RuntimeManifestBuilder)manifestBuilder).addBundle(arg_0));
        return manifestBuilder.build();
    }

    private List<ExtensionManifestContainer> getPythonExtensionManifests() {
        List extensions;
        HashMap<String, List> extensionsPerVersion = new HashMap<String, List>();
        Set processorDefinitions = this.extensionManager.getExtensions(Processor.class);
        for (ExtensionDefinition definition : processorDefinitions) {
            if (!PythonBundle.isPythonCoordinate((BundleCoordinate)definition.getBundle().getBundleDetails().getCoordinate())) continue;
            PythonProcessorDetails pythonProcessorDetails = this.extensionManager.getPythonProcessorDetails(definition.getImplementationClassName(), definition.getVersion());
            if (pythonProcessorDetails == null) {
                LOGGER.debug("Could not find Python Processor Details for {} version {}", (Object)definition.getImplementationClassName(), (Object)definition.getVersion());
                continue;
            }
            Extension extension = this.createExtension(pythonProcessorDetails);
            extensions = extensionsPerVersion.computeIfAbsent(definition.getVersion(), version -> new ArrayList());
            extensions.add(extension);
        }
        if (extensionsPerVersion.isEmpty()) {
            return List.of();
        }
        ArrayList<ExtensionManifestContainer> containers = new ArrayList<ExtensionManifestContainer>();
        for (Map.Entry entry : extensionsPerVersion.entrySet()) {
            String version2 = (String)entry.getKey();
            extensions = (List)entry.getValue();
            ExtensionManifest extensionManifest = new ExtensionManifest();
            extensionManifest.setGroupId("org.apache.nifi");
            extensionManifest.setArtifactId("python-extensions");
            extensionManifest.setVersion(version2);
            extensionManifest.setExtensions(extensions);
            containers.add(new ExtensionManifestContainer(extensionManifest, Map.of()));
        }
        return containers;
    }

    private Extension createExtension(PythonProcessorDetails pythonProcessorDetails) {
        Extension extension = new Extension();
        extension.setDescription(pythonProcessorDetails.getCapabilityDescription());
        extension.setName(pythonProcessorDetails.getProcessorType());
        extension.setInputRequirement(InputRequirement.INPUT_REQUIRED);
        extension.setSupportsBatching(true);
        extension.setType(ExtensionType.PROCESSOR);
        extension.setTriggerWhenEmpty(false);
        extension.setTriggerSerially(false);
        extension.setTriggerWhenAnyDestinationAvailable(false);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        extension.setRelationships(relationships);
        for (String relationshipName : List.of("success", "failure", "original")) {
            Relationship relationship = new Relationship();
            relationship.setAutoTerminated(false);
            relationship.setName(relationshipName);
            relationships.add(relationship);
        }
        List<UseCase> useCases = StandardRuntimeManifestService.getUseCases(pythonProcessorDetails);
        extension.setUseCases(useCases);
        List<MultiProcessorUseCase> multiProcessorUseCases = StandardRuntimeManifestService.getMultiProcessorUseCases(pythonProcessorDetails);
        extension.setMultiProcessorUseCases(multiProcessorUseCases);
        List propertyDescriptions = pythonProcessorDetails.getPropertyDescriptions();
        List manifestProperties = propertyDescriptions == null ? List.of() : propertyDescriptions.stream().map(StandardRuntimeManifestService::createManifestProperty).toList();
        extension.setProperties(manifestProperties);
        return extension;
    }

    private static Property createManifestProperty(PropertyDescription propertyDescription) {
        Property property = new Property();
        property.setName(propertyDescription.getName());
        property.setDescription(propertyDescription.getDescription());
        property.setDefaultValue(propertyDescription.getDefaultValue());
        property.setDisplayName(propertyDescription.getDisplayName());
        property.setDynamicallyModifiesClasspath(false);
        property.setDynamic(false);
        try {
            property.setExpressionLanguageScope(ExpressionLanguageScope.valueOf((String)propertyDescription.getExpressionLanguageScope()));
        }
        catch (Exception e) {
            property.setExpressionLanguageScope(ExpressionLanguageScope.NONE);
        }
        property.setRequired(propertyDescription.isRequired());
        property.setSensitive(propertyDescription.isSensitive());
        property.setControllerServiceDefinition(StandardRuntimeManifestService.getManifestControllerServiceDefinition(propertyDescription.getControllerServiceDefinition()));
        property.setAllowableValues(StandardRuntimeManifestService.getAllowableValues(propertyDescription));
        return property;
    }

    private static ControllerServiceDefinition getManifestControllerServiceDefinition(String controllerServiceClassName) {
        if (controllerServiceClassName == null) {
            return null;
        }
        ControllerServiceDefinition definition = new ControllerServiceDefinition();
        definition.setClassName(controllerServiceClassName);
        return definition;
    }

    private static List<AllowableValue> getAllowableValues(PropertyDescription propertyDescription) {
        return Optional.ofNullable(propertyDescription.getAllowableValues()).orElse(List.of()).stream().map(value -> {
            AllowableValue allowableValue = new AllowableValue();
            allowableValue.setValue(value);
            allowableValue.setDisplayName(value);
            return allowableValue;
        }).toList();
    }

    private static List<UseCase> getUseCases(PythonProcessorDetails pythonProcessorDetails) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>();
        for (UseCaseDetails useCaseDetails : pythonProcessorDetails.getUseCases()) {
            UseCase useCase = new UseCase();
            useCases.add(useCase);
            useCase.setDescription(useCaseDetails.getDescription());
            useCase.setNotes(useCaseDetails.getNotes());
            useCase.setKeywords(useCaseDetails.getKeywords());
            useCase.setInputRequirement(InputRequirement.INPUT_REQUIRED);
            useCase.setConfiguration(useCaseDetails.getConfiguration());
        }
        return useCases;
    }

    private static List<MultiProcessorUseCase> getMultiProcessorUseCases(PythonProcessorDetails pythonProcessorDetails) {
        ArrayList<MultiProcessorUseCase> multiProcessorUseCases = new ArrayList<MultiProcessorUseCase>();
        for (MultiProcessorUseCaseDetails useCaseDetails : pythonProcessorDetails.getMultiProcessorUseCases()) {
            MultiProcessorUseCase useCase = new MultiProcessorUseCase();
            multiProcessorUseCases.add(useCase);
            useCase.setDescription(useCaseDetails.getDescription());
            useCase.setNotes(useCaseDetails.getNotes());
            useCase.setKeywords(useCaseDetails.getKeywords());
            ArrayList<ProcessorConfiguration> processorConfigurations = new ArrayList<ProcessorConfiguration>();
            useCase.setProcessorConfigurations(processorConfigurations);
            for (ProcessorConfigurationDetails processorConfig : useCaseDetails.getConfigurations()) {
                ProcessorConfiguration processorConfiguration = new ProcessorConfiguration();
                processorConfigurations.add(processorConfiguration);
                processorConfiguration.setConfiguration(processorConfig.getConfiguration());
                processorConfiguration.setProcessorClassName(processorConfig.getProcessorType());
            }
        }
        return multiProcessorUseCases;
    }

    private Optional<ExtensionManifestContainer> getExtensionManifest(Bundle bundle) {
        BundleDetails bundleDetails = bundle.getBundleDetails();
        try {
            Optional<ExtensionManifest> extensionManifest = this.loadExtensionManifest(bundleDetails);
            if (extensionManifest.isEmpty()) {
                return Optional.empty();
            }
            Map<String, String> additionalDetails = this.loadAdditionalDetails(bundleDetails);
            ExtensionManifestContainer container = new ExtensionManifestContainer(extensionManifest.get(), additionalDetails);
            return Optional.of(container);
        }
        catch (IOException e) {
            LOGGER.error("Unable to load extension manifest for bundle [{}]", (Object)bundleDetails.getCoordinate(), (Object)e);
            return Optional.empty();
        }
    }

    private Optional<ExtensionManifest> loadExtensionManifest(BundleDetails bundleDetails) throws IOException {
        File manifestFile = new File(bundleDetails.getWorkingDirectory(), "META-INF/docs/extension-manifest.xml");
        if (!manifestFile.exists()) {
            LOGGER.warn("There is no extension manifest for bundle [{}]", (Object)bundleDetails.getCoordinate());
            return Optional.empty();
        }
        try (FileInputStream inputStream = new FileInputStream(manifestFile);){
            ExtensionManifest extensionManifest = this.extensionManifestParser.parse((InputStream)inputStream);
            extensionManifest.setGroupId(bundleDetails.getCoordinate().getGroup());
            extensionManifest.setArtifactId(bundleDetails.getCoordinate().getId());
            extensionManifest.setVersion(bundleDetails.getCoordinate().getVersion());
            Optional<ExtensionManifest> optional = Optional.of(extensionManifest);
            return optional;
        }
    }

    private Map<String, String> loadAdditionalDetails(BundleDetails bundleDetails) {
        LinkedHashMap<String, String> additionalDetailsMap = new LinkedHashMap<String, String>();
        File additionalDetailsDir = new File(bundleDetails.getWorkingDirectory(), "META-INF/docs/additional-details");
        if (!additionalDetailsDir.exists()) {
            LOGGER.debug("No additional-details directory found under [{}]", (Object)bundleDetails.getWorkingDirectory().getAbsolutePath());
            return additionalDetailsMap;
        }
        for (File additionalDetailsTypeDir : additionalDetailsDir.listFiles()) {
            if (!additionalDetailsTypeDir.isDirectory()) {
                LOGGER.debug("Skipping [{}], not a directory...", (Object)additionalDetailsTypeDir.getAbsolutePath());
                continue;
            }
            File additionalDetailsFile = new File(additionalDetailsTypeDir, "additionalDetails.html");
            if (!additionalDetailsFile.exists()) {
                LOGGER.debug("No additionalDetails.html found under [{}]", (Object)additionalDetailsTypeDir.getAbsolutePath());
                continue;
            }
            try (Stream<String> additionalDetailsLines = Files.lines(additionalDetailsFile.toPath());){
                String typeName = additionalDetailsTypeDir.getName();
                String additionalDetailsContent = additionalDetailsLines.collect(Collectors.joining());
                LOGGER.debug("Added additionalDetails for {} from {}", (Object)typeName, (Object)additionalDetailsFile.getAbsolutePath());
                additionalDetailsMap.put(typeName, additionalDetailsContent);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load additional details content for " + additionalDetailsFile.getAbsolutePath() + " due to: " + e.getMessage(), e);
            }
        }
        return additionalDetailsMap;
    }

    Bundle getFrameworkBundle() {
        return NarClassLoadersHolder.getInstance().getFrameworkBundle();
    }
}

