/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.nifi.action.Action;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.RepositoryStatusReport;
import org.apache.nifi.controller.repository.metrics.EmptyFlowFileEvent;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.analytics.StatusAnalyticsEngine;
import org.apache.nifi.diagnostics.StorageUsage;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.history.History;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.reporting.AbstractEventAccess;
import org.apache.nifi.reporting.UserAwareEventAccess;

public class StandardEventAccess
extends AbstractEventAccess
implements UserAwareEventAccess {
    private final FlowManager flowManager;
    private final FlowFileEventRepository flowFileEventRepository;
    private final Authorizer authorizer;
    private final ProvenanceRepository provenanceRepository;
    private final AuditService auditService;
    private final FlowFileRepository flowFileRepository;
    private final ContentRepository contentRepository;

    public StandardEventAccess(FlowManager flowManager, FlowFileEventRepository flowFileEventRepository, ProcessScheduler processScheduler, Authorizer authorizer, ProvenanceRepository provenanceRepository, AuditService auditService, StatusAnalyticsEngine statusAnalyticsEngine, FlowFileRepository flowFileRepository, ContentRepository contentRepository) {
        super(processScheduler, statusAnalyticsEngine, flowManager, flowFileEventRepository);
        this.flowFileEventRepository = flowFileEventRepository;
        this.flowManager = flowManager;
        this.authorizer = authorizer;
        this.provenanceRepository = provenanceRepository;
        this.auditService = auditService;
        this.flowFileRepository = flowFileRepository;
        this.contentRepository = contentRepository;
    }

    public List<Action> getFlowChanges(int firstActionId, int maxActions) {
        History history = this.auditService.getActions(firstActionId, maxActions);
        return new ArrayList<Action>(history.getActions());
    }

    public ProvenanceRepository getProvenanceRepository() {
        return this.provenanceRepository;
    }

    public ProcessorStatus getProcessorStatus(String processorId, NiFiUser user) {
        ProcessorNode procNode = this.flowManager.getProcessorNode(processorId);
        if (procNode == null) {
            return null;
        }
        FlowFileEvent flowFileEvent = this.flowFileEventRepository.reportTransferEvents(processorId, System.currentTimeMillis());
        if (flowFileEvent == null) {
            flowFileEvent = EmptyFlowFileEvent.INSTANCE;
        }
        Predicate<Authorizable> authorizer = authorizable -> authorizable.isAuthorized(this.authorizer, RequestAction.READ, user);
        return this.getProcessorStatus(flowFileEvent, procNode, authorizer);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, NiFiUser user, int recursiveStatusDepth) {
        RepositoryStatusReport repoStatusReport = this.generateRepositoryStatusReport();
        return this.getGroupStatus(groupId, repoStatusReport, user, recursiveStatusDepth);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport, NiFiUser user) {
        ProcessGroup group = this.flowManager.getGroup(groupId);
        return this.getGroupStatus(group, statusReport, authorizable -> authorizable.isAuthorized(this.authorizer, RequestAction.READ, user), Integer.MAX_VALUE, 1, false);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, NiFiUser user) {
        RepositoryStatusReport repoStatusReport = this.generateRepositoryStatusReport();
        return this.getGroupStatus(groupId, repoStatusReport, user);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport, NiFiUser user, int recursiveStatusDepth) {
        ProcessGroup group = this.flowManager.getGroup(groupId);
        return this.getGroupStatus(group, statusReport, authorizable -> authorizable.isAuthorized(this.authorizer, RequestAction.READ, user), recursiveStatusDepth, 1, false);
    }

    public Map<String, StorageUsage> getProvenanceRepositoryStorageUsage() {
        Set provContainerNames = this.provenanceRepository.getContainerNames();
        LinkedHashMap<String, StorageUsage> provRepositoryUsage = new LinkedHashMap<String, StorageUsage>(provContainerNames.size());
        for (String containerName : provContainerNames) {
            long containerCapacity;
            long containerFree;
            try {
                containerFree = this.provenanceRepository.getContainerUsableSpace(containerName);
                containerCapacity = this.provenanceRepository.getContainerCapacity(containerName);
            }
            catch (IOException ioe) {
                containerFree = 0L;
                containerCapacity = -1L;
            }
            StorageUsage storageUsage = new StorageUsage();
            storageUsage.setIdentifier(containerName);
            storageUsage.setFreeSpace(containerFree);
            storageUsage.setTotalSpace(containerCapacity);
            provRepositoryUsage.put(containerName, storageUsage);
        }
        return provRepositoryUsage;
    }

    public Map<String, StorageUsage> getContentRepositoryStorageUsage() {
        Set containerNames = this.contentRepository.getContainerNames();
        LinkedHashMap<String, StorageUsage> fileRepositoryUsage = new LinkedHashMap<String, StorageUsage>(containerNames.size());
        for (String containerName : containerNames) {
            long containerCapacity;
            long containerFree;
            try {
                containerFree = this.contentRepository.getContainerUsableSpace(containerName);
                containerCapacity = this.contentRepository.getContainerCapacity(containerName);
            }
            catch (IOException ioe) {
                containerFree = 0L;
                containerCapacity = -1L;
            }
            StorageUsage storageUsage = new StorageUsage();
            storageUsage.setIdentifier(containerName);
            storageUsage.setFreeSpace(containerFree);
            storageUsage.setTotalSpace(containerCapacity);
            fileRepositoryUsage.put(containerName, storageUsage);
        }
        return fileRepositoryUsage;
    }

    public StorageUsage getFlowFileRepositoryStorageUsage() {
        StorageUsage flowFileRepoStorageUsage = new StorageUsage();
        flowFileRepoStorageUsage.setIdentifier("FlowFile Repository");
        try {
            flowFileRepoStorageUsage.setFreeSpace(this.flowFileRepository.getUsableStorageSpace());
            flowFileRepoStorageUsage.setTotalSpace(this.flowFileRepository.getStorageCapacity());
        }
        catch (IOException ioe) {
            flowFileRepoStorageUsage.setFreeSpace(0L);
            flowFileRepoStorageUsage.setTotalSpace(-1L);
        }
        return flowFileRepoStorageUsage;
    }
}

