/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.http.HttpTransportFactory;
import java.net.Proxy;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;

public class ProxyAwareTransportFactory
implements HttpTransportFactory {
    private static final HttpTransport DEFAULT_TRANSPORT = new NetHttpTransport();
    public static final ProxySpec[] PROXY_SPECS = new ProxySpec[]{ProxySpec.HTTP_AUTH};
    private final ProxyConfiguration proxyConfig;

    public ProxyAwareTransportFactory(ProxyConfiguration proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public HttpTransport create() {
        if (this.proxyConfig == null) {
            return DEFAULT_TRANSPORT;
        }
        Proxy proxy = this.proxyConfig.createProxy();
        if (Proxy.Type.HTTP.equals((Object)proxy.type()) && this.proxyConfig.hasCredential()) {
            String host = this.proxyConfig.getProxyServerHost();
            int port = this.proxyConfig.getProxyServerPort();
            HttpHost proxyHost = new HttpHost(host, port);
            DefaultHttpClient httpClient = new DefaultHttpClient();
            ConnRouteParams.setDefaultProxy((HttpParams)httpClient.getParams(), (HttpHost)proxyHost);
            if (this.proxyConfig.hasCredential()) {
                AuthScope proxyAuthScope = new AuthScope(host, port);
                UsernamePasswordCredentials proxyCredential = new UsernamePasswordCredentials(this.proxyConfig.getProxyUserName(), this.proxyConfig.getProxyUserPassword());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyCredential);
                httpClient.setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            return new ApacheHttpTransport((HttpClient)httpClient);
        }
        return new NetHttpTransport.Builder().setProxy(proxy).build();
    }
}

