/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.bigquery;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.AbstractGCPProcessor;
import org.apache.nifi.processors.gcp.ProxyAwareTransportFactory;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractBigQueryProcessor
extends AbstractGCPProcessor<BigQuery, BigQueryOptions> {
    static final int BUFFER_SIZE = 65536;
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to this relationship after a successful Google BigQuery operation.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles are routed to this relationship if the Google BigQuery operation fails.").build();
    public static final Set<Relationship> relationships = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));
    public static final PropertyDescriptor DATASET = new PropertyDescriptor.Builder().name("bq.dataset").displayName("Dataset").description("BigQuery dataset name (Note - The dataset must exist in GCP)").required(true).defaultValue("${bq.dataset}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor TABLE_NAME = new PropertyDescriptor.Builder().name("bq.table.name").displayName("Table Name").description("BigQuery table name").required(true).defaultValue("${bq.table.name}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_EL_VALIDATOR).build();
    public static final PropertyDescriptor TABLE_SCHEMA = new PropertyDescriptor.Builder().name("bq.table.schema").displayName("Table Schema").description("BigQuery schema in JSON format").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor READ_TIMEOUT = new PropertyDescriptor.Builder().name("bq.readtimeout").displayName("Read Timeout").description("Load Job Time Out").required(true).defaultValue("5 minutes").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).build();

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return ImmutableList.builder().addAll(super.getSupportedPropertyDescriptors()).add((Object)DATASET).add((Object)TABLE_NAME).add((Object)TABLE_SCHEMA).add((Object)READ_TIMEOUT).build();
    }

    @Override
    protected BigQueryOptions getServiceOptions(ProcessContext context, GoogleCredentials credentials) {
        String projectId = context.getProperty(PROJECT_ID).evaluateAttributeExpressions().getValue();
        Integer retryCount = Integer.valueOf(context.getProperty(RETRY_COUNT).getValue());
        BigQueryOptions.Builder builder = BigQueryOptions.newBuilder();
        if (!StringUtils.isBlank((String)projectId)) {
            builder.setProjectId(projectId);
        }
        return ((BigQueryOptions.Builder)((BigQueryOptions.Builder)builder.setCredentials((Credentials)credentials)).setRetrySettings(RetrySettings.newBuilder().setMaxAttempts(retryCount.intValue()).build())).setTransportOptions(this.getTransportOptions(context)).build();
    }

    protected final Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        Collection results = super.customValidate(validationContext);
        ProxyConfiguration.validateProxySpec((ValidationContext)validationContext, (Collection)results, (ProxySpec[])ProxyAwareTransportFactory.PROXY_SPECS);
        boolean projectId = validationContext.getProperty(PROJECT_ID).isSet();
        if (!projectId) {
            results.add(new ValidationResult.Builder().subject(PROJECT_ID.getName()).valid(false).explanation("The Project ID must be set for this processor.").build());
        }
        this.customValidate(validationContext, results);
        return results;
    }

    protected void customValidate(ValidationContext validationContext, Collection<ValidationResult> results) {
    }
}

