/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.storage;

import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.storage.AbstractGCSProcessor;
import org.apache.nifi.processors.gcp.storage.FetchGCSObject;
import org.apache.nifi.processors.gcp.storage.ListGCSBucket;
import org.apache.nifi.processors.gcp.storage.PutGCSObject;

@SupportsBatching
@Tags(value={"google cloud", "gcs", "google", "storage", "delete"})
@CapabilityDescription(value="Deletes objects from a Google Cloud Bucket. If attempting to delete a file that does not exist, FlowFile is routed to success.")
@SeeAlso(value={PutGCSObject.class, FetchGCSObject.class, ListGCSBucket.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class DeleteGCSObject
extends AbstractGCSProcessor {
    public static final PropertyDescriptor BUCKET = new PropertyDescriptor.Builder().name("gcs-bucket").displayName("Bucket").description("Bucket of the object.").required(true).defaultValue("${gcs.bucket}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("gcs-key").displayName("Key").description("Name of the object.").required(true).defaultValue("${filename}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor GENERATION = new PropertyDescriptor.Builder().name("gcs-generation").displayName("Generation").description("The generation of the object to be deleted. If null, will use latest version of the object.").addValidator(StandardValidators.POSITIVE_LONG_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return ImmutableList.builder().addAll(super.getSupportedPropertyDescriptors()).add((Object)BUCKET).add((Object)KEY).add((Object)GENERATION).build();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        String bucket = context.getProperty(BUCKET).evaluateAttributeExpressions(flowFile).getValue();
        String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        Long generation = context.getProperty(GENERATION).evaluateAttributeExpressions(flowFile).asLong();
        Storage storage = (Storage)this.getCloudService();
        try {
            storage.delete(BlobId.of((String)bucket, (String)key, (Long)generation));
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
            return;
        }
        session.transfer(flowFile, REL_SUCCESS);
        long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
        this.getLogger().info("Successfully deleted GCS Object for {} in {} millis; routing to success", new Object[]{flowFile, millis});
    }
}

