/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.gcp.storage;

import com.google.cloud.storage.Acl;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.collect.ImmutableList;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.ReadsAttributes;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.gcp.storage.AbstractGCSProcessor;
import org.apache.nifi.processors.gcp.storage.DeleteGCSObject;
import org.apache.nifi.processors.gcp.storage.FetchGCSObject;
import org.apache.nifi.processors.gcp.storage.ListGCSBucket;
import org.apache.nifi.processors.gcp.storage.Util;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"google", "google cloud", "gcs", "archive", "put"})
@CapabilityDescription(value="Puts flow files to a Google Cloud Bucket.")
@SeeAlso(value={FetchGCSObject.class, DeleteGCSObject.class, ListGCSBucket.class})
@DynamicProperty(name="The name of a User-Defined Metadata field to add to the GCS Object", value="The value of a User-Defined Metadata field to add to the GCS Object", description="Allows user-defined metadata to be added to the GCS object as key/value pairs", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES)
@ReadsAttributes(value={@ReadsAttribute(attribute="filename", description="Uses the FlowFile's filename as the filename for the GCS object"), @ReadsAttribute(attribute="mime.type", description="Uses the FlowFile's MIME type as the content-type for the GCS object")})
@WritesAttributes(value={@WritesAttribute(attribute="gcs.bucket", description="Bucket of the object."), @WritesAttribute(attribute="gcs.key", description="Name of the object."), @WritesAttribute(attribute="gcs.size", description="Size of the object."), @WritesAttribute(attribute="gcs.cache.control", description="Data cache control of the object."), @WritesAttribute(attribute="gcs.component.count", description="The number of components which make up the object."), @WritesAttribute(attribute="gcs.content.disposition", description="The data content disposition of the object."), @WritesAttribute(attribute="gcs.content.encoding", description="The content encoding of the object."), @WritesAttribute(attribute="gcs.content.language", description="The content language of the object."), @WritesAttribute(attribute="mime.type", description="The MIME/Content-Type of the object"), @WritesAttribute(attribute="gcs.crc32c", description="The CRC32C checksum of object's data, encoded in base64 in big-endian order."), @WritesAttribute(attribute="gcs.create.time", description="The creation time of the object (milliseconds)"), @WritesAttribute(attribute="gcs.update.time", description="The last modification time of the object (milliseconds)"), @WritesAttribute(attribute="gcs.encryption.algorithm", description="The algorithm used to encrypt the object."), @WritesAttribute(attribute="gcs.encryption.sha256", description="The SHA256 hash of the key used to encrypt the object"), @WritesAttribute(attribute="gcs.etag", description="The HTTP 1.1 Entity tag for the object."), @WritesAttribute(attribute="gcs.generated.id", description="The service-generated for the object"), @WritesAttribute(attribute="gcs.generation", description="The data generation of the object."), @WritesAttribute(attribute="gcs.md5", description="The MD5 hash of the object's data encoded in base64."), @WritesAttribute(attribute="gcs.media.link", description="The media download link to the object."), @WritesAttribute(attribute="gcs.metageneration", description="The metageneration of the object."), @WritesAttribute(attribute="gcs.owner", description="The owner (uploader) of the object."), @WritesAttribute(attribute="gcs.owner.type", description="The ACL entity type of the uploader of the object."), @WritesAttribute(attribute="gcs.uri", description="The URI of the object as a string.")})
public class PutGCSObject
extends AbstractGCSProcessor {
    public static final PropertyDescriptor BUCKET = new PropertyDescriptor.Builder().name("gcs-bucket").displayName("Bucket").description("Bucket of the object.").required(true).defaultValue("${gcs.bucket}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor KEY = new PropertyDescriptor.Builder().name("gcs-key").displayName("Key").description("Name of the object.").required(true).defaultValue("${filename}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONTENT_TYPE = new PropertyDescriptor.Builder().name("gcs-content-type").displayName("Content Type").description("Content Type for the file, i.e. text/plain").defaultValue("${mime.type}").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MD5 = new PropertyDescriptor.Builder().name("gcs-object-md5").displayName("MD5 Hash").description("MD5 Hash (encoded in Base64) of the file for server-side validation.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CRC32C = new PropertyDescriptor.Builder().name("gcs-object-crc32c").displayName("CRC32C Checksum").description("CRC32C Checksum (encoded in Base64, big-Endian order) of the file for server-side validation.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final AllowableValue ACL_ALL_AUTHENTICATED_USERS = new AllowableValue(Storage.PredefinedAcl.ALL_AUTHENTICATED_USERS.name(), "All Authenticated Users", "Gives the bucket or object owner OWNER permission, and gives all authenticated Google account holders READER and WRITER permissions. All other permissions are removed.");
    public static final AllowableValue ACL_AUTHENTICATED_READ = new AllowableValue(Storage.PredefinedAcl.AUTHENTICATED_READ.name(), "Authenticated Read", "Gives the bucket or object owner OWNER permission, and gives all authenticated Google account holders READER permission. All other permissions are removed.");
    public static final AllowableValue ACL_BUCKET_OWNER_FULL_CONTROL = new AllowableValue(Storage.PredefinedAcl.BUCKET_OWNER_FULL_CONTROL.name(), "Bucket Owner Full Control", "Gives the object and bucket owners OWNER permission. All other permissions are removed.");
    public static final AllowableValue ACL_BUCKET_OWNER_READ = new AllowableValue(Storage.PredefinedAcl.BUCKET_OWNER_READ.name(), "Bucket Owner Read Only", "Gives the object owner OWNER permission, and gives the bucket owner READER permission. All other permissions are removed.");
    public static final AllowableValue ACL_PRIVATE = new AllowableValue(Storage.PredefinedAcl.PRIVATE.name(), "Private", "Gives the bucket or object owner OWNER permission for a bucket or object, and removes all other access permissions.");
    public static final AllowableValue ACL_PROJECT_PRIVATE = new AllowableValue(Storage.PredefinedAcl.PROJECT_PRIVATE.name(), "Project Private", "Gives permission to the project team based on their roles. Anyone who is part of the team has READER permission. Project owners and project editors have OWNER permission. This is the default ACL for newly created buckets. This is also the default ACL for newly created objects unless the default object ACL for that bucket has been changed.");
    public static final AllowableValue ACL_PUBLIC_READ = new AllowableValue(Storage.PredefinedAcl.PUBLIC_READ.name(), "Public Read Only", "Gives the bucket or object owner OWNER permission, and gives all users, both authenticated and anonymous, READER permission. When you apply this to an object, anyone on the Internet can read the object without authenticating.");
    public static final PropertyDescriptor ACL = new PropertyDescriptor.Builder().name("gcs-object-acl").displayName("Object ACL").description("Access Control to be attached to the object uploaded. Not providing this will revert to bucket defaults.").required(false).allowableValues(new AllowableValue[]{ACL_ALL_AUTHENTICATED_USERS, ACL_AUTHENTICATED_READ, ACL_BUCKET_OWNER_FULL_CONTROL, ACL_BUCKET_OWNER_READ, ACL_PRIVATE, ACL_PROJECT_PRIVATE, ACL_PUBLIC_READ}).build();
    public static final PropertyDescriptor ENCRYPTION_KEY = new PropertyDescriptor.Builder().name("gcs-server-side-encryption-key").displayName("Server Side Encryption Key").description("An AES256 Encryption Key (encoded in base64) for server-side encryption of the object.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).sensitive(true).build();
    public static final PropertyDescriptor OVERWRITE = new PropertyDescriptor.Builder().name("gcs-overwrite-object").displayName("Overwrite Object").description("If false, the upload to GCS will succeed only if the object does not exist.").required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("true").build();
    public static final AllowableValue CD_INLINE = new AllowableValue("inline", "Inline", "Indicates that the object should be loaded and rendered within the browser.");
    public static final AllowableValue CD_ATTACHMENT = new AllowableValue("attachment", "Attachment", "Indicates that the object should be saved (using a Save As... dialog) rather than opened directly within the browser");
    public static final PropertyDescriptor CONTENT_DISPOSITION_TYPE = new PropertyDescriptor.Builder().name("gcs-content-disposition-type").displayName("Content Disposition Type").description("Type of RFC-6266 Content Disposition to be attached to the object").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).allowableValues(new AllowableValue[]{CD_INLINE, CD_ATTACHMENT}).build();

    @Override
    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return ImmutableList.builder().addAll(super.getSupportedPropertyDescriptors()).add((Object)BUCKET).add((Object)KEY).add((Object)CONTENT_TYPE).add((Object)MD5).add((Object)CRC32C).add((Object)ACL).add((Object)ENCRYPTION_KEY).add((Object)OVERWRITE).add((Object)CONTENT_DISPOSITION_TYPE).build();
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    public void onTrigger(final ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        long startNanos = System.nanoTime();
        final String bucket = context.getProperty(BUCKET).evaluateAttributeExpressions(flowFile).getValue();
        final String key = context.getProperty(KEY).evaluateAttributeExpressions(flowFile).getValue();
        final boolean overwrite = context.getProperty(OVERWRITE).asBoolean();
        final FlowFile ff = flowFile;
        final String ffFilename = (String)ff.getAttributes().get(CoreAttributes.FILENAME.key());
        final HashMap attributes = new HashMap();
        try {
            final Storage storage = (Storage)this.getCloudService();
            session.read(flowFile, new InputStreamCallback(){

                public void process(InputStream rawIn) throws IOException {
                    try (BufferedInputStream in = new BufferedInputStream(rawIn);){
                        String encryptionKey;
                        String acl;
                        String crc32c;
                        String md5;
                        String contentType;
                        String contentDispositionType;
                        BlobId id = BlobId.of((String)bucket, (String)key);
                        BlobInfo.Builder blobInfoBuilder = BlobInfo.newBuilder((BlobId)id);
                        ArrayList<Storage.BlobWriteOption> blobWriteOptions = new ArrayList<Storage.BlobWriteOption>();
                        if (!overwrite) {
                            blobWriteOptions.add(Storage.BlobWriteOption.doesNotExist());
                        }
                        if ((contentDispositionType = context.getProperty(CONTENT_DISPOSITION_TYPE).getValue()) != null) {
                            blobInfoBuilder.setContentDisposition(contentDispositionType + "; filename=" + ffFilename);
                        }
                        if ((contentType = context.getProperty(CONTENT_TYPE).evaluateAttributeExpressions(ff).getValue()) != null) {
                            blobInfoBuilder.setContentType(contentType);
                        }
                        if ((md5 = context.getProperty(MD5).evaluateAttributeExpressions(ff).getValue()) != null) {
                            blobInfoBuilder.setMd5(md5);
                            blobWriteOptions.add(Storage.BlobWriteOption.md5Match());
                        }
                        if ((crc32c = context.getProperty(CRC32C).evaluateAttributeExpressions(ff).getValue()) != null) {
                            blobInfoBuilder.setCrc32c(crc32c);
                            blobWriteOptions.add(Storage.BlobWriteOption.crc32cMatch());
                        }
                        if ((acl = context.getProperty(ACL).getValue()) != null) {
                            blobWriteOptions.add(Storage.BlobWriteOption.predefinedAcl((Storage.PredefinedAcl)Storage.PredefinedAcl.valueOf((String)acl)));
                        }
                        if ((encryptionKey = context.getProperty(ENCRYPTION_KEY).evaluateAttributeExpressions(ff).getValue()) != null) {
                            blobWriteOptions.add(Storage.BlobWriteOption.encryptionKey((String)encryptionKey));
                        }
                        HashMap<String, String> userMetadata = new HashMap<String, String>();
                        for (Map.Entry entry : context.getProperties().entrySet()) {
                            if (!((PropertyDescriptor)entry.getKey()).isDynamic()) continue;
                            String value = context.getProperty((PropertyDescriptor)entry.getKey()).evaluateAttributeExpressions(ff).getValue();
                            userMetadata.put(((PropertyDescriptor)entry.getKey()).getName(), value);
                        }
                        if (!userMetadata.isEmpty()) {
                            blobInfoBuilder.setMetadata(userMetadata);
                        }
                        try {
                            Blob blob = storage.create(blobInfoBuilder.build(), (InputStream)in, blobWriteOptions.toArray(new Storage.BlobWriteOption[blobWriteOptions.size()]));
                            attributes.put("gcs.bucket", blob.getBucket());
                            attributes.put("gcs.key", blob.getName());
                            if (blob.getSize() != null) {
                                attributes.put("gcs.size", String.valueOf(blob.getSize()));
                            }
                            if (blob.getCacheControl() != null) {
                                attributes.put("gcs.cache.control", blob.getCacheControl());
                            }
                            if (blob.getComponentCount() != null) {
                                attributes.put("gcs.component.count", String.valueOf(blob.getComponentCount()));
                            }
                            if (blob.getContentDisposition() != null) {
                                attributes.put("gcs.content.disposition", blob.getContentDisposition());
                                Util.ParsedContentDisposition parsed = Util.parseContentDisposition(blob.getContentDisposition());
                                if (parsed != null) {
                                    attributes.put(CoreAttributes.FILENAME.key(), parsed.getFileName());
                                }
                            }
                            if (blob.getContentEncoding() != null) {
                                attributes.put("gcs.content.encoding", blob.getContentEncoding());
                            }
                            if (blob.getContentLanguage() != null) {
                                attributes.put("gcs.content.language", blob.getContentLanguage());
                            }
                            if (blob.getContentType() != null) {
                                attributes.put(CoreAttributes.MIME_TYPE.key(), blob.getContentType());
                            }
                            if (blob.getCrc32c() != null) {
                                attributes.put("gcs.crc32c", blob.getCrc32c());
                            }
                            if (blob.getCustomerEncryption() != null) {
                                BlobInfo.CustomerEncryption encryption = blob.getCustomerEncryption();
                                attributes.put("gcs.encryption.algorithm", encryption.getEncryptionAlgorithm());
                                attributes.put("gcs.encryption.sha256", encryption.getKeySha256());
                            }
                            if (blob.getEtag() != null) {
                                attributes.put("gcs.etag", blob.getEtag());
                            }
                            if (blob.getGeneratedId() != null) {
                                attributes.put("gcs.generated.id", blob.getGeneratedId());
                            }
                            if (blob.getGeneration() != null) {
                                attributes.put("gcs.generation", String.valueOf(blob.getGeneration()));
                            }
                            if (blob.getMd5() != null) {
                                attributes.put("gcs.md5", blob.getMd5());
                            }
                            if (blob.getMediaLink() != null) {
                                attributes.put("gcs.media.link", blob.getMediaLink());
                            }
                            if (blob.getMetageneration() != null) {
                                attributes.put("gcs.metageneration", String.valueOf(blob.getMetageneration()));
                            }
                            if (blob.getOwner() != null) {
                                Acl.Entity entity = blob.getOwner();
                                if (entity instanceof Acl.User) {
                                    attributes.put("gcs.owner", ((Acl.User)entity).getEmail());
                                    attributes.put("gcs.owner.type", "user");
                                } else if (entity instanceof Acl.Group) {
                                    attributes.put("gcs.owner", ((Acl.Group)entity).getEmail());
                                    attributes.put("gcs.owner.type", "group");
                                } else if (entity instanceof Acl.Domain) {
                                    attributes.put("gcs.owner", ((Acl.Domain)entity).getDomain());
                                    attributes.put("gcs.owner.type", "domain");
                                } else if (entity instanceof Acl.Project) {
                                    attributes.put("gcs.owner", ((Acl.Project)entity).getProjectId());
                                    attributes.put("gcs.owner.type", "project");
                                }
                            }
                            if (blob.getSelfLink() != null) {
                                attributes.put("gcs.uri", blob.getSelfLink());
                            }
                            if (blob.getCreateTime() != null) {
                                attributes.put("gcs.create.time", String.valueOf(blob.getCreateTime()));
                            }
                            if (blob.getUpdateTime() != null) {
                                attributes.put("gcs.update.time", String.valueOf(blob.getUpdateTime()));
                            }
                        }
                        catch (StorageException e) {
                            PutGCSObject.this.getLogger().error("Failure completing upload flowfile={} bucket={} key={} reason={}", new Object[]{ffFilename, bucket, key, e.getMessage()}, (Throwable)e);
                            throw e;
                        }
                    }
                }
            });
            if (!attributes.isEmpty()) {
                flowFile = session.putAllAttributes(flowFile, attributes);
            }
            session.transfer(flowFile, REL_SUCCESS);
            long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            String url = "https://" + bucket + ".storage.googleapis.com/" + key;
            session.getProvenanceReporter().send(flowFile, url, millis);
            this.getLogger().info("Successfully put {} to Google Cloud Storage in {} milliseconds", new Object[]{ff, millis});
        }
        catch (StorageException | ProcessException e) {
            this.getLogger().error("Failed to put {} to Google Cloud Storage due to {}", new Object[]{flowFile, e.getMessage()}, e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }
}

