/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.groovyx.util;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class Files {
    public static Set<File> listPathsFiles(String classpath) {
        if (classpath == null || classpath.length() == 0) {
            return Collections.emptySet();
        }
        HashSet<File> files = new HashSet<File>();
        for (String cp : classpath.split("\\s*;\\s*")) {
            files.addAll(Files.listPathFiles(cp));
        }
        return files;
    }

    public static List<File> listPathFiles(String path) {
        File f = new File(path);
        String fname = f.getName();
        if (fname.contains("?") || fname.contains("*")) {
            Pattern pattern = Pattern.compile(fname.replace(".", "\\.").replace("?", ".?").replace("*", ".*?"));
            File[] list = f.getParentFile().listFiles((dir, name) -> pattern.matcher(name).find());
            return list == null ? Collections.emptyList() : Arrays.asList(list);
        }
        if (!f.exists()) {
            System.err.println("WARN: path not found for: " + f);
        }
        return Arrays.asList(f);
    }
}

