/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.groovyx.util;

import java.io.File;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class Validators {
    public static Validator createFileExistsAndReadableValidator() {
        return (subject, input, context) -> {
            String substituted;
            try {
                substituted = context.newPropertyValue(input).evaluateAttributeExpressions().getValue();
            }
            catch (Exception e) {
                return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation("Not a valid Expression Language value: " + e.getMessage()).build();
            }
            File file = new File(substituted);
            boolean valid = file.exists() && file.canRead();
            String explanation = valid ? null : "File " + file + " does not exist or cannot be read";
            return new ValidationResult.Builder().subject(subject).input(input).valid(valid).explanation(explanation).build();
        };
    }
}

