/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.dbcp;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.dbcp.AbstractDBCPConnectionPool;
import org.apache.nifi.dbcp.ValidationResources;
import org.apache.nifi.dbcp.utils.DBCPProperties;
import org.apache.nifi.dbcp.utils.DataSourceConfiguration;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hadoop.KerberosProperties;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.kerberos.KerberosUserService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.krb.KerberosKeytabUser;
import org.apache.nifi.security.krb.KerberosLoginException;
import org.apache.nifi.security.krb.KerberosPasswordUser;
import org.apache.nifi.security.krb.KerberosUser;

@RequiresInstanceClassLoading
@Tags(value={"dbcp", "jdbc", "database", "connection", "pooling", "store", "hadoop"})
@CapabilityDescription(value="Provides a Database Connection Pooling Service for Hadoop related JDBC services. This service requires that the Database Driver Location(s) contains some version of a hadoop-common JAR, or a shaded JAR that shades hadoop-common.")
@DynamicProperty(name="The name of a Hadoop configuration property.", value="The value of the given Hadoop configuration property.", description="These properties will be set on the Hadoop configuration after loading any provided configuration files.", expressionLanguageScope=ExpressionLanguageScope.ENVIRONMENT)
@Restricted(restrictions={@Restriction(requiredPermission=RequiredPermission.REFERENCE_REMOTE_RESOURCES, explanation="Database Driver Location can reference resources over HTTP")})
public class HadoopDBCPConnectionPool
extends AbstractDBCPConnectionPool {
    private static final String ALLOW_EXPLICIT_KEYTAB = "NIFI_ALLOW_EXPLICIT_KEYTAB";
    private static final String HADOOP_CONFIGURATION_CLASS = "org.apache.hadoop.conf.Configuration";
    private static final String HADOOP_UGI_CLASS = "org.apache.hadoop.security.UserGroupInformation";
    public static final PropertyDescriptor DB_DRIVER_LOCATION = new PropertyDescriptor.Builder().fromPropertyDescriptor(DBCPProperties.DB_DRIVER_LOCATION).description("Comma-separated list of files/folders and/or URLs containing the driver JAR and its dependencies. For example '/var/tmp/phoenix-client.jar'. NOTE: It is required that the resources specified by this property provide the classes from hadoop-common, such as Configuration and UserGroupInformation.").required(true).build();
    public static final PropertyDescriptor HADOOP_CONFIGURATION_RESOURCES = new PropertyDescriptor.Builder().name("hadoop-config-resources").displayName("Hadoop Configuration Resources").description("A file, or comma separated list of files, which contain the Hadoop configuration (core-site.xml, etc.). Without this, Hadoop will search the classpath, or will revert to a default configuration. Note that to enable authentication with Kerberos, the appropriate properties must be set in the configuration files.").required(false).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamicallyModifiesClasspath(true).build();
    public static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    private KerberosProperties kerberosProperties;
    private List<PropertyDescriptor> properties;
    private volatile UserGroupInformation ugi;
    private volatile Boolean foundHadoopDependencies;
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference<Object>(null);

    protected void init(ControllerServiceInitializationContext context) {
        File kerberosConfigFile = context.getKerberosConfigurationFile();
        this.kerberosProperties = this.getKerberosProperties(kerberosConfigFile);
        this.properties = Arrays.asList(DBCPProperties.DATABASE_URL, DBCPProperties.DB_DRIVERNAME, DB_DRIVER_LOCATION, HADOOP_CONFIGURATION_RESOURCES, DBCPProperties.KERBEROS_USER_SERVICE, KERBEROS_CREDENTIALS_SERVICE, this.kerberosProperties.getKerberosPrincipal(), this.kerberosProperties.getKerberosKeytab(), this.kerberosProperties.getKerberosPassword(), DBCPProperties.DB_USER, DBCPProperties.DB_PASSWORD, DBCPProperties.MAX_WAIT_TIME, DBCPProperties.MAX_TOTAL_CONNECTIONS, DBCPProperties.VALIDATION_QUERY, DBCPProperties.MIN_IDLE, DBCPProperties.MAX_IDLE, DBCPProperties.MAX_CONN_LIFETIME, DBCPProperties.EVICTION_RUN_PERIOD, DBCPProperties.MIN_EVICTABLE_IDLE_TIME, DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME);
    }

    protected KerberosProperties getKerberosProperties(File kerberosConfigFile) {
        return new KerberosProperties(kerberosConfigFile);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        String resolvedKeytab;
        String resolvedPrincipal;
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        if (this.foundHadoopDependencies == null) {
            ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            try {
                Class.forName(HADOOP_CONFIGURATION_CLASS, true, classLoader);
                Class.forName(HADOOP_UGI_CLASS, true, classLoader);
                this.foundHadoopDependencies = true;
            }
            catch (ClassNotFoundException cnf) {
                this.getLogger().debug(cnf.getMessage(), (Throwable)cnf);
                this.foundHadoopDependencies = false;
            }
        }
        if (!this.foundHadoopDependencies.booleanValue()) {
            problems.add(new ValidationResult.Builder().subject(DB_DRIVER_LOCATION.getDisplayName()).valid(false).explanation("required Hadoop classes were not found in any of the specified resources, please ensure that hadoop-common is available").build());
            return problems;
        }
        String explicitPrincipal = validationContext.getProperty(this.kerberosProperties.getKerberosPrincipal()).evaluateAttributeExpressions().getValue();
        String explicitKeytab = validationContext.getProperty(this.kerberosProperties.getKerberosKeytab()).evaluateAttributeExpressions().getValue();
        String explicitPassword = validationContext.getProperty(this.kerberosProperties.getKerberosPassword()).getValue();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)validationContext.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        KerberosUserService kerberosUserService = (KerberosUserService)validationContext.getProperty(DBCPProperties.KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
        if (credentialsService == null) {
            resolvedPrincipal = explicitPrincipal;
            resolvedKeytab = explicitKeytab;
        } else {
            resolvedPrincipal = credentialsService.getPrincipal();
            resolvedKeytab = credentialsService.getKeytab();
        }
        boolean confFileProvided = validationContext.getProperty(HADOOP_CONFIGURATION_RESOURCES).isSet();
        if (confFileProvided) {
            String configFiles = validationContext.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
            ValidationResources resources = this.validationResourceHolder.get();
            if (resources == null || !configFiles.equals(resources.getConfigResources())) {
                this.getLogger().debug("Reloading validation resources");
                resources = new ValidationResources(configFiles, this.getConfigurationFromFiles(configFiles));
                this.validationResourceHolder.set(resources);
            }
            Configuration hadoopConfig = resources.getConfiguration();
            if (kerberosUserService == null) {
                problems.addAll(KerberosProperties.validatePrincipalWithKeytabOrPassword((String)((Object)((Object)this)).getClass().getSimpleName(), (Configuration)hadoopConfig, (String)resolvedPrincipal, (String)resolvedKeytab, (String)explicitPassword, (ComponentLog)this.getLogger()));
            } else {
                boolean securityEnabled = SecurityUtil.isSecurityEnabled((Configuration)hadoopConfig);
                if (!securityEnabled) {
                    this.getLogger().warn("Hadoop Configuration does not have security enabled, KerberosUserService will be ignored");
                }
            }
        }
        if (credentialsService != null && (explicitPrincipal != null || explicitKeytab != null || explicitPassword != null)) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("Cannot specify a Kerberos Credentials Service while also specifying a Kerberos Principal, Kerberos Keytab, or Kerberos Password").build());
        }
        if (kerberosUserService != null && (explicitPrincipal != null || explicitKeytab != null || explicitPassword != null)) {
            problems.add(new ValidationResult.Builder().subject("Kerberos User").valid(false).explanation("Cannot specify a Kerberos User Service while also specifying a Kerberos Principal, Kerberos Keytab, or Kerberos Password").build());
        }
        if (kerberosUserService != null && credentialsService != null) {
            problems.add(new ValidationResult.Builder().subject("Kerberos User").valid(false).explanation("Cannot specify a Kerberos User Service while also specifying a Kerberos Credentials Service").build());
        }
        if (!this.isAllowExplicitKeytab() && explicitKeytab != null) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("The 'NIFI_ALLOW_EXPLICIT_KEYTAB' system environment variable is configured to forbid explicitly configuring Kerberos Keytab in processors. The Kerberos Credentials Service should be used instead of setting the Kerberos Keytab or Kerberos Principal property.").build());
        }
        return problems;
    }

    protected Configuration getConfigurationFromFiles(String configFiles) {
        Configuration conf = new Configuration();
        if (StringUtils.isNotBlank((CharSequence)configFiles)) {
            for (String configFile : configFiles.split(",")) {
                conf.addResource(new Path(configFile.trim()));
            }
        }
        return conf;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws IOException {
        String configFiles = context.getProperty(HADOOP_CONFIGURATION_RESOURCES).evaluateAttributeExpressions().getValue();
        Configuration hadoopConfig = this.getConfigurationFromFiles(configFiles);
        for (Map.Entry entry : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (!descriptor.isDynamic()) continue;
            hadoopConfig.set(descriptor.getName(), context.getProperty(descriptor).evaluateAttributeExpressions().getValue());
        }
        if (SecurityUtil.isSecurityEnabled((Configuration)hadoopConfig)) {
            String resolvedKeytab;
            String resolvedPrincipal;
            String explicitPrincipal = context.getProperty(this.kerberosProperties.getKerberosPrincipal()).evaluateAttributeExpressions().getValue();
            String explicitKeytab = context.getProperty(this.kerberosProperties.getKerberosKeytab()).evaluateAttributeExpressions().getValue();
            String explicitPassword = context.getProperty(this.kerberosProperties.getKerberosPassword()).getValue();
            KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
            if (credentialsService != null) {
                resolvedPrincipal = credentialsService.getPrincipal();
                resolvedKeytab = credentialsService.getKeytab();
            } else {
                resolvedPrincipal = explicitPrincipal;
                resolvedKeytab = explicitKeytab;
            }
            if (resolvedKeytab != null) {
                this.kerberosUser = new KerberosKeytabUser(resolvedPrincipal, resolvedKeytab);
                this.getLogger().info("Security Enabled, logging in as principal {} with keytab {}", new Object[]{resolvedPrincipal, resolvedKeytab});
            } else if (explicitPassword != null) {
                this.kerberosUser = new KerberosPasswordUser(resolvedPrincipal, explicitPassword);
                this.getLogger().info("Security Enabled, logging in as principal {} with password", new Object[]{resolvedPrincipal});
            } else {
                throw new IOException("Unable to authenticate with Kerberos, no keytab or password was provided");
            }
            this.ugi = SecurityUtil.getUgiForKerberosUser((Configuration)hadoopConfig, (KerberosUser)this.kerberosUser);
            this.getLogger().info("Successfully logged in as principal {}", new Object[]{resolvedPrincipal});
        } else {
            this.getLogger().info("Simple Authentication");
        }
    }

    @OnDisabled
    public void shutdown() throws SQLException {
        try {
            if (this.kerberosUser != null) {
                this.kerberosUser.logout();
            }
        }
        finally {
            this.validationResourceHolder.set(null);
            this.foundHadoopDependencies = null;
            this.kerberosUser = null;
            this.ugi = null;
            try {
                if (this.dataSource != null) {
                    this.dataSource.close();
                }
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    protected Driver getDriver(String driverName, String url) {
        Class<?> clazz;
        try {
            clazz = Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            throw new ProcessException("Driver class " + driverName + " is not found", (Throwable)e);
        }
        try {
            return DriverManager.getDriver(url);
        }
        catch (SQLException e) {
            try {
                Driver driver = (Driver)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DriverManager.registerDriver(driver);
                return DriverManager.getDriver(url);
            }
            catch (SQLException e2) {
                throw new ProcessException("No suitable driver for the given Database Connection URL", (Throwable)e2);
            }
            catch (Exception e2) {
                throw new ProcessException("Creating driver instance is failed", (Throwable)e2);
            }
        }
    }

    protected DataSourceConfiguration getDataSourceConfiguration(ConfigurationContext context) {
        String url = context.getProperty(DBCPProperties.DATABASE_URL).evaluateAttributeExpressions().getValue();
        String driverName = context.getProperty(DBCPProperties.DB_DRIVERNAME).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DBCPProperties.DB_USER).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(DBCPProperties.DB_PASSWORD).evaluateAttributeExpressions().getValue();
        Integer maxTotal = context.getProperty(DBCPProperties.MAX_TOTAL_CONNECTIONS).evaluateAttributeExpressions().asInteger();
        String validationQuery = context.getProperty(DBCPProperties.VALIDATION_QUERY).evaluateAttributeExpressions().getValue();
        Long maxWaitMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_WAIT_TIME).evaluateAttributeExpressions());
        Integer minIdle = context.getProperty(DBCPProperties.MIN_IDLE).evaluateAttributeExpressions().asInteger();
        Integer maxIdle = context.getProperty(DBCPProperties.MAX_IDLE).evaluateAttributeExpressions().asInteger();
        Long maxConnLifetimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MAX_CONN_LIFETIME).evaluateAttributeExpressions());
        Long timeBetweenEvictionRunsMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.EVICTION_RUN_PERIOD).evaluateAttributeExpressions());
        Long minEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        Long softMinEvictableIdleTimeMillis = DBCPProperties.extractMillisWithInfinite((PropertyValue)context.getProperty(DBCPProperties.SOFT_MIN_EVICTABLE_IDLE_TIME).evaluateAttributeExpressions());
        return new DataSourceConfiguration.Builder(url, driverName, user, password).validationQuery(validationQuery).maxWaitMillis(maxWaitMillis.longValue()).maxTotal(maxTotal.intValue()).minIdle(minIdle.intValue()).maxIdle(maxIdle.intValue()).maxConnLifetimeMillis(maxConnLifetimeMillis.longValue()).timeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue()).minEvictableIdleTimeMillis(minEvictableIdleTimeMillis.longValue()).softMinEvictableIdleTimeMillis(softMinEvictableIdleTimeMillis.longValue()).build();
    }

    public Connection getConnection() throws ProcessException {
        try {
            if (this.ugi != null) {
                this.getLogger().trace("getting UGI instance");
                if (this.kerberosUser != null) {
                    this.getLogger().debug("kerberosUser is {}", new Object[]{this.kerberosUser});
                    try {
                        this.getLogger().debug("checking TGT on kerberosUser {}", new Object[]{this.kerberosUser});
                        this.kerberosUser.checkTGTAndRelogin();
                    }
                    catch (KerberosLoginException e) {
                        throw new ProcessException("Unable to relogin with kerberos credentials for " + this.kerberosUser.getPrincipal(), (Throwable)e);
                    }
                } else {
                    this.getLogger().debug("kerberosUser was null, will not refresh TGT with KerberosUser");
                    this.ugi.checkTGTAndReloginFromKeytab();
                }
                try {
                    return (Connection)this.ugi.doAs(() -> this.dataSource.getConnection());
                }
                catch (UndeclaredThrowableException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof SQLException) {
                        throw (SQLException)cause;
                    }
                    throw e;
                }
            }
            this.getLogger().info("Simple Authentication");
            return this.dataSource.getConnection();
        }
        catch (IOException | InterruptedException | SQLException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    public String toString() {
        return "HadoopDBCPConnectionPool[id=" + this.getIdentifier() + "]";
    }

    boolean isAllowExplicitKeytab() {
        return Boolean.parseBoolean(System.getenv(ALLOW_EXPLICIT_KEYTAB));
    }
}

