/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.util.StringUtils;

public interface VisibilityFetchSupport {
    public static final PropertyDescriptor AUTHORIZATIONS = new PropertyDescriptor.Builder().name("hbase-fetch-row-authorizations").displayName("Authorizations").description("The list of authorizations to pass to the scanner. This will be ignored if cell visibility labels are not in use.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(Validator.VALID).build();

    default public List<String> getAuthorizations(ProcessContext context, FlowFile flowFile) {
        String authorizationString = context.getProperty(AUTHORIZATIONS).isSet() ? context.getProperty(AUTHORIZATIONS).evaluateAttributeExpressions(flowFile).getValue().trim() : "";
        ArrayList<String> authorizations = new ArrayList<String>();
        if (!StringUtils.isBlank((String)authorizationString)) {
            String[] parts;
            for (String part : parts = authorizationString.split(",")) {
                authorizations.add(part.trim());
            }
        }
        return authorizations;
    }
}

