/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.util.StringUtils;

class VisibilityLabelUtils {
    static final PropertyDescriptor AUTHORIZATIONS = new PropertyDescriptor.Builder().name("hb-lu-authorizations").displayName("Authorizations").description("The list of authorization tokens to be used with cell visibility if it is enabled. These will be used to override the default authorization list for the user accessing HBase.").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();

    VisibilityLabelUtils() {
    }

    static List<String> getAuthorizations(ConfigurationContext context) {
        String authorizationString;
        List<String> tokens = new ArrayList<String>();
        String string = authorizationString = context.getProperty(AUTHORIZATIONS).isSet() ? context.getProperty(AUTHORIZATIONS).getValue() : "";
        if (!StringUtils.isEmpty((String)authorizationString)) {
            tokens = Arrays.asList(authorizationString.split(",[\\s]*"));
        }
        return tokens;
    }
}

