/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.distributed.cache.client.Deserializer;
import org.apache.nifi.distributed.cache.client.DistributedMapCacheClient;
import org.apache.nifi.distributed.cache.client.Serializer;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hbase.HBaseClientService;
import org.apache.nifi.hbase.VisibilityLabelUtils;
import org.apache.nifi.hbase.put.PutColumn;
import org.apache.nifi.hbase.scan.ResultCell;
import org.apache.nifi.hbase.scan.ResultHandler;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;

@Tags(value={"distributed", "cache", "state", "map", "cluster", "hbase"})
@SeeAlso(classNames={"org.apache.nifi.hbase.HBase_2_ClientService"})
@CapabilityDescription(value="Provides the ability to use an HBase table as a cache, in place of a DistributedMapCache. Uses a HBase_2_ClientService controller to communicate with HBase.")
public class HBase_2_ClientMapCacheService
extends AbstractControllerService
implements DistributedMapCacheClient {
    static final PropertyDescriptor HBASE_CLIENT_SERVICE = new PropertyDescriptor.Builder().name("HBase Client Service").description("Specifies the HBase Client Controller Service to use for accessing HBase.").required(true).identifiesControllerService(HBaseClientService.class).build();
    public static final PropertyDescriptor HBASE_CACHE_TABLE_NAME = new PropertyDescriptor.Builder().name("HBase Cache Table Name").description("Name of the table on HBase to use for the cache.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor HBASE_COLUMN_FAMILY = new PropertyDescriptor.Builder().name("HBase Column Family").description("Name of the column family on HBase to use for the cache.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("f").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor HBASE_COLUMN_QUALIFIER = new PropertyDescriptor.Builder().name("HBase Column Qualifier").description("Name of the column qualifier on HBase to use for the cache").defaultValue("q").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private volatile String hBaseCacheTableName;
    private volatile HBaseClientService hBaseClientService;
    private volatile String hBaseColumnFamily;
    private volatile byte[] hBaseColumnFamilyBytes;
    private volatile String hBaseColumnQualifier;
    private volatile byte[] hBaseColumnQualifierBytes;
    private List<String> authorizations;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(HBASE_CACHE_TABLE_NAME);
        descriptors.add(VisibilityLabelUtils.AUTHORIZATIONS);
        descriptors.add(HBASE_CLIENT_SERVICE);
        descriptors.add(HBASE_COLUMN_FAMILY);
        descriptors.add(HBASE_COLUMN_QUALIFIER);
        return descriptors;
    }

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.hBaseClientService = (HBaseClientService)context.getProperty(HBASE_CLIENT_SERVICE).asControllerService(HBaseClientService.class);
        this.hBaseCacheTableName = context.getProperty(HBASE_CACHE_TABLE_NAME).evaluateAttributeExpressions().getValue();
        this.hBaseColumnFamily = context.getProperty(HBASE_COLUMN_FAMILY).evaluateAttributeExpressions().getValue();
        this.hBaseColumnQualifier = context.getProperty(HBASE_COLUMN_QUALIFIER).evaluateAttributeExpressions().getValue();
        this.hBaseColumnFamilyBytes = this.hBaseColumnFamily.getBytes(StandardCharsets.UTF_8);
        this.hBaseColumnQualifierBytes = this.hBaseColumnQualifier.getBytes(StandardCharsets.UTF_8);
        this.authorizations = VisibilityLabelUtils.getAuthorizations(context);
    }

    private <T> byte[] serialize(T value, Serializer<T> serializer) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.serialize(value, (OutputStream)baos);
        return baos.toByteArray();
    }

    private <T> T deserialize(byte[] value, Deserializer<T> deserializer) throws IOException {
        return (T)deserializer.deserialize(value);
    }

    public <K, V> boolean putIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        byte[] rowIdBytes = this.serialize(key, keySerializer);
        byte[] valueBytes = this.serialize(value, valueSerializer);
        PutColumn putColumn = new PutColumn(this.hBaseColumnFamilyBytes, this.hBaseColumnQualifierBytes, valueBytes);
        return this.hBaseClientService.checkAndPut(this.hBaseCacheTableName, rowIdBytes, this.hBaseColumnFamilyBytes, this.hBaseColumnQualifierBytes, null, putColumn);
    }

    public <K, V> void put(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer) throws IOException {
        ArrayList<PutColumn> putColumns = new ArrayList<PutColumn>(1);
        byte[] rowIdBytes = this.serialize(key, keySerializer);
        byte[] valueBytes = this.serialize(value, valueSerializer);
        PutColumn putColumn = new PutColumn(this.hBaseColumnFamilyBytes, this.hBaseColumnQualifierBytes, valueBytes);
        putColumns.add(putColumn);
        this.hBaseClientService.put(this.hBaseCacheTableName, rowIdBytes, putColumns);
    }

    public <K> boolean containsKey(K key, Serializer<K> keySerializer) throws IOException {
        byte[] rowIdBytes = this.serialize(key, keySerializer);
        HBaseRowHandler handler = new HBaseRowHandler();
        ArrayList columnsList = new ArrayList(0);
        this.hBaseClientService.scan(this.hBaseCacheTableName, rowIdBytes, rowIdBytes, columnsList, this.authorizations, (ResultHandler)handler);
        return handler.numRows() > 0;
    }

    public <K, V> V getAndPutIfAbsent(K key, V value, Serializer<K> keySerializer, Serializer<V> valueSerializer, Deserializer<V> valueDeserializer) throws IOException {
        V got = this.get(key, keySerializer, valueDeserializer);
        boolean wasAbsent = this.putIfAbsent(key, value, keySerializer, valueSerializer);
        if (!wasAbsent) {
            return got;
        }
        return null;
    }

    public <K, V> V get(K key, Serializer<K> keySerializer, Deserializer<V> valueDeserializer) throws IOException {
        byte[] rowIdBytes = this.serialize(key, keySerializer);
        HBaseRowHandler handler = new HBaseRowHandler();
        ArrayList columnsList = new ArrayList(0);
        this.hBaseClientService.scan(this.hBaseCacheTableName, rowIdBytes, rowIdBytes, columnsList, this.authorizations, (ResultHandler)handler);
        if (handler.numRows() > 1) {
            throw new IOException("Found multiple rows in HBase for key");
        }
        if (handler.numRows() == 1) {
            return this.deserialize(handler.getLastResultBytes(), valueDeserializer);
        }
        return null;
    }

    public <K> boolean remove(K key, Serializer<K> keySerializer) throws IOException {
        boolean contains = this.containsKey(key, keySerializer);
        if (contains) {
            byte[] rowIdBytes = this.serialize(key, keySerializer);
            this.hBaseClientService.delete(this.hBaseCacheTableName, rowIdBytes);
        }
        return contains;
    }

    public long removeByPattern(String regex) throws IOException {
        throw new IOException("HBase removeByPattern is not implemented");
    }

    public void close() throws IOException {
    }

    protected void finalize() throws Throwable {
    }

    private class HBaseRowHandler
    implements ResultHandler {
        private int numRows = 0;
        private byte[] lastResultBytes;

        private HBaseRowHandler() {
        }

        public void handle(byte[] row, ResultCell[] resultCells) {
            ++this.numRows;
            for (ResultCell resultCell : resultCells) {
                this.lastResultBytes = Arrays.copyOfRange(resultCell.getValueArray(), resultCell.getValueOffset(), resultCell.getValueLength() + resultCell.getValueOffset());
            }
        }

        public int numRows() {
            return this.numRows;
        }

        public byte[] getLastResultBytes() {
            return this.lastResultBytes;
        }
    }
}

