/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.hbase;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.RequiresInstanceClassLoading;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.hadoop.KerberosProperties;
import org.apache.nifi.hadoop.SecurityUtil;
import org.apache.nifi.hbase.DeleteRequest;
import org.apache.nifi.hbase.HBaseClientService;
import org.apache.nifi.hbase.put.PutColumn;
import org.apache.nifi.hbase.put.PutFlowFile;
import org.apache.nifi.hbase.scan.Column;
import org.apache.nifi.hbase.scan.ResultCell;
import org.apache.nifi.hbase.scan.ResultHandler;
import org.apache.nifi.hbase.validate.ConfigFilesValidator;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresInstanceClassLoading
@Tags(value={"hbase", "client"})
@CapabilityDescription(value="Implementation of HBaseClientService using the HBase 1.1.x client. Although this service was originally built with the 1.1.2 client and has 1_1_2 in it's name, the client library has since been upgraded to 1.1.13 to leverage bug fixes. This service can be configured by providing a comma-separated list of configuration files, or by specifying values for the other properties. If configuration files are provided, they will be loaded first, and the values of the additional properties will override the values from the configuration files. In addition, any user defined properties on the processor will also be passed to the HBase configuration.")
@DynamicProperty(name="The name of an HBase configuration property.", value="The value of the given HBase configuration property.", description="These properties will be set on the HBase configuration after loading any provided configuration files.")
public class HBase_2_ClientService
extends AbstractControllerService
implements HBaseClientService {
    private static final String ALLOW_EXPLICIT_KEYTAB = "NIFI_ALLOW_EXPLICIT_KEYTAB";
    private static final Logger logger = LoggerFactory.getLogger(HBase_2_ClientService.class);
    static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Specifies the Kerberos Credentials Controller Service that should be used for authenticating with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    static final PropertyDescriptor HADOOP_CONF_FILES = new PropertyDescriptor.Builder().name("Hadoop Configuration Files").description("Comma-separated list of Hadoop Configuration files, such as hbase-site.xml and core-site.xml for kerberos, including full paths to the files.").addValidator((Validator)new ConfigFilesValidator()).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor ZOOKEEPER_QUORUM = new PropertyDescriptor.Builder().name("ZooKeeper Quorum").description("Comma-separated list of ZooKeeper hosts for HBase. Required if Hadoop Configuration Files are not provided.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor ZOOKEEPER_CLIENT_PORT = new PropertyDescriptor.Builder().name("ZooKeeper Client Port").description("The port on which ZooKeeper is accepting client connections. Required if Hadoop Configuration Files are not provided.").addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor ZOOKEEPER_ZNODE_PARENT = new PropertyDescriptor.Builder().name("ZooKeeper ZNode Parent").description("The ZooKeeper ZNode Parent value for HBase (example: /hbase). Required if Hadoop Configuration Files are not provided.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor HBASE_CLIENT_RETRIES = new PropertyDescriptor.Builder().name("HBase Client Retries").description("The number of times the HBase client will retry connecting. Required if Hadoop Configuration Files are not provided.").addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).defaultValue("1").expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor PHOENIX_CLIENT_JAR_LOCATION = new PropertyDescriptor.Builder().name("Phoenix Client JAR Location").description("The full path to the Phoenix client JAR. Required if Phoenix is installed on top of HBase.").addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dynamicallyModifiesClasspath(true).build();
    static final String HBASE_CONF_ZK_QUORUM = "hbase.zookeeper.quorum";
    static final String HBASE_CONF_ZK_PORT = "hbase.zookeeper.property.clientPort";
    static final String HBASE_CONF_ZNODE_PARENT = "zookeeper.znode.parent";
    static final String HBASE_CONF_CLIENT_RETRIES = "hbase.client.retries.number";
    private volatile Connection connection;
    private volatile UserGroupInformation ugi;
    private volatile String masterAddress;
    private List<PropertyDescriptor> properties;
    private KerberosProperties kerberosProperties;
    private volatile File kerberosConfigFile = null;
    private final AtomicReference<ValidationResources> validationResourceHolder = new AtomicReference();

    protected Connection getConnection() {
        return this.connection;
    }

    protected void setConnection(Connection connection) {
        this.connection = connection;
    }

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
        this.kerberosConfigFile = config.getKerberosConfigurationFile();
        this.kerberosProperties = this.getKerberosProperties(this.kerberosConfigFile);
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(HADOOP_CONF_FILES);
        props.add(KERBEROS_CREDENTIALS_SERVICE);
        props.add(this.kerberosProperties.getKerberosPrincipal());
        props.add(this.kerberosProperties.getKerberosKeytab());
        props.add(ZOOKEEPER_QUORUM);
        props.add(ZOOKEEPER_CLIENT_PORT);
        props.add(ZOOKEEPER_ZNODE_PARENT);
        props.add(HBASE_CLIENT_RETRIES);
        props.add(PHOENIX_CLIENT_JAR_LOCATION);
        props.addAll(this.getAdditionalProperties());
        this.properties = Collections.unmodifiableList(props);
    }

    protected List<PropertyDescriptor> getAdditionalProperties() {
        return new ArrayList<PropertyDescriptor>();
    }

    protected KerberosProperties getKerberosProperties(File kerberosConfigFile) {
        return new KerberosProperties(kerberosConfigFile);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().description("Specifies the value for '" + propertyDescriptorName + "' in the HBase configuration.").name(propertyDescriptorName).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dynamic(true).build();
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        String allowExplicitKeytabVariable;
        String resolvedKeytab;
        String resolvedPrincipal;
        boolean confFileProvided = validationContext.getProperty(HADOOP_CONF_FILES).isSet();
        boolean zkQuorumProvided = validationContext.getProperty(ZOOKEEPER_QUORUM).isSet();
        boolean zkPortProvided = validationContext.getProperty(ZOOKEEPER_CLIENT_PORT).isSet();
        boolean znodeParentProvided = validationContext.getProperty(ZOOKEEPER_ZNODE_PARENT).isSet();
        boolean retriesProvided = validationContext.getProperty(HBASE_CLIENT_RETRIES).isSet();
        String explicitPrincipal = validationContext.getProperty(this.kerberosProperties.getKerberosPrincipal()).evaluateAttributeExpressions().getValue();
        String explicitKeytab = validationContext.getProperty(this.kerberosProperties.getKerberosKeytab()).evaluateAttributeExpressions().getValue();
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)validationContext.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (credentialsService == null) {
            resolvedPrincipal = explicitPrincipal;
            resolvedKeytab = explicitKeytab;
        } else {
            resolvedPrincipal = credentialsService.getPrincipal();
            resolvedKeytab = credentialsService.getKeytab();
        }
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        if (!(confFileProvided || zkQuorumProvided && zkPortProvided && znodeParentProvided && retriesProvided)) {
            problems.add(new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation("ZooKeeper Quorum, ZooKeeper Client Port, ZooKeeper ZNode Parent, and HBase Client Retries are required when Hadoop Configuration Files are not provided.").build());
        }
        if (confFileProvided) {
            String configFiles = validationContext.getProperty(HADOOP_CONF_FILES).evaluateAttributeExpressions().getValue();
            ValidationResources resources = this.validationResourceHolder.get();
            if (resources == null || !configFiles.equals(resources.getConfigResources())) {
                this.getLogger().debug("Reloading validation resources");
                resources = new ValidationResources(configFiles, this.getConfigurationFromFiles(configFiles));
                this.validationResourceHolder.set(resources);
            }
            Configuration hbaseConfig = resources.getConfiguration();
            problems.addAll(KerberosProperties.validatePrincipalAndKeytab((String)((Object)((Object)this)).getClass().getSimpleName(), (Configuration)hbaseConfig, (String)resolvedPrincipal, (String)resolvedKeytab, (ComponentLog)this.getLogger()));
        }
        if (credentialsService != null && (explicitPrincipal != null || explicitKeytab != null)) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("Cannot specify both a Kerberos Credentials Service and a principal/keytab").build());
        }
        if ("false".equalsIgnoreCase(allowExplicitKeytabVariable = System.getenv(ALLOW_EXPLICIT_KEYTAB)) && (explicitPrincipal != null || explicitKeytab != null)) {
            problems.add(new ValidationResult.Builder().subject("Kerberos Credentials").valid(false).explanation("The 'NIFI_ALLOW_EXPLICIT_KEYTAB' system environment variable is configured to forbid explicitly configuring principal/keytab in processors. The Kerberos Credentials Service should be used instead of setting the Kerberos Keytab or Kerberos Principal property.").build());
        }
        return problems;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException, IOException, InterruptedException {
        Admin admin;
        this.connection = this.createConnection(context);
        if (this.connection != null && (admin = this.connection.getAdmin()) != null) {
            admin.listTableNames();
            ClusterStatus clusterStatus = admin.getClusterStatus();
            if (clusterStatus != null) {
                ServerName master = clusterStatus.getMaster();
                this.masterAddress = master != null ? master.getHostAndPort() : null;
            }
        }
    }

    protected Connection createConnection(ConfigurationContext context) throws IOException, InterruptedException {
        String configFiles = context.getProperty(HADOOP_CONF_FILES).evaluateAttributeExpressions().getValue();
        final Configuration hbaseConfig = this.getConfigurationFromFiles(configFiles);
        if (context.getProperty(ZOOKEEPER_QUORUM).isSet()) {
            hbaseConfig.set(HBASE_CONF_ZK_QUORUM, context.getProperty(ZOOKEEPER_QUORUM).evaluateAttributeExpressions().getValue());
        }
        if (context.getProperty(ZOOKEEPER_CLIENT_PORT).isSet()) {
            hbaseConfig.set(HBASE_CONF_ZK_PORT, context.getProperty(ZOOKEEPER_CLIENT_PORT).evaluateAttributeExpressions().getValue());
        }
        if (context.getProperty(ZOOKEEPER_ZNODE_PARENT).isSet()) {
            hbaseConfig.set(HBASE_CONF_ZNODE_PARENT, context.getProperty(ZOOKEEPER_ZNODE_PARENT).evaluateAttributeExpressions().getValue());
        }
        if (context.getProperty(HBASE_CLIENT_RETRIES).isSet()) {
            hbaseConfig.set(HBASE_CONF_CLIENT_RETRIES, context.getProperty(HBASE_CLIENT_RETRIES).evaluateAttributeExpressions().getValue());
        }
        for (Map.Entry entry : context.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (!descriptor.isDynamic()) continue;
            hbaseConfig.set(descriptor.getName(), (String)entry.getValue());
        }
        if (SecurityUtil.isSecurityEnabled((Configuration)hbaseConfig)) {
            String principal = context.getProperty(this.kerberosProperties.getKerberosPrincipal()).evaluateAttributeExpressions().getValue();
            String keyTab = context.getProperty(this.kerberosProperties.getKerberosKeytab()).evaluateAttributeExpressions().getValue();
            KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
            if (credentialsService != null) {
                principal = credentialsService.getPrincipal();
                keyTab = credentialsService.getKeytab();
            }
            this.getLogger().info("HBase Security Enabled, logging in as principal {} with keytab {}", new Object[]{principal, keyTab});
            this.ugi = SecurityUtil.loginKerberos((Configuration)hbaseConfig, (String)principal, (String)keyTab);
            this.getLogger().info("Successfully logged in as principal {} with keytab {}", new Object[]{principal, keyTab});
            return (Connection)this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

                @Override
                public Connection run() throws Exception {
                    return ConnectionFactory.createConnection((Configuration)hbaseConfig);
                }
            });
        }
        this.getLogger().info("Simple Authentication");
        return ConnectionFactory.createConnection((Configuration)hbaseConfig);
    }

    protected Configuration getConfigurationFromFiles(String configFiles) {
        Configuration hbaseConfig = HBaseConfiguration.create();
        if (StringUtils.isNotBlank((CharSequence)configFiles)) {
            for (String configFile : configFiles.split(",")) {
                hbaseConfig.addResource(new Path(configFile.trim()));
            }
        }
        return hbaseConfig;
    }

    @OnDisabled
    public void shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException ioe) {
                this.getLogger().warn("Failed to close connection to HBase due to {}", new Object[]{ioe});
            }
        }
    }

    private List<Put> buildPuts(byte[] rowKey, List<PutColumn> columns) {
        ArrayList<Put> retVal = new ArrayList<Put>();
        try {
            Put put = null;
            for (PutColumn column : columns) {
                if (put == null || put.getCellVisibility() == null && column.getVisibility() != null || put.getCellVisibility() != null && !put.getCellVisibility().getExpression().equals(column.getVisibility())) {
                    put = new Put(rowKey);
                    if (column.getVisibility() != null) {
                        put.setCellVisibility(new CellVisibility(column.getVisibility()));
                    }
                    retVal.add(put);
                }
                if (column.getTimestamp() != null) {
                    put.addColumn(column.getColumnFamily(), column.getColumnQualifier(), column.getTimestamp().longValue(), column.getBuffer());
                    continue;
                }
                put.addColumn(column.getColumnFamily(), column.getColumnQualifier(), column.getBuffer());
            }
        }
        catch (DeserializationException de) {
            this.getLogger().error("Error writing cell visibility statement.", (Throwable)de);
            throw new RuntimeException(de);
        }
        return retVal;
    }

    public void put(String tableName, Collection<PutFlowFile> puts) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            HashMap sorted = new HashMap();
            ArrayList<Put> newPuts = new ArrayList<Put>();
            for (PutFlowFile putFlowFile : puts) {
                String rowKeyString = new String(putFlowFile.getRow(), StandardCharsets.UTF_8);
                ArrayList columns = (ArrayList)sorted.get(rowKeyString);
                if (columns == null) {
                    columns = new ArrayList();
                    sorted.put(rowKeyString, columns);
                }
                columns.addAll(putFlowFile.getColumns());
            }
            for (Map.Entry entry : sorted.entrySet()) {
                newPuts.addAll(this.buildPuts(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8), (List)entry.getValue()));
            }
            table.put(newPuts);
        }
    }

    public void put(String tableName, byte[] rowId, Collection<PutColumn> columns) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            table.put(this.buildPuts(rowId, new ArrayList<PutColumn>(columns)));
        }
    }

    public boolean checkAndPut(String tableName, byte[] rowId, byte[] family, byte[] qualifier, byte[] value, PutColumn column) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            Put put = new Put(rowId);
            put.addColumn(column.getColumnFamily(), column.getColumnQualifier(), column.getBuffer());
            boolean bl = table.checkAndPut(rowId, family, qualifier, value, put);
            return bl;
        }
    }

    public void delete(String tableName, byte[] rowId) throws IOException {
        this.delete(tableName, rowId, null);
    }

    public void delete(String tableName, byte[] rowId, String visibilityLabel) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            Delete delete = new Delete(rowId);
            if (!StringUtils.isEmpty((CharSequence)visibilityLabel)) {
                delete.setCellVisibility(new CellVisibility(visibilityLabel));
            }
            table.delete(delete);
        }
    }

    public void delete(String tableName, List<byte[]> rowIds) throws IOException {
        this.delete(tableName, rowIds);
    }

    public void deleteCells(String tableName, List<DeleteRequest> deletes) throws IOException {
        ArrayList<Delete> deleteRequests = new ArrayList<Delete>();
        for (int index = 0; index < deletes.size(); ++index) {
            DeleteRequest req = deletes.get(index);
            Delete delete = new Delete(req.getRowId()).addColumn(req.getColumnFamily(), req.getColumnQualifier());
            if (!StringUtils.isEmpty((CharSequence)req.getVisibilityLabel())) {
                delete.setCellVisibility(new CellVisibility(req.getVisibilityLabel()));
            }
            deleteRequests.add(delete);
        }
        this.batchDelete(tableName, deleteRequests);
    }

    public void delete(String tableName, List<byte[]> rowIds, String visibilityLabel) throws IOException {
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (int index = 0; index < rowIds.size(); ++index) {
            Delete delete = new Delete(rowIds.get(index));
            if (!StringUtils.isBlank((CharSequence)visibilityLabel)) {
                delete.setCellVisibility(new CellVisibility(visibilityLabel));
            }
            deletes.add(delete);
        }
        this.batchDelete(tableName, deletes);
    }

    private void batchDelete(String tableName, List<Delete> deletes) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            table.delete(deletes);
        }
    }

    public void scan(String tableName, Collection<Column> columns, String filterExpression, long minTime, ResultHandler handler) throws IOException {
        this.scan(tableName, columns, filterExpression, minTime, null, handler);
    }

    public void scan(String tableName, Collection<Column> columns, String filterExpression, long minTime, List<String> visibilityLabels, ResultHandler handler) throws IOException {
        Filter filter = null;
        if (!StringUtils.isBlank((CharSequence)filterExpression)) {
            ParseFilter parseFilter = new ParseFilter();
            filter = parseFilter.parseFilterString(filterExpression);
        }
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));
             ResultScanner scanner = this.getResults(table, columns, filter, minTime, visibilityLabels);){
            for (Result result : scanner) {
                byte[] rowKey = result.getRow();
                Cell[] cells = result.rawCells();
                if (cells == null) continue;
                ResultCell[] resultCells = new ResultCell[cells.length];
                for (int i = 0; i < cells.length; ++i) {
                    ResultCell resultCell;
                    Cell cell = cells[i];
                    resultCells[i] = resultCell = this.getResultCell(cell);
                }
                handler.handle(rowKey, resultCells);
            }
        }
    }

    public void scan(String tableName, byte[] startRow, byte[] endRow, Collection<Column> columns, List<String> authorizations, ResultHandler handler) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));
             ResultScanner scanner = this.getResults(table, startRow, endRow, columns, authorizations);){
            for (Result result : scanner) {
                byte[] rowKey = result.getRow();
                Cell[] cells = result.rawCells();
                if (cells == null) continue;
                ResultCell[] resultCells = new ResultCell[cells.length];
                for (int i = 0; i < cells.length; ++i) {
                    ResultCell resultCell;
                    Cell cell = cells[i];
                    resultCells[i] = resultCell = this.getResultCell(cell);
                }
                handler.handle(rowKey, resultCells);
            }
        }
    }

    public void scan(String tableName, String startRow, String endRow, String filterExpression, Long timerangeMin, Long timerangeMax, Integer limitRows, Boolean isReversed, Collection<Column> columns, List<String> visibilityLabels, ResultHandler handler) throws IOException {
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));
             ResultScanner scanner = this.getResults(table, startRow, endRow, filterExpression, timerangeMin, timerangeMax, limitRows, isReversed, columns, visibilityLabels);){
            int cnt = 0;
            int lim = limitRows != null ? limitRows : 0;
            for (Result result : scanner) {
                if (lim > 0 && ++cnt > lim) {
                    break;
                }
                byte[] rowKey = result.getRow();
                Cell[] cells = result.rawCells();
                if (cells == null) continue;
                ResultCell[] resultCells = new ResultCell[cells.length];
                for (int i = 0; i < cells.length; ++i) {
                    ResultCell resultCell;
                    Cell cell = cells[i];
                    resultCells[i] = resultCell = this.getResultCell(cell);
                }
                handler.handle(rowKey, resultCells);
            }
        }
    }

    protected ResultScanner getResults(Table table, String startRow, String endRow, String filterExpression, Long timerangeMin, Long timerangeMax, Integer limitRows, Boolean isReversed, Collection<Column> columns, List<String> authorizations) throws IOException {
        Scan scan = new Scan();
        if (!StringUtils.isBlank((CharSequence)startRow)) {
            scan.setStartRow(startRow.getBytes(StandardCharsets.UTF_8));
        }
        if (!StringUtils.isBlank((CharSequence)endRow)) {
            scan.setStopRow(endRow.getBytes(StandardCharsets.UTF_8));
        }
        if (authorizations != null && authorizations.size() > 0) {
            scan.setAuthorizations(new Authorizations(authorizations));
        }
        Filter filter = null;
        if (columns != null) {
            for (Column col : columns) {
                if (col.getQualifier() == null) {
                    scan.addFamily(col.getFamily());
                    continue;
                }
                scan.addColumn(col.getFamily(), col.getQualifier());
            }
        }
        if (!StringUtils.isBlank((CharSequence)filterExpression)) {
            ParseFilter parseFilter = new ParseFilter();
            filter = parseFilter.parseFilterString(filterExpression);
        }
        if (filter != null) {
            scan.setFilter(filter);
        }
        if (timerangeMin != null && timerangeMax != null) {
            scan.setTimeRange(timerangeMin.longValue(), timerangeMax.longValue());
        }
        if (isReversed != null) {
            scan.setReversed(isReversed.booleanValue());
        }
        return table.getScanner(scan);
    }

    protected ResultScanner getResults(Table table, byte[] startRow, byte[] endRow, Collection<Column> columns, List<String> authorizations) throws IOException {
        Scan scan = new Scan();
        scan.setStartRow(startRow);
        scan.setStopRow(endRow);
        if (authorizations != null && authorizations.size() > 0) {
            scan.setAuthorizations(new Authorizations(authorizations));
        }
        if (columns != null && columns.size() > 0) {
            for (Column col : columns) {
                if (col.getQualifier() == null) {
                    scan.addFamily(col.getFamily());
                    continue;
                }
                scan.addColumn(col.getFamily(), col.getQualifier());
            }
        }
        return table.getScanner(scan);
    }

    protected ResultScanner getResults(Table table, Collection<Column> columns, Filter filter, long minTime, List<String> authorizations) throws IOException {
        Scan scan = new Scan();
        scan.setTimeRange(minTime, Long.MAX_VALUE);
        if (authorizations != null && authorizations.size() > 0) {
            scan.setAuthorizations(new Authorizations(authorizations));
        }
        if (filter != null) {
            scan.setFilter(filter);
        }
        if (columns != null) {
            for (Column col : columns) {
                if (col.getQualifier() == null) {
                    scan.addFamily(col.getFamily());
                    continue;
                }
                scan.addColumn(col.getFamily(), col.getQualifier());
            }
        }
        return table.getScanner(scan);
    }

    private ResultCell getResultCell(Cell cell) {
        ResultCell resultCell = new ResultCell();
        resultCell.setRowArray(cell.getRowArray());
        resultCell.setRowOffset(cell.getRowOffset());
        resultCell.setRowLength(cell.getRowLength());
        resultCell.setFamilyArray(cell.getFamilyArray());
        resultCell.setFamilyOffset(cell.getFamilyOffset());
        resultCell.setFamilyLength(cell.getFamilyLength());
        resultCell.setQualifierArray(cell.getQualifierArray());
        resultCell.setQualifierOffset(cell.getQualifierOffset());
        resultCell.setQualifierLength(cell.getQualifierLength());
        resultCell.setTimestamp(cell.getTimestamp());
        resultCell.setTypeByte(cell.getTypeByte());
        resultCell.setSequenceId(cell.getSequenceId());
        resultCell.setValueArray(cell.getValueArray());
        resultCell.setValueOffset(cell.getValueOffset());
        resultCell.setValueLength(cell.getValueLength());
        resultCell.setTagsArray(cell.getTagsArray());
        resultCell.setTagsOffset(cell.getTagsOffset());
        resultCell.setTagsLength(cell.getTagsLength());
        return resultCell;
    }

    public byte[] toBytes(boolean b) {
        return Bytes.toBytes((boolean)b);
    }

    public byte[] toBytes(float f) {
        return Bytes.toBytes((float)f);
    }

    public byte[] toBytes(int i) {
        return Bytes.toBytes((int)i);
    }

    public byte[] toBytes(long l) {
        return Bytes.toBytes((long)l);
    }

    public byte[] toBytes(double d) {
        return Bytes.toBytes((double)d);
    }

    public byte[] toBytes(String s) {
        return Bytes.toBytes((String)s);
    }

    public byte[] toBytesBinary(String s) {
        return Bytes.toBytesBinary((String)s);
    }

    public String toTransitUri(String tableName, String rowKey) {
        if (this.connection == null) {
            logger.warn("Connection has not been established, could not create a transit URI. Returning null.");
            return null;
        }
        String transitUriMasterAddress = StringUtils.isEmpty((CharSequence)this.masterAddress) ? "unknown" : this.masterAddress;
        return "hbase://" + transitUriMasterAddress + "/" + tableName + (StringUtils.isEmpty((CharSequence)rowKey) ? "" : "/" + rowKey);
    }

    protected static class ValidationResources {
        private final String configResources;
        private final Configuration configuration;

        public ValidationResources(String configResources, Configuration configuration) {
            this.configResources = configResources;
            this.configuration = configuration;
        }

        public String getConfigResources() {
            return this.configResources;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }
    }
}

