/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.streaming;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.streaming.AbstractRecordWriter;
import org.apache.hive.streaming.NiFiRecordSerDe;
import org.apache.hive.streaming.SerializationError;
import org.apache.hive.streaming.StreamingException;
import org.apache.hive.streaming.StreamingIOFailure;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.record.Record;

public class HiveRecordWriter
extends AbstractRecordWriter {
    private RecordReader recordReader;
    private NiFiRecordSerDe serde;
    private ComponentLog log;

    public HiveRecordWriter(RecordReader recordReader, ComponentLog log) {
        super(null);
        this.recordReader = recordReader;
        this.log = log;
    }

    public AbstractSerDe createSerde() throws SerializationError {
        try {
            Properties tableProps = this.table.getMetadata();
            tableProps.setProperty("columns", Joiner.on((String)",").join((Iterable)this.inputColumns));
            tableProps.setProperty("columns.types", Joiner.on((String)":").join((Iterable)this.inputTypes));
            NiFiRecordSerDe serde = new NiFiRecordSerDe(this.recordReader, this.log);
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)this.conf, (Properties)tableProps, null);
            this.serde = serde;
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde " + NiFiRecordSerDe.class.getName(), (Exception)((Object)e));
        }
    }

    public Object encode(byte[] bytes) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " does not support encoding of records via bytes, only via an InputStream");
    }

    public void write(long writeId, byte[] record) {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " does not support writing of records via bytes, only via an InputStream");
    }

    public void write(long writeId, InputStream inputStream) throws StreamingException {
        try {
            Record record;
            while ((record = this.recordReader.nextRecord()) != null) {
                this.write(writeId, record);
            }
        }
        catch (IOException | MalformedRecordException e) {
            throw new StreamingException(e.getLocalizedMessage(), e);
        }
    }

    public Object encode(Record record) throws SerializationError {
        try {
            ObjectWritable blob = new ObjectWritable((Object)record);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert Record into Object", (Exception)((Object)e));
        }
    }

    private void write(long writeId, Record record) throws StreamingException {
        this.checkAutoFlush();
        try {
            Object encodedRow = this.encode(record);
            int bucket = this.getBucket(encodedRow);
            List partitionValues = this.getPartitionValues(encodedRow);
            this.getRecordUpdater(partitionValues, bucket).insert(writeId, encodedRow);
            this.conn.getConnectionStats().incrementRecordsWritten();
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Error writing record in transaction write id (" + writeId + ")", (Exception)e);
        }
    }
}

